/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.fw.ex.unit.mock.file;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.ex.unit.mock.AbstractMockDao;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;

/**
 * {@link FileUpdateDAO}̃bNNXłB
 * <p>
 * {@link FileUpdateDAO#execute(String, Class)}̕Ԃl
 * {@link MockFileUpdateDao#addResult(FileLineWriter)}ɂĐݒł܂B
 * </p>
 * <p>
 * ȉɗ܂B Ɩɂďo͂t@Cȉ̏ꍇA
 * </p>
 * 
 * <pre>
 * aaa1,bbb1
 * aaa2,bbb2
 * </pre>
 * <p>
 * R[ĥ͎悤ɂȂ܂B
 * </p>
 * 
 * <pre>
 * // bN
 * MockFileUpdateDao fileUpdateDao = new MockFileUpdateDao();
 * MockFileLineWriter&lt;TestData&gt; fileLineWriter = new MockFileLineWriter&lt;TestData&gt;();
 * fileUpdateDao.addResult(fileLineWriter);
 * 
 * XxxBLogic blogic = new XxxBLogic();
 * blogic.setFileUpdateDAO(fileUpdateDao);
 * blogic.execute(XXXX); // eXg\bhs
 * 
 * // Ғlf[^pӁiƖŏo͂f[^j
 * TestData data1 = new TestData();
 * data1.setTest1(&quot;aaa1&quot;);
 * data1.setTest2(&quot;bbb1&quot;);
 * TestData data2 = new TestData();
 * data2.setTest1(&quot;aaa2&quot;);
 * data2.setTest2(&quot;bbb2&quot;);
 * 
 * // o̓f[^̊mF
 * AssertUtils.assertCollectionEquals(Arrays.asList(data1, data2),
 *         fileLineWriter.getPrintDataLineList());
 * // writerN[YĂ邱ƂmF
 * assertTrue(fileLineWriter.isClosed());
 * // o̓t@CmF
 * assertEquals(&quot;output.csv&quot;, fileUpdateDao.getFileDaoParams().get(0)
 *         .getFileName());
 * </pre>
 */
public class MockFileUpdateDao extends AbstractMockDao implements FileUpdateDAO {

    /**
     * \bhs񃊃Xg
     */
    private final List<FileDaoParam> fileDaoParams = new ArrayList<FileDaoParam>();

    /**
     * <p>
     * FileUpdateDAO#execute() ̃bN\bhB
     * </p>
     *  params Ɋi[Aresults̐擪 IuWFNgoĕԋp܂B
     * 
     * @param fileName t@C
     * @param clazz NX
     * @return s
     */
    @SuppressWarnings("unchecked")
    public <T> FileLineWriter<T> execute(String fileName, Class<T> clazz) {

        FileDaoParam param = new FileDaoParam();
        param.setFileName(fileName);
        param.setClazz(clazz);
        this.fileDaoParams.add(param);

        Object result = poll();

        if (result != null && result instanceof FileLineWriter) {
            return (FileLineWriter<T>) result;
        } else {
            throw new ClassCastException(
                    "FileLineWriter was expected but the actual was " + result);
        }
    }

    /**
     * <p>
     * \bhs񃊃Xgԋp܂B
     * </p>
     * 
     * @return \bhs񃊃Xg
     */
    public List<FileDaoParam> getFileDaoParams() {
        return this.fileDaoParams;
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.ex.unit.mock.AbstractMockDao#clear()
     */
    public void clear() {
        super.clear();
        fileDaoParams.clear();
    }

    /**
     * {@link FileUpdateDAO#execute(String, Class)}̕ԂlƂȂ
     * {@link FileLineWriter}ݒ肵܂B
     * 
     * @param fileLineWriter {@link FileUpdateDAO#execute(String, Class)}̕ԂlƂȂ
     *            {@link FileLineWriter}IuWFNg
     */
    public void addResult(FileLineWriter<?> fileLineWriter) {
        super.addResult(fileLineWriter);
    }

}
