/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jp.terasoluna.fw.ex.unit.common.PropertyKeys;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.util.ClassLoaderUtils;
import org.springframework.util.Assert;

public class DefaultProperties {
    private static final String DEFAULT_FILE_PATH = "terasoluna-unit.properties";
    private static final String OVERRIDE_FILE_PATH = "terasoluna-unit-override.properties";
    private static final ConcurrentMap<String, String> properties = new ConcurrentHashMap<String, String>();

    static {
        Properties defaults = new Properties();
        Properties override = new Properties();
        DefaultProperties.loadProperties(defaults, DEFAULT_FILE_PATH);
        DefaultProperties.loadProperties(override, OVERRIDE_FILE_PATH);
        for (Map.Entry<Object, Object> e : defaults.entrySet()) {
            properties.put((String)e.getKey(), (String)e.getValue());
        }
        for (Map.Entry<Object, Object> e : override.entrySet()) {
            properties.put((String)e.getKey(), (String)e.getValue());
        }
    }

    private static void loadProperties(Properties props, String filePath) throws UTRuntimeException {
        InputStream strm;
        Assert.notNull((Object)props);
        Assert.notNull((Object)filePath);
        ClassLoader cl = ClassLoaderUtils.getClassLoader();
        if (cl != null && (strm = cl.getResourceAsStream(filePath)) != null) {
            try {
                props.load(strm);
            }
            catch (IOException e) {
                throw new UTRuntimeException(e);
            }
        }
    }

    public static String getValue(String key) {
        return (String)properties.get(key);
    }

    public static String getValue(PropertyKeys key) {
        return DefaultProperties.getValue(key.getKey());
    }
}

