/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import org.springframework.validation.Errors;
import org.springmodules.validation.commons.DefaultBeanValidator;

/**
 * փ`FbNsȂۃNXB
 * 
 * <p>Spring-Modules ValidatorɂPڃ`FbNȊOɑւɃ`FbN
 * sȂꍇɎgpB
 * ADBANZXKvȃ`FbN͊eƖNXɂă`FbN邱ƁB
 * TuNX{@link #validateMultiField(Object, Errors)}\bh
 * I[o[ChA`FbNWbNLqB</p>
 * 
 * <h5>TuNX̎</h5>
 * 
 * <p>TuNX{@link #validateMultiField(Object, Errors)}\bh
 * I[o[ChB
 * obj͌ΏۂJavaBeanł邽߁AeJavaBeaň^ɃLXgĂ
 * oB
 * G[ǉꍇAerrorsreject\bhArejectValue\bh
 * sB </p>
 * 
 * <pre>
 * protected void validateMultiField(Object obj, Errors errors) {
 *
 *     // JavaBean̎擾
 *     SampleBean bean = (SampleBean) obj;
 *
 *     // Pڂ̑
 *     String field1 = bean.getField1();
 * 
 *     // Qڂ̑
 *     String field2 = bean.getField2();
 *       
 *     // Pڂ̑ƂQڂ̑ł͂ȂꍇAG[ǉ
 *     if (!field1.equals(field2) {
 *         // G[ǉ
 *         errors.reject("errors.sample");
 *     }
 * }
 * </pre>
 * 
 * <h5>ErrorsC^tF[X̑\IȃG[ǉ\bh</h5>
 * 
 * <table border="1">
 * <tr>
 *  <td><center><b>\bh</b></center></td>
 *  <td><center><b></b></center></td>
 * </tr>
 * 
 * <tr>
 *  <td>void rejectValue(String field, String errorCode)</center></td>
 *  <td>G[ǉBfieldɂJavaBeañvpeBA
 * errorCodeɂ̓\[Xoh̃L[w肷B
 * u񂪂ȂG[ɎgpB</td>
 * </tr>
 * <tr>
 *  <td>void rejectValue(String field, String errorCode, Object[] errorArgs, 
 *  String defaultMessage)</center></td>
 *  <td>G[ǉBfieldAerrorCode͏LƓlBerrorArgs͒uA
 * defaultMessage̓ftHgbZ[Ww肷BiTerasolunał
 * ftHgbZ[W͎gpȂ߁ACӂ̕ݒ肷j</td>
 * </tr>
 * <tr>
 *  <td>void reject(String errorCode)</center></td>
 *  <td>G[ǉB\[Xoh̃L[̂ݎw肷B
 * fieldw肵Ȃփ`FbNɎgpB</td>
 * </tr>
 * <tr>
 *  <td>void reject(String errorCode, Object[] errorArgs, 
 *  String defaultMessage)</center></td>
 *  <td>G[ǉBerrorArgs͒uAdefaultMessage
 *  ftHgbZ[Ww肷BiTerasolunał
 *  ftHgbZ[W͎gpȂ߁ACӂ̕ݒ肷j
 * fieldw肵Ȃփ`FbNɎgpB</td>
 * </tr>
 * </table>
 * 
 * <h5>Bean`t@C̋Lqi̓`FbNNXj</h5>
 * 
 * <p>Springł̓̓`FbN@\gpꍇA
 * ̓`FbNt@Ngi̓`FbNNX̏sȂNXj
 * ̓`FbNNXBean`t@Cɐݒ肷KvB</p>
 * <pre>
 * &lt;!-- ̓`FbNNX̃t@Ng --&gt;
 * &lt;bean id="validatorFactory"     
 *   class="org.springmodules.commons.validator.DefaultValidatorFactory"&gt; 
 *   &lt;property name="validationConfigLocations"&gt; 
 *     &lt;list&gt; 
 *       &lt;!-- ɋLqof[V`t@Civalidation.xmlj
 *            of[V[`t@Civalidation-rules.xmlj
 *            Springt[[Nݒt@CƂĔF --&gt; 
 *       &lt;value&gt;<b>/WEB-INF/validation/validator-rules.xml</b>&lt;/value&gt;
 *       &lt;value&gt;<b>/WEB-INF/validation/validator-rules-ex.xml</b>&lt;/value&gt;
 *       &lt;value&gt;<b>/WEB-INF/validation/validation.xml</b>&lt;/value&gt; 
 *     &lt;/list&gt; 
 *   &lt;/property&gt; 
 * &lt;/bean&gt; 
 *   
 * &lt;!--@փ`FbNsȂ̓`FbNNX 
 *   classɍ쐬փ`FbNNXLq--&gt;
 * &lt;bean id="sampleValidator"  <b>class="jp.terasoluna.sample2.validation.SampleMultiFieldValidator"</b>&gt; 
 *   &lt;property name="validatorFactory"&gt;&lt;ref local="validatorFactory"/&gt;&lt;/property&gt; 
 * &lt;/bean&gt;
 * </pre>
 * 
 * <h5>Bean`t@C̋LqiRg[j</h5>
 * 
 * <p>Bean`t@CŐݒ肵̓`FbN@\gp邽߂ɁA
 * Rg[validatorɏLŐݒ肵̓`FbN@\
 * ݒ肷KvB</p>
 * <pre>
 * &lt;!-- Tv̓`FbNƖ --&gt;
 * &lt;bean name="/secure/blogic/validateSample.do" 
 *   class="jp.terasoluna.sample2.web.controller.ValidateSampleController"
 *   parent="xmlRequestController"&gt;  
 *   &lt;property name="sumService" ref="sumService"/&gt;  
 *   &lt;property name=<b>"validator"</b> ref=<b>gsampleValidator"</b>/&gt;
 *   &lt;property name="commandClass"&gt;
 *     &lt;value&gt;jp.terasoluna.sample2.dto.SampleDto&lt;/value&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * @see org.springmodules.validation.commons.DefaultBeanValidator
 * @see org.springframework.validation.BindException
 * @see org.springframework.validation.Errors
 */
public abstract class BaseMultiFieldValidator extends DefaultBeanValidator {

    /**
     * ̓`FbN\bhB
     * ݒt@CɂPڃ`FbNĂяoA
     * G[Ȃ{@link #validateMultiField(Object, Errors)}
     * \bhĂяoB
     * 
     * @param obj ΏۂJavaBean
     * @param errors G[
     */
    @Override
    public void validate(Object obj, Errors errors) {
        
        // ݒt@CɂPڃ`FbN
        super.validate(obj, errors);
        
        // G[ȂΑփ`FbNsȂ
        if (!errors.hasErrors()) {
            validateMultiField(obj, errors);
        }
    }

    /**
     * փ`FbNsȂ\bhB
     * Pڃ`FbNŃG[ȂꍇAĂяoB
     * TuNX͂̃\bh
     * 
     * @param obj ΏۂJavaBean
     * @param errors G[
     */
    protected abstract void validateMultiField(Object obj, Errors errors);
}
