/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.jta;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.transaction.BaseTransactionConfig;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.jta.JtaTransaction;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class JtaTransactionConfig
extends BaseTransactionConfig {
    private UserTransaction userTransaction;

    public Transaction newTransaction(int transactionIsolation) throws SQLException, TransactionException {
        return new JtaTransaction(this.userTransaction, this.dataSource, transactionIsolation);
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public void setProperties(Properties props) throws SQLException, TransactionException {
        String utxName = null;
        try {
            utxName = (String)props.get("UserTransaction");
            InitialContext initCtx = new InitialContext();
            this.userTransaction = (UserTransaction)initCtx.lookup(utxName);
        }
        catch (NamingException e) {
            throw new SqlMapException("Error initializing JtaTransactionConfig while looking up UserTransaction (" + utxName + ").  Cause: " + e);
        }
    }
}

