/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin.patch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionFilter
implements Filter {
    public static final String EXTENSION_THRU_KEY = "EXTENSION_THRU_KEY";
    public static final String RESTRICTION_ESCAPE_KEY = "restrictionEscape";
    private static Log log = LogFactory.getLog((Class)ExtensionFilter.class);
    private static final String PROHIBITED_EXTENSION_KEY = "access.control.prohibited.extension";
    private List prohibitedExtensionList = new ArrayList();
    private List restrictionEscapePaths = new ArrayList();

    public void init(FilterConfig config) throws ServletException {
        String prohibitedExtensionsStr = config.getInitParameter(PROHIBITED_EXTENSION_KEY);
        if (prohibitedExtensionsStr == null || prohibitedExtensionsStr.trim().length() == 0) {
            log.warn((Object)"Init parameter[access.control.prohibited.extension] isn't set or is empty.");
            return;
        }
        StringTokenizer st = new StringTokenizer(prohibitedExtensionsStr, "\r\n");
        while (st.hasMoreTokens()) {
            String extension = st.nextToken().trim();
            if (extension.length() == 0) continue;
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("prohibitedExtension:" + extension));
            }
            this.prohibitedExtensionList.add(extension);
        }
        String extensionCheckEscapePathsStr = config.getInitParameter(RESTRICTION_ESCAPE_KEY);
        if (extensionCheckEscapePathsStr == null || extensionCheckEscapePathsStr.trim().length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Init parameter[restrictionEscape] isn't set or is empty.");
            }
            return;
        }
        st = new StringTokenizer(extensionCheckEscapePathsStr, "\r\n");
        while (st.hasMoreTokens()) {
            String extensionCheckEscapePath = st.nextToken().trim();
            if (extensionCheckEscapePath.length() == 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("extensionCheckEscapePath:[" + extensionCheckEscapePath + "]"));
            }
            this.restrictionEscapePaths.add(extensionCheckEscapePath);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(EXTENSION_THRU_KEY) == null) {
            req.setAttribute(EXTENSION_THRU_KEY, (Object)"true");
            Set pathInfoSet = this.resolveAccessControlPath(req);
            Iterator pathInfoIt = pathInfoSet.iterator();
            while (pathInfoIt.hasNext()) {
                String extension;
                String pathInfo = (String)pathInfoIt.next();
                if (this.restrictionEscapePaths.contains(pathInfo) || !this.prohibitedExtensionList.contains(extension = this.getExtension(pathInfo))) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("requestURI[" + pathInfo + "] has prohibited extension"));
                }
                ((HttpServletResponse)res).sendError(404);
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }

    protected String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        return index < 0 ? "" : name.substring(index);
    }

    protected Set resolveAccessControlPath(ServletRequest request) {
        HashSet<String> accessControlPaths = new HashSet<String>();
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String servletPath = httpServletRequest.getServletPath();
        accessControlPaths.add(servletPath);
        String pathInfo = httpServletRequest.getPathInfo();
        if (pathInfo != null) {
            accessControlPaths.add(servletPath + pathInfo);
        }
        return accessControlPaths;
    }
}

