/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.web.common.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AuthenticationController;
import jp.terasoluna.thin.tutorial.web.common.uvo.TutorialUVO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * F؃`FbNsB
 * 
 */
public class TutorialAuthController implements AuthenticationController {

    /**
     * ONX
     */
    private static Log log =
        LogFactory.getLog(TutorialAuthController.class);

    /**
     *  F؃`FbNsȂpX񃊃Xg擾L[B
     */
    private static final String AUTHENTICATED_NOCHECK_PATH_PREFIX
                                 = "access.control.authenticated.escape.";

    /**
     *  F؃`FbNsȂpX񃊃Xg擾L[B
     */
    private List<String> noCheckList = null;

    /**
     * NGXg̃pXɑ΂āAw肳ꂽHTTPZbV
     * F؍ς݂ł邩ǂ𔻒肷B
     *
     * @param pathInfo pX
     * @param req HTTPNGXg
     * 
     * @return F؂ɐ <code>true</code>
     */
    public boolean isAuthenticated(String pathInfo, ServletRequest req) {

        if (log.isDebugEnabled()) {
            log.debug("call isAuthenticated");
        }

        //ZbVUVO擾B
        HttpSession session = ((HttpServletRequest) req).getSession();
        TutorialUVO uvo = (TutorialUVO) session.getAttribute("USER_VALUE_OBJECT");

        //UVOA܂UVOɓo^ĂIDnull̏ꍇfalseԋpB
        if (uvo != null && uvo.getUserId() != null) {
            return true;
        }
        return false;
    }

    /**
     * pX`FbNΏۂۂ肷B
     * 
     * @param req ΏۂƂȂ <code>ServletRequest</code> CX^X
     * 
     * @return `FbNΏۂ̏ꍇ<code>true</code>
     */
    public boolean isCheckRequired(ServletRequest req) {

        if (log.isDebugEnabled()) {
            log.debug("call isCheckRequired()");
        }

        //pX擾B
        String pathInfo = RequestUtil.getPathInfo(req);

        if (noCheckList == null) {
            noCheckList = new ArrayList<String>();
            for (int i = 1; ; i++) {
                String path = PropertyUtil.getProperty(
                        AUTHENTICATED_NOCHECK_PATH_PREFIX + i);
                if (path == null) {
                    break;
                }
                noCheckList.add(path);
            }
        }
        
        for (String path : noCheckList) {
            if (pathInfo.startsWith(path) || "/".equals(pathInfo)) {
                return false;
            }
        }

        return true;
    }

}
