/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.MultiVersionIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class MultiVersionCursor
implements Cursor {
    private final MultiVersionIndex index;
    private final Session session;
    private final Cursor baseCursor;
    private final Cursor deltaCursor;
    private final Object sync;
    private SearchRow baseRow;
    private Row deltaRow;
    private boolean onBase;
    private boolean end;
    private boolean needNewDelta;
    private boolean needNewBase;
    private boolean reverse;

    MultiVersionCursor(Session session, MultiVersionIndex multiVersionIndex, Cursor cursor, Cursor cursor2, Object object) {
        this.session = session;
        this.index = multiVersionIndex;
        this.baseCursor = cursor;
        this.deltaCursor = cursor2;
        this.sync = object;
        this.needNewDelta = true;
        this.needNewBase = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCurrent() throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.baseRow = this.baseCursor.getSearchRow();
            this.deltaRow = this.deltaCursor.get();
            this.needNewDelta = false;
            this.needNewBase = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNext(boolean bl) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            if (bl) {
                this.baseRow = this.step(this.baseCursor) ? this.baseCursor.getSearchRow() : null;
            } else {
                this.deltaRow = this.step(this.deltaCursor) ? this.deltaCursor.get() : null;
            }
        }
    }

    private boolean step(Cursor cursor) throws SQLException {
        return this.reverse ? cursor.previous() : cursor.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row get() throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            if (this.end) {
                return null;
            }
            return this.onBase ? this.baseCursor.get() : this.deltaCursor.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPos() {
        Object object = this.sync;
        synchronized (object) {
            if (SysProperties.CHECK && this.end) {
                throw Message.getInternalError();
            }
            return this.onBase ? this.baseCursor.getPos() : this.deltaCursor.getPos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchRow getSearchRow() throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            if (this.end) {
                return null;
            }
            return this.onBase ? this.baseCursor.getSearchRow() : this.deltaCursor.getSearchRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            int n;
            if (SysProperties.CHECK && this.end) {
                throw Message.getInternalError();
            }
            while (true) {
                if (this.needNewDelta) {
                    this.loadNext(false);
                    this.needNewDelta = false;
                }
                if (this.needNewBase) {
                    this.loadNext(true);
                    this.needNewBase = false;
                }
                if (this.deltaRow == null) {
                    if (this.baseRow == null) {
                        this.end = true;
                        return false;
                    }
                    this.onBase = true;
                    this.needNewBase = true;
                    return true;
                }
                int n2 = this.deltaRow.getSessionId();
                boolean bl = n2 == this.session.getId();
                boolean bl2 = this.deltaRow.getDeleted();
                if (bl && bl2) {
                    this.needNewDelta = true;
                    continue;
                }
                if (this.baseRow == null) {
                    if (bl2) {
                        if (bl) {
                            this.end = true;
                            return false;
                        }
                        this.onBase = false;
                        this.needNewDelta = true;
                        return true;
                    }
                    throw Message.getInternalError();
                }
                n = this.index.compareRows(this.deltaRow, this.baseRow);
                if (n == 0) {
                    int n3;
                    int n4 = this.deltaRow.getPos();
                    int n5 = n4 == (n3 = this.baseRow.getPos()) ? 0 : (n = n4 > n3 ? 1 : -1);
                }
                if (n != 0) break;
                if (bl2) {
                    if (!bl) break;
                    throw Message.getInternalError();
                }
                if (bl) {
                    this.onBase = false;
                    this.needNewBase = true;
                    this.needNewDelta = true;
                    return true;
                }
                this.needNewBase = true;
                this.needNewDelta = true;
            }
            if (n > 0) {
                this.onBase = true;
                this.needNewBase = true;
                return true;
            }
            this.onBase = false;
            this.needNewDelta = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        this.reverse = true;
        try {
            boolean bl = this.next();
            return bl;
        }
        finally {
            this.reverse = false;
        }
    }
}

