/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.security.SHA256;
import org.h2.table.MetaTable;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.ByteUtils;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;

public class User
extends RightOwner {
    private final boolean systemUser;
    private byte[] salt;
    private byte[] passwordHash;
    private boolean admin;

    public User(Database database, int n, String string, boolean bl) {
        super(database, n, string, "user");
        this.systemUser = bl;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public boolean getAdmin() {
        return this.admin;
    }

    public void setSaltAndHash(byte[] byArray, byte[] byArray2) {
        this.salt = byArray;
        this.passwordHash = byArray2;
    }

    public void setUserPasswordHash(byte[] byArray) {
        if (byArray != null) {
            this.salt = RandomUtils.getSecureBytes(8);
            SHA256 sHA256 = new SHA256();
            this.passwordHash = sHA256.getHashWithSalt(byArray, this.salt);
        }
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.getInternalError();
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true, false);
    }

    public String getDropSQL() {
        return null;
    }

    public void checkRight(Table table, int n) throws SQLException {
        TableView tableView;
        if (n != 1 && !this.systemUser) {
            this.database.checkWritingAllowed();
        }
        if (this.admin) {
            return;
        }
        Role role = this.database.getPublicRole();
        if (role.isRightGrantedRecursive(table, n)) {
            return;
        }
        if (table instanceof MetaTable || table instanceof RangeTable) {
            return;
        }
        if ("VIEW".equals(table.getTableType()) && (tableView = (TableView)table).getOwner() == this) {
            return;
        }
        if (!this.isRightGrantedRecursive(table, n)) {
            if (table.getTemporary() && !table.getGlobalTemporary()) {
                return;
            }
            throw Message.getSQLException(90096, table.getSQL());
        }
    }

    public String getCreateSQL(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE USER ");
        if (bl2) {
            stringBuffer.append("IF NOT EXISTS ");
        }
        stringBuffer.append(this.getSQL());
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        if (bl) {
            stringBuffer.append(" SALT '");
            stringBuffer.append(ByteUtils.convertBytesToString(this.salt));
            stringBuffer.append("' HASH '");
            stringBuffer.append(ByteUtils.convertBytesToString(this.passwordHash));
            stringBuffer.append("'");
        } else {
            stringBuffer.append(" PASSWORD ''");
        }
        if (this.admin) {
            stringBuffer.append(" ADMIN");
        }
        return stringBuffer.toString();
    }

    public boolean validateUserPasswordHash(byte[] byArray) {
        SHA256 sHA256 = new SHA256();
        byte[] byArray2 = sHA256.getHashWithSalt(byArray, this.salt);
        return ByteUtils.compareSecure(byArray2, this.passwordHash);
    }

    public void checkAdmin() throws SQLException {
        if (!this.admin) {
            throw Message.getSQLException(90040);
        }
    }

    public int getType() {
        return 2;
    }

    public ObjectArray getChildren() {
        DbObjectBase dbObjectBase;
        int n;
        ObjectArray objectArray = this.database.getAllRights();
        ObjectArray objectArray2 = new ObjectArray();
        for (n = 0; n < objectArray.size(); ++n) {
            dbObjectBase = (Right)objectArray.get(n);
            if (((Right)dbObjectBase).getGrantee() != this) continue;
            objectArray2.add(dbObjectBase);
        }
        objectArray = this.database.getAllSchemas();
        for (n = 0; n < objectArray.size(); ++n) {
            dbObjectBase = (Schema)objectArray.get(n);
            if (((Schema)dbObjectBase).getOwner() != this) continue;
            objectArray2.add(dbObjectBase);
        }
        return objectArray2;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        ObjectArray objectArray = this.database.getAllRights();
        for (int i = 0; i < objectArray.size(); ++i) {
            Right right = (Right)objectArray.get(i);
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.salt = null;
        ByteUtils.clear(this.passwordHash);
        this.passwordHash = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public void checkOwnsNoSchemas() throws SQLException {
        ObjectArray objectArray = this.database.getAllSchemas();
        for (int i = 0; i < objectArray.size(); ++i) {
            Schema schema = (Schema)objectArray.get(i);
            if (this != schema.getOwner()) continue;
            throw Message.getSQLException(90107, new String[]{this.getName(), schema.getName()});
        }
    }
}

