/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.PropertyUtilsBean;

/**
 * {@link jp.terasoluna.fw.client.util.ConvertUtil} NX̃eXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ^ϊs߂̃[eBeBNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.client.util.ConvertUtil
 */
public class ConvertUtilTest extends TestCase {
    
    /**
     * PropertyUtilsBeanB
     */
    private PropertyUtilsBean defaultPropertyUtilsBean = null;

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        defaultPropertyUtilsBean = beanUtilsBean.getPropertyUtils();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        UTUtil.setPrivateField(beanUtilsBean, "propertyUtilsBean",
                defaultPropertyUtilsBean);
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ConvertUtilTest(String name) {
        super(name);
    }

    /**
     * testToArray01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:null<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:vfȂObject[] (vf0ł邱ƂmF)<br>
     *         
     * <br>
     * objnullꍇAvfȂObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToArray01() throws Exception {
        // eXg{
        Object[] result = ConvertUtil.toArray(null); 
        
        // 
        assertEquals(0, result.length);
    }

    /**
     * testToArray02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:""(󕶎)<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:PvfObject[] (vfPł邱ƂmF)<br>
     *                   *vf0:""(󕶎)<br>
     *         
     * <br>
     * obj""(󕶎)ꍇAPvfObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToArray02() throws Exception {
        // eXg{
        Object[] result = ConvertUtil.toArray(""); 
        
        // 
        assertEquals(1, result.length);
        assertEquals("", result[0]);
    }

    /**
     * testToArray03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:"  "(󔒕)<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:PvfObject[] (vfPł邱ƂmF)<br>
     *                   *vf0:"  "(󔒕)<br>
     *         
     * <br>
     * obj"  "(󔒕)ꍇAPvfObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToArray03() throws Exception {
        // eXg{
        Object[] result = ConvertUtil.toArray("  "); 
        
        // 
        assertEquals(1, result.length);
        assertEquals("  ", result[0]);
    }

    /**
     * testToArray04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:"array"<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:PvfObject[] (vfPł邱ƂmF)<br>
     *                   *vf0:"array"<br>
     *         
     * <br>
     * objʏ̕񂾂ꍇAPvfObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToArray04() throws Exception {
        // eXg{
        Object[] result = ConvertUtil.toArray("array"); 
        
        // 
        assertEquals(1, result.length);
        assertEquals("array", result[0]);
    }

    /**
     * testToArray05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:vfȂObject[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:vfȂObject[] (vfOł邱ƂmF)<br>
     *         
     * <br>
     * objvfȂz񂾂ꍇAvfȂObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToArray05() throws Exception {
        // O
        Object obj = new Object[0];

        // eXg{
        Object[] result = ConvertUtil.toArray(obj); 
        
        // 
        assertEquals(0, result.length);
    }

    /**
     * testToArray06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:PvfێString[]<br>
     *                 *vfO:"array"<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:PvfObject[] (vfPł邱ƂmF)<br>
     *                   *vf0:"array"<br>
     *         
     * <br>
     * objPvfێz񂾂ꍇAPvfێObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToArray06() throws Exception {
        // O
        String[] obj = {"array"};

        // eXg{
        Object[] result = ConvertUtil.toArray(obj); 
        
        // 
        assertEquals(1, result.length);
        assertEquals("array", result[0]);
    }

    /**
     * testToArray07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:RvfێObject[]<br>
     *                 *vfO:"array"<br>
     *                 *vfP:1<br>
     *                 *vfQ:MapCX^X (key="foo" value="something")<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:RvfObject[] (vfRł邱ƂmF)<br>
     *                   *vf0:"array"<br>
     *                   *vf1:1<br>
     *                   *vf2:MapCX^X(key="foo" value="something")<br>
     *         
     * <br>
     * objRvfێz񂾂ꍇARvfێObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testToArray07() throws Exception {
        // O
        Object[] obj = new Object[3];
        obj[0] = "array";
        obj[1] = 1;
        Map map = new HashMap();
        map.put("foo", "something");
        obj[2] = map;

        // eXg{
        Object[] result = ConvertUtil.toArray(obj); 
        
        // 
        assertEquals(3, result.length);
        assertEquals("array", result[0]);
        assertEquals(1, result[1]);
        assertEquals(map, result[2]);
        Map mapResult = (Map) result[2];
        assertEquals("something", mapResult.get("foo"));
    }

    /**
     * testToArray08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:vfȂCollection<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:vfȂObject[] (vfOł邱ƂmF)<br>
     *         
     * <br>
     * objvfȂCollectionꍇAvfȂObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToArray08() throws Exception {
        // O
        Collection obj = new Vector();

        // eXg{
        Object[] result = ConvertUtil.toArray(obj); 
        
        // 
        assertEquals(0, result.length);
    }

    /**
     * testToArray09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:PvfێCollection<br>
     *                 *vf0:"collection"<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:PvfObject[] (vfPł邱ƂmF)<br>
     *                   *vf0:"collection"<br>
     *         
     * <br>
     * objPvfێCollectionꍇAPvfێObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testToArray09() throws Exception {
        // O
        Collection obj = new Vector();
        obj.add("collection");

        // eXg{
        Object[] result = ConvertUtil.toArray(obj); 
        
        // 
        assertEquals(1, result.length);
        assertEquals("collection", result[0]);
    }

    /**
     * testToArray10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:RvfێCollection<br>
     *                 *vf0:"collection"<br>
     *                 *vf1:1<br>
     *                 *vf2:MapCX^X(key="key" value="something")<br>
     *         
     * <br>
     * ҒlF(߂l) Object[]:RvfObject[] (vfRł邱ƂmF)<br>
     *                   *vf0:"collection"<br>
     *                   *vf1:1<br>
     *                   *vf2:MapCX^X(key="foo" value="something")<br>
     *         
     * <br>
     * objRvfێcollectionꍇARvfێObject[]ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testToArray10() throws Exception {
        // O
        Collection obj = new Vector();
        obj.add("collection");
        obj.add(1);
        Map map = new HashMap();
        map.put("foo", "something");
        obj.add(map);

        // eXg{
        Object[] result = ConvertUtil.toArray(obj); 
        
        // 
        assertEquals(3, result.length);
        assertEquals("collection", result[0]);
        assertEquals(1, result[1]);
        Map mapResult = (Map) result[2];
        assertEquals("something", mapResult.get("foo"));
    }

    /**
     * testToList01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC,G
     * <br><br>
     * ͒lF() obj:null<br>
     *         () elementClass:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Argument 'elementClass' (" + Class.class.getName() 
     *                    @+ ") is null"<br>
     *         
     * <br>
     * elementClassnullꍇAIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList01() throws Exception {
        // eXg{
        try {
            ConvertUtil.toList(null, null);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Argument 'elementClass' (" + Class.class.getName()
                    + ") is null",
                    e.getMessage());
        }

    }

    /**
     * testToList02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:null<br>
     *         () elementClass:Object.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:vfȂList<Object> (vfOł邱ƂmF)<br>
     *         
     * <br>
     * objnullꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList02() throws Exception {
        // eXg{
        List<Object> result = ConvertUtil.toList(null, Object.class);

        // 
        assertEquals(0, result.size());
    }

    /**
     * testToList03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:""(󕶎)<br>
     *         () elementClass:Object.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:PvfList<Object> (vfPł邱ƂmF)<br>
     *                   *vf0:""(󕶎)<br>
     *         
     * <br>
     * obj""(󕶎)ꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList03() throws Exception {
        // eXg{
        List<Object> result = ConvertUtil.toList("", Object.class);

        // 
        assertEquals(1, result.size());
        assertEquals("", result.get(0));
        
    }

    /**
     * testToList04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:"  "(󔒕)<br>
     *         () elementClass:Object.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:PvfList<Object> (vfPł邱ƂmF)<br>
     *                   *vf0:"  "(󔒕)<br>
     *         
     * <br>
     * obj""(󕶎)ꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList04() throws Exception {
        // eXg{
        List<Object> result = ConvertUtil.toList("  ", Object.class);

        // 
        assertEquals(1, result.size());
        assertEquals("  ", result.get(0));
    }

    /**
     * testToList05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:"list"<br>
     *         () elementClass:Object.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:PvfList<Object> (vfPł邱ƂmF)<br>
     *                   *vf0:"list"<br>
     *         
     * <br>
     * objʏ핶񂾂ꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList05() throws Exception {
        // eXg{
        List<Object> result = ConvertUtil.toList("list", Object.class);

        // 
        assertEquals(1, result.size());
        assertEquals("list", result.get(0));
    }

    /**
     * testToList06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:"list"<br>
     *         () elementClass:Thread.class<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Unable to cast '" + obj̊SCNX 
     *                    @+ "' to '" + elementClass̊SCNX + "'"<br>
     *                    bvꂽO:ClassCastException<br>
     *                    bvꂽÕbZ[W:"Unable to cast '" 
     *                    @+ obj̊SCNX + "' to '" 
     *                    + elementClass̊SCNX + "'"<br>
     *         
     * <br>
     * obǰ^elementClassŎw肵^ƓA̓TuNXł
     * ȂꍇAIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testToList06() throws Exception {
        // eXg{
        try {
            ConvertUtil.toList("list", Thread.class);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Unable to cast '" + "list".getClass().getName() 
                    + "' to '" + Thread.class.getName() + "'",
                    e.getMessage());
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertEquals("Unable to cast '" + "list".getClass().getName() 
                    + "' to '" + Thread.class.getName() + "'",
                    e.getCause().getMessage());
        }

    }

    /**
     * testToList07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:vfȂObject[]<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:vfȂList<String> (vfOł邱ƂmF)<br>
     *         
     * <br>
     * objvfȂz񂾂ꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList07() throws Exception {
        // O
        Object[] obj = new Object[0];
        
        // eXg{
        List<String> result = ConvertUtil.toList(obj, String.class);

        // 
        assertEquals(0, result.size());
    }

    /**
     * testToList08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:PvfێObject[]<br>
     *                 *vf0:"foo"<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:PvfList<String> (vfPł邱ƂmF)<br>
     *                   *vf0:"foo"<br>
     *         
     * <br>
     * objPvfێz񂾂ꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList08() throws Exception {
        // O
        Object[] obj = {"foo"};
        
        // eXg{
        List<String> result = ConvertUtil.toList(obj, String.class);

        // 
        assertEquals(1, result.size());
        assertEquals("foo", result.get(0));
    }

    /**
     * testToList09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:RvfێObject[]<br>
     *                 *vf0:"foo"<br>
     *                 *vf2:"bar"<br>
     *                 *vf3:"baz"<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:RvfList<String> (vfRł邱ƂmF)<br>
     *                   *vf0:"foo"<br>
     *                   *vf1:"bar"<br>
     *                   *vf2:"baz"<br>
     *         
     * <br>
     * objRvfێz񂾂ꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList09() throws Exception {
        // O
        Object[] obj = new Object[3];
        obj[0] = "foo";
        obj[1] = "bar";
        obj[2] = "baz";
        
        // eXg{
        List<String> result = ConvertUtil.toList(obj, String.class);

        // 
        assertEquals(3, result.size());
        assertEquals("foo", result.get(0));
        assertEquals("bar", result.get(1));
        assertEquals("baz", result.get(2));
    }

    /**
     * testToList10()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:RvfێObject[]<br>
     *                 *vf0:"foo"<br>
     *                 *vf2:ThreadCX^X<br>
     *                 *vf3:"baz"<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    @"Unable to cast '" + Thread̊SCNX
     *                    @+ "' to '" + elementClass̊SCNX + "'"<br>
     *                    bvꂽO:ClassCastException<br>
     *                    bvꂽÕbZ[W:
     *                    @"Unable to cast '" + Thread̊SCNX
     *                    + "' to '" + elementClass̊SCNX + "'"<br>
     *         
     * <br>
     * obj̔zelementClassŎw肵^ƓA̓TuNXł͂Ȃ
     * vf܂܂ĂꍇAIllegalArgumentExceptionX[邱Ƃ
     * mFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList10() throws Exception {
        // O
        Object[] obj = new Object[3];
        obj[0] = "foo";
        obj[1] = new Thread();
        obj[2] = "baz";

        // eXg{
        try {
            ConvertUtil.toList(obj, String.class);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Unable to cast '" + Thread.class.getName()
                    + "' to '" + String.class.getName() + "'",
                    e.getMessage());
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertEquals("Unable to cast '" + Thread.class.getName()
                    + "' to '" + String.class.getName() + "'",
                    e.getCause().getMessage());
        }
    }

    /**
     * testToList11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:vfȂCollection<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:vfȂList<String> (vfOł邱ƂmF)<br>
     *         
     * <br>
     * objvfȂCollectionꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList11() throws Exception {
        // O
        Collection obj = new Vector(); 
        
        // eXg{
        List<String> result = ConvertUtil.toList(obj, String.class);

        // 
        assertEquals(0, result.size());

    }

    /**
     * testToList12()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:PvfێCollection<br>
     *                 *vf0:"foo"<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:PvfList<String> (vfPł邱ƂmF)<br>
     *                   *vf0:"foo"<br>
     *         
     * <br>
     * objPvfێCollectionꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testToList12() throws Exception {
        // O
        Collection obj = new Vector(); 
        obj.add("foo");
        
        // eXg{
        List<String> result = ConvertUtil.toList(obj, String.class);

        // 
        assertEquals(1, result.size());
        assertEquals("foo", result.get(0));
    }

    /**
     * testToList13()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() obj:RvfێCollection<br>
     *                 *vf0:"foo"<br>
     *                 *vf2:"bar"<br>
     *                 *vf3:"baz"<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(߂l) List:RvfList<String> (vfRł邱ƂmF)<br>
     *                   *vf0:"foo"<br>
     *                   *vf1:"bar"<br>
     *                   *vf2:"baz"<br>
     *         
     * <br>
     * objRvfێCollectionꍇAelementsClassŎw肵^Listԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testToList13() throws Exception {
        // O
        Collection obj = new Vector(); 
        obj.add("foo");
        obj.add("bar");
        obj.add("baz");
        
        // eXg{
        List<String> result = ConvertUtil.toList(obj, String.class);

        // 
        assertEquals(3, result.size());
        assertEquals("foo", result.get(0));    
        assertEquals("bar", result.get(1));    
        assertEquals("baz", result.get(2));    
    }

    /**
     * testToList14()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:RvfێCollection<br>
     *                 *vf0:"foo"<br>
     *                 *vf2:ThreadCX^X<br>
     *                 *vf3:"baz"<br>
     *         () elementClass:String.class<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Unable to cast '" + Thread̊SCNX
     *                    @+ "' to '" + elementClass̊SCNX + "'"<br>
     *                    bvꂽO:ClassCastException<br>
     *                    bvꂽÕbZ[W:
     *                    "Unable to cast '" + Thread̊SCNX
     *                    + "' to '" + elementClass̊SCNX + "'"<br>
     *         
     * <br>
     * objCollectionelementClassŎw肵^ƓA̓TuNX
     * ł͂Ȃvf܂܂ĂꍇAIllegalArgumentExceptionX[邱
     * mFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToList14() throws Exception {
        // O
        Object[] obj = new Object[3];
        obj[0] = "foo";
        obj[1] = new Thread();
        obj[2] = "baz";

        // eXg{
        try {
            ConvertUtil.toList(obj, String.class);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Unable to cast '" + Thread.class.getName()
                    + "' to '" + String.class.getName() + "'",
                    e.getMessage());
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertEquals("Unable to cast '" + Thread.class.getName()
                    + "' to '" + String.class.getName() + "'",
                    e.getCause().getMessage());
        }
    }

    /**
     * testConvertObjectClass01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:"object"<br>
     *         () clazz:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Argument 'clazz' (" + Object.class.getName() 
     *                    + ") is null"<br>
     *         
     * <br>
     * clazznullꍇAIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClass01() throws Exception {
        // eXg{
        try {
            ConvertUtil.convert("object", null);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Argument 'clazz' (" + Object.class.getName()
                    + ") is null",
                    e.getMessage());
        }

    }

    /**
     * testConvertObjectClass02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:null<br>
     *         () clazz:Object.class<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:null<br>
     *         
     * <br>
     * objnullꍇAnullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClass02() throws Exception {
        // eXg{
        // 
        assertNull(ConvertUtil.convert(null, Object.class));
    }

    /**
     * testConvertObjectClass03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:List (ArrayListŃCX^X)<br>
     *         () clazz:ArrayList.class<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:ListCX^X (objƓCX^Xł邱ƂmF)<br>
     *         
     * <br>
     * objƓCX^Xԋp̂mFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClass03() throws Exception {
        // O
        List list = new ArrayList();

        // eXg{
        List result = ConvertUtil.convert(list, ArrayList.class);

        // 
        assertSame(list, result);
    }

    /**
     * testConvertObjectClass04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:ThreadCX^X<br>
     *         () clazz:AlgorithmParameterGenerator.class<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:ThreadCX^X̕\<br>
     *         
     * <br>
     * obǰ^clazž^ƌ݊ȂꍇAobj̕\ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClass04() throws Exception {
        // O
        Thread thread = new Thread();

        // eXg{
        Object result = ConvertUtil.convert(thread,
                AlgorithmParameterGenerator.class);

        // 
        assertTrue(result instanceof String);
        assertEquals(thread.toString(), result);
    }

    /**
     * testConvertIfNotNull01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:"object"<br>
     *         () clazz:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Argument 'clazz' (" + Object.class.getName() 
     *                    @+ ") is null"<br>
     *         
     * <br>
     * clazznullꍇAIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertIfNotNull01() throws Exception {
        // eXg{
        try {
            ConvertUtil.convertIfNotNull("object", null);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Argument 'clazz' (" + Object.class.getName()
                    + ") is null",
                    e.getMessage());
        }
    }

    /**
     * testConvertIfNotNull02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:null<br>
     *         () clazz:Object.class<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Unable to cast 'null' to '" 
     *                    @+ clazz̊SCNX + "'"<br>
     *                    bvꂽO:ClassCastException<br>
     *                    bvꂽÕbZ[W:
     *                    "Unable to cast 'null' to '" 
     *                    @+ clazz̊SCNX + "'"<br>
     *         
     * <br>
     * objnullꍇAIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertIfNotNull02() throws Exception {
        // eXg{
        try {
            ConvertUtil.convertIfNotNull(null, Object.class);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Unable to cast 'null' to '" + Object.class.getName()
                    + "'", e.getMessage());
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertEquals("Unable to cast 'null' to '" + Object.class.getName()
                    + "'", e.getCause().getMessage());
        }
    }

    /**
     * testConvertIfNotNull03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:List (ArrayListŃCX^X)<br>
     *         () clazz:ArrayList.class<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:ListCX^X (objƓCX^Xł邱ƂmF)<br>
     *         
     * <br>
     * objƓCX^Xԋp̂mFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertIfNotNull03() throws Exception {
        // O
        List list = new ArrayList();

        // eXg{
        List result = ConvertUtil.convertIfNotNull(list, ArrayList.class);

        // 
        assertSame(list, result);
    }

    /**
     * testConvertIfNotNull04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:ThreadCX^X<br>
     *         () clazz:AlgorithmParameterGenerator.class<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:ThreadCX^X̕\<br>
     *         
     * <br>
     * obǰ^clazž^ƌ݊ȂꍇAobj̕\ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertIfNotNull04() throws Exception {
        // O
        Thread thread = new Thread();

        // eXg{
        Object result = ConvertUtil.convert(thread,
                AlgorithmParameterGenerator.class);

        // 
        assertTrue(result instanceof String);
        assertEquals(thread.toString(), result);
    }

    /**
     * testConvertObjectClassboolean01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:null<br>
     *         () clazz:null<br>
     *         () allowsNull:true<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Argument 'clazz' (" + Object.class.getName() 
     *                      + ") is null"<br>
     *         
     * <br>
     * clazznullꍇAIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClassboolean01() throws Exception {
        // eXg{
        try {
            ConvertUtil.convert(null, null, true);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Argument 'clazz' (" + Object.class.getName()
                    + ") is null", e.getMessage());
        }

    }

    /**
     * testConvertObjectClassboolean02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:null<br>
     *         () clazz:Object.class<br>
     *         () allowsNull:false<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    ÕbZ[W:
     *                    "Unable to cast 'null' to '" 
     *                      + clazz̊SCNX + "'"<br>
     *                    bvꂽO:ClassCastException<br>
     *                    bvꂽÕbZ[W:
     *                    "Unable to cast 'null' to '" 
     *                      + clazz̊SCNX + "'"<br>
     *         
     * <br>
     * clazznullł͂ȂAobjnullAallowsNullfalseꍇA
     * IllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClassboolean02() throws Exception {
        // eXg{
        try {
            ConvertUtil.convert(null, Object.class, false);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertEquals("Unable to cast 'null' to '" + Object.class.getName()
                    + "'", e.getMessage());
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertEquals("Unable to cast 'null' to '" + Object.class.getName()
                    + "'", e.getCause().getMessage());
        }    
    }

    /**
     * testConvertObjectClassboolean03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:null<br>
     *         () clazz:Object.class<br>
     *         () allowsNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:null<br>
     *         
     * <br>
     * clazznullł͂ȂAobjnullAallowsNulltrueꍇAnullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClassboolean03() throws Exception {
        // eXg{
        // 
        assertNull(ConvertUtil.convert(null, Object.class, true));
    }

    /**
     * testConvertObjectClassboolean04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:ThreadCX^X<br>
     *         () clazz:Thread.class<br>
     *         () allowsNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:ThreadCX^X (objƓCX^Xł邱ƂmF)<br>
     *         
     * <br>
     * clazž^obǰ^ꍇAclazž^̃CX^Xԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClassboolean04() throws Exception {
        // O
        Thread thread = new Thread();
        
        // eXg{
        Thread result = ConvertUtil.convert(thread, Thread.class, true);

        // 
        assertSame(thread, result);
    }

    /**
     * testConvertObjectClassboolean05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:List (ArrayListŃCX^X)<br>
     *         () clazz:ArrayList.class<br>
     *         () allowsNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:ListCX^X (objƓCX^Xł邱ƂmF)<br>
     *         
     * <br>
     * objƓCX^Xԋp̂mFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClassboolean05() throws Exception {
        //  O
        List list = new ArrayList();
        
        // eXg{
        List result = ConvertUtil.convert(list, ArrayList.class, true);

        // 
        assertNotNull(result);
        assertSame(list, result);
    }

    /**
     * testConvertObjectClassboolean06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() obj:ThreadCX^X<br>
     *         () clazz:AlgorithmParameterGenerator.class<br>
     *         () allowsNull:true<br>
     *         
     * <br>
     * ҒlF(߂l) <T>:ThreadCX^X̕\<br>
     *         
     * <br>
     * clazž^obǰ^ƌ݊ȂꍇAobj̕\ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClassboolean06() throws Exception {
        //  O
        Thread thread = new Thread();
        
        // eXg{
        Object result = ConvertUtil.convert(thread,
                AlgorithmParameterGenerator.class,
                true);

        // 
        assertTrue(result instanceof String);
        assertEquals(thread.toString(), result);
    }

    /**
     * testConvertObjectClassboolean07()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:"abc"<br>
     *         () clazz:BigInteger.class<br>
     *         () allowsNull:false<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bvꂽO:ConversionException<br>
     *         
     * <br>
     * CnvertUtils#convertŗOꍇAIllegalArgumentExceptionX[邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertObjectClassboolean07() throws Exception {
        
        // eXg{
        try {
            ConvertUtil.convert("abc", BigInteger.class, false);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(e.getCause() instanceof ConversionException);
        }
    }

    /**
     * testConvertPrimitiveArrayToList01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         
     * <br>
     * valuenullꍇAnullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList01() throws Exception {
        // eXg{
        // 
        assertNull(ConvertUtil.convertPrimitiveArrayToList(null));
    }

    /**
     * testConvertPrimitiveArrayToList02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""(󕶎)<br>
     *         
     * <br>
     * ҒlF(߂l) Object:""(󕶎)<br>
     *         
     * <br>
     * value""(󕶎)ꍇA""(󕶎)ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList02() throws Exception {
        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList("");
        
        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testConvertPrimitiveArrayToList03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"  "(󔒕)<br>
     *         
     * <br>
     * ҒlF(߂l) Object:"  "(󔒕)<br>
     *         
     * <br>
     * value"  "(󔒕)ꍇA""(󕶎)ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList03() throws Exception {
        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList("  ");
        
        // 
        assertNotNull(result);
        assertEquals("  ", result);
    }

    /**
     * testConvertPrimitiveArrayToList04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() value:"noArray"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:"noArray"<br>
     *         
     * <br>
     * valueʏ핶񂾂ꍇA̒l̂܂ܕԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList04() throws Exception {
        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList("noarray");
        
        // 
        assertNotNull(result);
        assertEquals("noarray", result);
    }

    /**
     * testConvertPrimitiveArrayToList05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂObject[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂObject[] (vf0ł邱ƂmF)<br>
     *         
     * <br>
     * valuev~eBu^ȊO̔z(vf0)ꍇA̒l̂܂ܕԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList05() throws Exception {
        // O
        Object[] value = new Object[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof Object[]);
        Object[] arrayResult = (Object[]) result;
        assertEquals(0, arrayResult.length);
    }

    /**
     * testConvertPrimitiveArrayToList06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێObject[]<br>
     *                 *vf0:"foo"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێObject[] (vf1ł邱ƂmF)<br>
     *                   *vf0:"foo"<br>
     *         
     * <br>
     * valuev~eBu^ȊO̔z(vf1)ꍇA̒l̂܂ܕԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList06() throws Exception {
        // O
        Object[] value = {"foo"};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof Object[]);
        Object[] arrayResult = (Object[]) result;
        assertEquals(1, arrayResult.length);
        assertEquals("foo", arrayResult[0]);
        
    }

    /**
     * testConvertPrimitiveArrayToList07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێObject[]<br>
     *                 *vf0:"foo"<br>
     *                 *vf1:"bar"<br>
     *                 *vf2:"baz"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێObject[] (vf3ł邱ƂmF)<br>
     *                   *vf0:"foo"<br>
     *                   *vf1:"bar"<br>
     *                   *vf3:"baz"<br>
     *         
     * <br>
     * valuev~eBu^ȊO̔z(vf3)ꍇA̒l̂܂ܕԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList07() throws Exception {
        // O
        Object[] value = {"foo", "bar", "baz"};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof Object[]);
        Object[] arrayResult = (Object[]) result;
        assertEquals(3, arrayResult.length);
        assertEquals("foo", arrayResult[0]);
        assertEquals("bar", arrayResult[1]);
        assertEquals("baz", arrayResult[2]);
    }

    /**
     * testConvertPrimitiveArrayToList08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂboolean[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂboolean^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList08() throws Exception {
        // O
        boolean[] value = new boolean[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێboolean[]<br>
     *                 *vf0:true<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0:true<br>
     *         
     * <br>
     * valueboolean^̔z(vf1)ꍇAboolean^̒lێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList09() throws Exception {
        // O
        boolean[] value = {true};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
        assertTrue((Boolean) listResult.get(0));
    }

    /**
     * testConvertPrimitiveArrayToList10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێboolean[]<br>
     *                 *vf0:true<br>
     *                 *vf1:false<br>
     *                 *vf2:true<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0:true<br>
     *                   *vf1:false<br>
     *                   *vf2:true<br>
     *         
     * <br>
     * valueboolean^̔z(vf3)ꍇAboolean^̒lێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList10() throws Exception {
        // O
        boolean[] value = {true, false, true};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertTrue((Boolean) listResult.get(0));
        assertFalse((Boolean) listResult.get(1));
        assertTrue((Boolean) listResult.get(2));
    }

    /**
     * testConvertPrimitiveArrayToList11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂbyte[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂbyte^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList11() throws Exception {
        // O
        byte[] value = new byte[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList12()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێbyte[]<br>
     *                 *vf0: (byte) 1<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0:"1"<br>
     *         
     * <br>
     * valuebyte^̔z(vf1)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList12() throws Exception {
        // O
        byte[] value = {1};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
        assertEquals("1", listResult.get(0));
    }

    /**
     * testConvertPrimitiveArrayToList13()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێbyte[]<br>
     *                 *vf0: (byte) 1<br>
     *                 *vf1: (byte) 2<br>
     *                 *vf2: (byte) 3<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0:"1"<br>
     *                   *vf1:"2"<br>
     *                   *vf2:"3"<br>
     *         
     * <br>
     * valuebyte^̔z(vf3)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList13() throws Exception {
        // O
        byte[] value = {1, 2, 3};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertEquals("1", listResult.get(0));    
        assertEquals("2", listResult.get(1));    
        assertEquals("3", listResult.get(2));    
    }

    /**
     * testConvertPrimitiveArrayToList14()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂchar[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂchar^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList14() throws Exception {
        // O
        char[] value = new char[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList15()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێchar[]<br>
     *                 *vf0: 'A'<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0: "A"<br>
     *         
     * <br>
     * valuechar^̔z(vf1)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList15() throws Exception {
        // O
        char[] value = {'A'};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
        assertEquals("A", listResult.get(0));    
    }

    /**
     * testConvertPrimitiveArrayToList16()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێchar[]<br>
     *                 *vf0: 'A'<br>
     *                 *vf1: 'B'<br>
     *                 *vf2: 'C'<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0: "A"<br>
     *                   *vf1: "B"<br>
     *                   *vf2: "C"<br>
     *         
     * <br>
     * valuechar^̔z(vf3)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList16() throws Exception {
        // O
        char[] value = {'A', 'B', 'C'};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertEquals("A", listResult.get(0));    
        assertEquals("B", listResult.get(1));    
        assertEquals("C", listResult.get(2));    
    }

    /**
     * testConvertPrimitiveArrayToList17()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂdouble[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂdouble^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList17() throws Exception {
        // O
        double[] value = new double[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList18()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێdouble[]<br>
     *                 *vf0: 123.456<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0: "123.456"<br>
     *         
     * <br>
     * valuedouble^̔z(vf1)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList18() throws Exception {
        // O
        double[] value = {123.456};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
        assertEquals("123.456", listResult.get(0));    
    }

    /**
     * testConvertPrimitiveArrayToList19()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێdouble[]<br>
     *                 *vf0: 123.456<br>
     *                 *vf1: 12.34<br>
     *                 *vf2: 1.2<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0: "123.456"<br>
     *                   *vf1: "12.34"<br>
     *                   *vf2: "1.2"<br>
     *         
     * <br>
     * valuedouble^̔z(vf3)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList19() throws Exception {
        // O
        double[] value = {123.456, 12.34, 1.2};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertEquals("123.456", listResult.get(0));    
        assertEquals("12.34", listResult.get(1));    
        assertEquals("1.2", listResult.get(2));    
    }

    /**
     * testConvertPrimitiveArrayToList20()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂfloat[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂfloat^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList20() throws Exception {
        // O
        float[] value = new float[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList21()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێfloat[]<br>
     *                 *vf0: 12.3F<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0: "12.3"<br>
     *         
     * <br>
     * valuefloat^̔z(vf1)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList21() throws Exception {
        // O
        float[] value = {12.3F};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
        assertEquals("12.3", listResult.get(0));    
    }

    /**
     * testConvertPrimitiveArrayToList22()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێfloat[]<br>
     *                 *vf0: 12.3F<br>
     *                 *vf1: 1.2F<br>
     *                 *vf2: 1F<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0: "12.3"<br>
     *                   *vf1: "1.2"<br>
     *                   *vf2: "1.0"<br>
     *         
     * <br>
     * valuefloat^̔z(vf3)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList22() throws Exception {
        // O
        float[] value = {12.3F, 1.2F, 1F};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertEquals("12.3", listResult.get(0));    
        assertEquals("1.2", listResult.get(1));    
        assertEquals("1.0", listResult.get(2));    
    }

    /**
     * testConvertPrimitiveArrayToList23()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂint[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂint^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList23() throws Exception {
        // O
        int[] value = new int[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList24()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێint[]<br>
     *                 *vf0: 1<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0: "1"<br>
     *         
     * <br>
     * valueint^̔z(vf1)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList24() throws Exception {
        // O
        int[] value = {1};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
        assertEquals("1", listResult.get(0));    
    }

    /**
     * testConvertPrimitiveArrayToList25()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێint[]<br>
     *                 *vf0: 1<br>
     *                 *vf1: 2<br>
     *                 *vf2: 3<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0: "1"<br>
     *                   *vf1: "2"<br>
     *                   *vf2: "3"<br>
     *         
     * <br>
     * valueint^̔z(vf3)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList25() throws Exception {
        // O
        int[] value = {1, 2, 3};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertEquals("1", listResult.get(0));    
        assertEquals("2", listResult.get(1));    
        assertEquals("3", listResult.get(2));    
    }

    /**
     * testConvertPrimitiveArrayToList26()
     * <br><br>
     * 
     * (n) or (ُn)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂlong[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂlong^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList26() throws Exception {
        // O
        long[] value = new long[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList27()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێlobg[]<br>
     *                 *vf0: 1L<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0: "1"<br>
     *         
     * <br>
     * valuelong^̔z(vf1)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList27() throws Exception {
        // O
        long[] value = {1L};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
        assertEquals("1", listResult.get(0));    
    }

    /**
     * testConvertPrimitiveArrayToList28()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێlong[]<br>
     *                 *vf0: 1L<br>
     *                 *vf1: 2L<br>
     *                 *vf2: 3L<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0: "1"<br>
     *                   *vf1: "2"<br>
     *                   *vf2: "3"<br>
     *         
     * <br>
     * valuelong^̔z(vf3)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList28() throws Exception {
        // O
        long[] value = {1L, 2L, 3L};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertEquals("1", listResult.get(0));    
        assertEquals("2", listResult.get(1));    
        assertEquals("3", listResult.get(2));    
    }

    /**
     * testConvertPrimitiveArrayToList29()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:vfێȂshort[]<br>
     *         
     * <br>
     * ҒlF(߂l) Object:vfێȂList (size0ł邱ƂmF)<br>
     *         
     * <br>
     * valuevfێȂshort^̔z񂾂ꍇAvfێȂListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList29() throws Exception {
        // O
        short[] value = new short[0];

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(0, listResult.size());

    }

    /**
     * testConvertPrimitiveArrayToList30()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێshort[]<br>
     *                 *vf0: (short) 1<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size1ł邱ƂmF)<br>
     *                   *vf0: "1"<br>
     *         
     * <br>
     * valueshort^̔z(vf1)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList30() throws Exception {
        // O
        short[] value = {(short) 1};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(1, listResult.size());
    }

    /**
     * testConvertPrimitiveArrayToList31()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD,E
     * <br><br>
     * ͒lF() value:ȉ̗vfێshort[]<br>
     *                 *vf0: (short) 1<br>
     *                 *vf1: (short) 2<br>
     *                 *vf2: (short) 3<br>
     *         
     * <br>
     * ҒlF(߂l) Object:ȉ̗vfێList(size3ł邱ƂmF)<br>
     *                   *vf0: "1"<br>
     *                   *vf1: "2"<br>
     *                   *vf2: "3"<br>
     *         
     * <br>
     * valueshort^̔z(vf3)ꍇAString^ɕϊꂽlێListԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConvertPrimitiveArrayToList31() throws Exception {
        // O
        short[] value = {(short) 1, (short) 2, (short) 3};

        // eXg{
        Object result = ConvertUtil.convertPrimitiveArrayToList(value);
        
        // 
        assertNotNull(result);
        assertTrue(result instanceof List);
        List listResult = (List) result;
        assertEquals(3, listResult.size());
        assertEquals("1", listResult.get(0));    
        assertEquals("2", listResult.get(1));    
        assertEquals("3", listResult.get(2));    
    }

    /**
     * testToListOfMap01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD, E
     * <br><br>
     * ͒lF() obj:null<br>
     *         
     * <br>
     * ҒlF(߂l) List<Map<String, Object>:vfȂObject[]<br>
     *         
     * <br>
     * objnull̏ꍇAvfȂList<Map<String,Object>CX^XԂ邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap01() throws Exception {
        // O
        // eXg{
        List<Map<String, Object>> actual = ConvertUtil.toListOfMap(null);

        // 
        assertNotNull(actual);
        assertTrue(actual.isEmpty());
    }

    /**
     * testToListOfMap02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD, E
     * <br><br>
     * ͒lF() obj:3vfJavaBeanX^ũXg<br>
     *                vf0=JavaBeanX^uCX^X<br>
     *                tB[hA="value00"<br>
     *                vf1=JavaBeanX^uCX^X<br>
     *                tB[hA="value01"<br>
     *                vf2=JavaBeanX^uCX^X<br>
     *                tB[hA="value02"<br>
     *         
     * <br>
     * ҒlF(߂l) List<Map<String, Object>:
     *      3vfList<Map<String, Object>>CX^X<br>
     *                  <br>
     *                  vf0-=Map<String,Object>CX^X<br>
     *                  key="a",value="value00"<br>
     *                  vf1=Map<String,Object>CX^X<br>
     *                  key="a",value="value01"<br>
     *                  vf2=Map<String,Object>CX^X<br>
     *                  key="a",value="value02"<br>
     *         
     * <br>
     * objJavaBeanvfXg̏ꍇA
     * 3̗vfList<Map<String,Object>CX^XԂ邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap02() throws Exception {

        List<ConvertUtil_Stub01> obj = new ArrayList<ConvertUtil_Stub01>();
        ConvertUtil_Stub01 bean = new ConvertUtil_Stub01();
        bean.setA("value00");
        obj.add(bean);
        ConvertUtil_Stub01 bean02 = new ConvertUtil_Stub01();
        bean02.setA("value01");
        obj.add(bean02);
        ConvertUtil_Stub01 bean03 = new ConvertUtil_Stub01();
        bean03.setA("value02");
        obj.add(bean03);

        // eXg{
        List<Map<String, Object>> actual = ConvertUtil.toListOfMap(obj);

        // 
        assertNotNull(actual);
        assertEquals(3, actual.size());
        assertEquals("value00", actual.get(0).get("a"));
        assertEquals("value01", actual.get(1).get("a"));
        assertEquals("value02", actual.get(2).get("a"));
    }

    /**
     * testToListOfMap03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD, E
     * <br><br>
     * ͒lF() obj:3vfJavaBeanX^uz<br>
     *                vf0=JavaBeanX^uCX^X<br>
     *                tB[hA="value00"<br>
     *                vf1=JavaBeanX^uCX^X<br>
     *                tB[hA="value01"<br>
     *                vf2=JavaBeanX^uCX^X<br>
     *                tB[hA="value02"<br>
     *         
     * <br>
     * ҒlF(߂l) List<Map<String, Object>:
     * 3vfList<Map<String, Object>>CX^X<br>
     *                  <br>
     *                  vf0-=Map<String,Object>CX^X<br>
     *                  key="a",value="value00"<br>
     *                  vf1=Map<String,Object>CX^X<br>
     *                  key="a",value="value01"<br>
     *                  vf2=Map<String,Object>CX^X<br>
     *                  key="a",value="value02"<br>
     *         
     * <br>
     * objJavaBeanvfz̏ꍇA
     * 3̗vfList<Map<String,Object>CX^XԂ邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap03() throws Exception {
        ConvertUtil_Stub01 bean = new ConvertUtil_Stub01();
        bean.setA("value00");
        ConvertUtil_Stub01 bean02 = new ConvertUtil_Stub01();
        bean02.setA("value01");
        ConvertUtil_Stub01 bean03 = new ConvertUtil_Stub01();
        bean03.setA("value02");
        
        ConvertUtil_Stub01[] obj =
            new ConvertUtil_Stub01[] {bean, bean02, bean03};

        // eXg{
        List<Map<String, Object>> actual = ConvertUtil.toListOfMap(obj);

        // 
        assertNotNull(actual);
        assertEquals(3, actual.size());
        assertEquals("value00", actual.get(0).get("a"));
        assertEquals("value01", actual.get(1).get("a"));
        assertEquals("value02", actual.get(2).get("a"));
    }

    /**
     * testToListOfMap04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD, E
     * <br><br>
     * ͒lF() obj:3vfList<Map<String, Object>>CX^X<br>
     *                <br>
     *                vf0=Map<String,Object>CX^X<br>
     *                key="a",value="value00"<br>
     *                vf1=Map<String,Object>CX^X<br>
     *                key="a",value="value01"<br>
     *                vf2=Map<String,Object>CX^X<br>
     *                key="a",value="value02"<br>
     *         
     * <br>
     * ҒlF(߂l) List<Map<String, Object>:
     *      3vfList<Map<String, Object>>CX^X<br>
     *                  <br>
     *                  vf0-=Map<String,Object>CX^X<br>
     *                  key="a",value="value00"<br>
     *                  vf1=Map<String,Object>CX^X<br>
     *                  key="a",value="value01"<br>
     *                  vf2=Map<String,Object>CX^X<br>
     *                  key="a",value="value02"<br>
     *         
     * <br>
     * objMapvfXg̏ꍇA
     * 3̗vfList<Map<String,Object>CX^XԂ邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap04() throws Exception {
        List<Map<String, Object>> obj = new ArrayList<Map<String, Object>>();
        Map<String, Object> row = new HashMap<String, Object>();
        row.put("a", "value00");
        obj.add(row);
        Map<String, Object> row02 = new HashMap<String, Object>();
        row02.put("a", "value01");
        obj.add(row02);
        Map<String, Object> row03 = new HashMap<String, Object>();
        row03.put("a", "value02");
        obj.add(row03);


        // eXg{
        List<Map<String, Object>> actual = ConvertUtil.toListOfMap(obj);

        // 
        assertNotNull(actual);
        assertEquals(3, actual.size());
        assertEquals("value00", actual.get(0).get("a"));
        assertEquals("value01", actual.get(1).get("a"));
        assertEquals("value02", actual.get(2).get("a"));
    }

    /**
     * testToListOfMap05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD, E
     * <br><br>
     * ͒lF() obj:3vfMap<String, Object>CX^X̔z<br>
     *                <br>
     *                vf0=Map<String,Object>CX^X<br>
     *                key="a",value="value00"<br>
     *                vf1=Map<String,Object>CX^X<br>
     *                key="a",value="value01"<br>
     *                vf2=Map<String,Object>CX^X<br>
     *                key="a",value="value02"<br>
     *         
     * <br>
     * ҒlF(߂l) List<Map<String, Object>:
     *      3vfList<Map<String, Object>>CX^X<br>
     *                  <br>
     *                  vf0-=Map<String,Object>CX^X<br>
     *                  key="a",value="value00"<br>
     *                  vf1=Map<String,Object>CX^X<br>
     *                  key="a",value="value01"<br>
     *                  vf2=Map<String,Object>CX^X<br>
     *                  key="a",value="value02"<br>
     *         
     * <br>
     * objMapvfz̏ꍇA
     * 3̗vfList<Map<String,Object>CX^XԂ邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap05() throws Exception {
        Map<String, Object> row = new HashMap<String, Object>();
        row.put("a", "value00");
        Map<String, Object> row02 = new HashMap<String, Object>();
        row02.put("a", "value01");
        Map<String, Object> row03 = new HashMap<String, Object>();
        row03.put("a", "value02");
        
        Map[] obj = new Map[] {row, row02, row03};


        // eXg{
        List<Map<String, Object>> actual = ConvertUtil.toListOfMap(obj);

        // 
        assertNotNull(actual);
        assertEquals(3, actual.size());
        assertEquals("value00", actual.get(0).get("a"));
        assertEquals("value01", actual.get(1).get("a"));
        assertEquals("value02", actual.get(2).get("a"));
    }
    
    /**
     * testToListOfMap06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:JavaBeanX^uCX^X<br>
     *                tB[hA="value00"<br>
     *         
     * <br>
     * ҒlF(߂l) List<Map<String, Object>:
     *      1vfList<Map<String, Object>>CX^X<br>
     *                  <br>
     *                  vf0-=Map<String,Object>CX^X<br>
     *                  key=A,value="value00"<br>
     *         
     * <br>
     * objJavaBean̏ꍇA1̗vf
     * List<Map<String,Object>CX^XԂ邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap06() throws Exception {
        ConvertUtil_Stub01 obj = new ConvertUtil_Stub01();
        obj.setA("value00");

        // eXg{
        List<Map<String, Object>> actual = ConvertUtil.toListOfMap(obj);

        // 
        assertNotNull(actual);
        assertEquals(1, actual.size());
        assertEquals("value00", actual.get(0).get("a"));
    }

    /**
     * testToListOfMap08()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:JavaBeanX^uCX^X<br>
     *                tB[hA="value00"<br>
     *         () PropertyUtils#describe̎s:
     *                  InvocationTargetExceptionX[
     *                    JavaBeangetterRuntimeExceptionX[<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bvꂽOFInvocationTargetException<br>
     *         
     * <br>
     * PropertyUtils#descriveInvocationTargetExceptionX[ꂽꍇ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap08() throws Exception {
        // O
        ConvertUtil_Stub02 obj = new ConvertUtil_Stub02();
        obj.setA("value00");

        try {
            // eXg{
            ConvertUtil.toListOfMap(obj);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(e.getCause() instanceof InvocationTargetException);
        }

    }

    /**
     * testToListOfMap09()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:JavaBeanX^uCX^X<br>
     *                tB[hA="value00"<br>
     *         () PropertyUtils#describe̎s:
     *                  IllegalAccessExceptionX[
     *                    PropertyUtilsBeañX^uIllegalAccessExceptionX[<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bvꂽOFIllegalAccessException<br>
     *         
     * <br>
     * PropertyUtils#descriveIllegalAccessExceptionX[ꂽꍇ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap09() throws Exception {
        // O
        List<ConvertUtil_Stub01> obj = new ArrayList<ConvertUtil_Stub01>();
        ConvertUtil_Stub01 bean = new ConvertUtil_Stub01();
        bean.setA("value00");
        obj.add(bean);
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        UTUtil.setPrivateField(beanUtilsBean, "propertyUtilsBean",
                new ConvertUtil_PropertyUtilsBeanStub01());
        
        try {
            // eXg{
            ConvertUtil.toListOfMap(obj);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(e.getCause() instanceof IllegalAccessException);
        }

    }

    /**
     * testToListOfMap10()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() obj:JavaBeanX^uCX^X<br>
     *                tB[hA="value00"<br>
     *         () PropertyUtils#describe̎s:
     *                  NoSuchMethodExceptionX[
     *                    PropertyUtilsBeañX^uNoSuchMethodExceptionX[<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bvꂽOFNoSuchMethodException<br>
     *         
     * <br>
     * PropertyUtils#descriveNoSuchMethodExceptionX[ꂽꍇ̃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToListOfMap10() throws Exception {
        // O
        List<ConvertUtil_Stub01> obj = new ArrayList<ConvertUtil_Stub01>();
        ConvertUtil_Stub01 bean = new ConvertUtil_Stub01();
        bean.setA("value00");
        obj.add(bean);
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        UTUtil.setPrivateField(beanUtilsBean, "propertyUtilsBean",
                new ConvertUtil_PropertyUtilsBeanStub02());
        
        try {
            // eXg{
            ConvertUtil.toListOfMap(obj);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(e.getCause() instanceof NoSuchMethodException);
        }

    }
}
