/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.util.ClassLoaderUtils;

import org.springframework.util.Assert;

/**
 * UTCuŎgpftHgvpeBǗNXłB
 * 
 * <pre>
 * ftHgvpeBterasoluna-unit.propertiesɐݒ肳Ă܂B
 * terasoluna-unit-override.propertiesɋLq邱ƂŁA
 * [U[ŃftHgvpeB㏑ł܂B
 * </pre>
 */
public class DefaultProperties {
    /**
     * UTCuŎgpftHgvpeBt@C(VXeŗLl)
     */
    private static final String DEFAULT_FILE_PATH = "terasoluna-unit.properties";
    /**
     * UTCuŎgpftHgvpeBt@C(㏑p)
     */
    private static final String OVERRIDE_FILE_PATH = "terasoluna-unit-override.properties";

    private static final ConcurrentMap<String, String> properties = new ConcurrentHashMap<String, String>();

    static {
        // vpeBt@CL[Elǂݍ݂܂B
        Properties defaults = new Properties();
        Properties override = new Properties();
        loadProperties(defaults, DEFAULT_FILE_PATH);
        loadProperties(override, OVERRIDE_FILE_PATH);
        for (Entry<?, ?> e : defaults.entrySet()) {
            properties.put((String) e.getKey(), (String) e.getValue());
        }
        // ㏑
        for (Entry<?, ?> e : override.entrySet()) {
            properties.put((String) e.getKey(), (String) e.getValue());
        }
    }

    /**
     * vpeBt@Cǂݍ݂܂B
     * 
     * <pre>
     * vpeBt@C݂Ȃꍇ͓ǂݍ݂܂B
     * ǂݍݒIOOꍇ{@link UTRuntimeException}X[܂B
     * </pre>
     * 
     * @param props
     *            vpeB
     * @param filePath
     *            ǂݍރvpeBt@C
     */
    private static void loadProperties(Properties props, String filePath)
            throws UTRuntimeException {
        Assert.notNull(props);
        Assert.notNull(filePath);
        ClassLoader cl = ClassLoaderUtils.getClassLoader();
        if (cl != null) {
            InputStream strm = cl.getResourceAsStream(filePath);
            if (strm != null) {
                try {
                    props.load(strm);
                } catch (IOException e) {
                    throw new UTRuntimeException(e);
                }
            }
        }
    }

    /**
     * ftHglԋp܂B
     * 
     * @param key
     *            ftHgvpeB̃L[
     * @return ftHgpeB̒l
     */
    public static String getValue(String key) {
        return properties.get(key);
    }

    /**
     * ftHglԋp܂B
     * 
     * @param key
     *            ftHgvpeB̃L[({@link PropertyKeys}`)
     * @return ftHgpeB̒l
     */
    public static String getValue(PropertyKeys key) {
        return getValue(key.getKey());
    }
}
