/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

public class DefaultFlowCallbackInfoTest extends TestCase {

    public DefaultFlowCallbackInfoTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDefaultFlowCallbackInfo01B
     * ERXgN^flowInvokeActionMappingtB[hɊi[邱ƂmFB
     */
    public void testDefaultFlowCallbackInfo01() throws Exception {
        ActionMapping mapping = new FlowInvokeActionMapping();
        
        DefaultFlowCallbackInfo callBackInfo = new DefaultFlowCallbackInfo(mapping);
        
        assertSame(mapping, UTUtil.getPrivateField(callBackInfo, "flowInvokeActionMapping"));
    }

    /**
     * testGetActionForward01B
     * ERXgN^ɗ^ꂽActionMappingփtH[h邽߂ActionForwardԂƂmFB
     * (ActionServletu*.dovɃ}bsOĂP[X)
     */
    public void testGetActionForward01() throws Exception {
        ModuleConfig moduleConfig = new ModuleConfigImpl();
        moduleConfig.setPrefix("/module1");
        ActionMapping mapping = new FlowInvokeActionMapping();
        mapping.setPath("/path1");
        mapping.setModuleConfig(moduleConfig);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().getServletContext().setAttribute(Globals.SERVLET_KEY, "*.do");
        DefaultFlowCallbackInfo callBackInfo = new DefaultFlowCallbackInfo(mapping);
        
        ActionForward forward = callBackInfo.getActionForward(null, null, request, null);
        
        assertEquals("/module1", forward.getModule());
        assertEquals("/path1.do", forward.getPath());
    }

    /**
     * testGetActionForward02B
     * ERXgN^ɗ^ꂽActionMappingփtH[h邽߂ActionForwardԂƂmFB
     * (ActionServletu/terasoluna/*vɃ}bsOĂP[X)
     */
    public void testGetActionForward02() throws Exception {
        ModuleConfig moduleConfig = new ModuleConfigImpl();
        moduleConfig.setPrefix("");
        ActionMapping mapping = new FlowInvokeActionMapping();
        mapping.setPath("/path1");
        mapping.setModuleConfig(moduleConfig);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().getServletContext().setAttribute(Globals.SERVLET_KEY, "/terasoluna/*");
        DefaultFlowCallbackInfo callBackInfo = new DefaultFlowCallbackInfo(mapping);
        
        ActionForward forward = callBackInfo.getActionForward(null, null, request, null);
        
        assertEquals("", forward.getModule());
        assertEquals("/terasoluna/path1", forward.getPath());
    }

    /**
     * testGetActionForward03B
     * ERXgN^ɗ^ꂽActionMappingփtH[h邽߂ActionForwardԂƂmFB
     * (ActionServletu/vɃ}bsOĂP[X)
     */
    public void testGetActionForward03() throws Exception {
        ModuleConfig moduleConfig = new ModuleConfigImpl();
        moduleConfig.setPrefix("/module1");
        ActionMapping mapping = new FlowInvokeActionMapping();
        mapping.setPath("/path1");
        mapping.setModuleConfig(moduleConfig);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().getServletContext().setAttribute(Globals.SERVLET_KEY, "/");
        DefaultFlowCallbackInfo callBackInfo = new DefaultFlowCallbackInfo(mapping);
        
        ActionForward forward = callBackInfo.getActionForward(null, null, request, null);
        
        assertEquals("/module1", forward.getModule());
        assertEquals("/path1", forward.getPath());
    }

}
