/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.taglib;

import java.util.Hashtable;

import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.VariableInfo;

import junit.framework.TestCase;

public class ExtractTeiTest extends TestCase {

    public ExtractTeiTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testGetVariableInfoTagData01B
     * idw肳ĂꍇA1VariableInfoi[ꂽVariableInfoz񂪕ԋp邱ƂmFB
     * VariableInfoł́A
     * ϐFid̒l
     * ϐ^Fjava.lang.Object
     * DeclareFtrue
     * XR[vFVariableInfo.AT_BEGIN
     * ƂȂĂ邱ƂmFB
     */
    public void testGetVariableInfoTagData01() {
        ExtractTei tei = new ExtractTei();
        TagData data = new TagData(new Hashtable());
        data.setAttribute("id", "result");
        
        VariableInfo[] ret = tei.getVariableInfo(data);
        
        assertEquals(1, ret.length);
        assertEquals("result", ret[0].getVarName());
        assertEquals("java.lang.Object", ret[0].getClassName());
        assertTrue(ret[0].getDeclare());
        assertEquals(VariableInfo.AT_BEGIN, ret[0].getScope());
    }

    /**
     * testGetVariableInfoTagData02B
     * idw肳ĂȂꍇA0VariableInfoz񂪕ԋp邱ƂmFB
     */
    public void testGetVariableInfoTagData02() {
        ExtractTei tei = new ExtractTei();
        TagData data = new TagData(new Hashtable());
        
        VariableInfo[] ret = tei.getVariableInfo(data);
        
        assertEquals(0, ret.length);
    }

}
