/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * LeftTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class LeftTagTest extends TestCase {

    // eXgΏ
    LeftTag tag = null;

    /**
     * Constructor for LeftTagTest.
     * @param arg0
     */
    public LeftTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (LeftTag) TagUTUtil.create(LeftTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoFormat01B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * string="Java write once, run anywhere."<br>
     * length=15<br>
     * <br>
     * Ғl<br>
     * ߂l:String="Java write once"<br>
     * <br>
     * stringNullł͂ȂAlength
     * string̒ꍇ̃eXgP[X<br>
     */
    public void testDoFormat01() throws Exception {

        // eXgݒ
        UTUtil.setPrivateField(tag, "length", 15);

        // eXgs
        String result = tag.doFormat("Java write once, run anywhere.");

        // eXgʊmF
        assertEquals("Java write once", result);

    } /* testDoFormat1 End */

    /**
     * testDoFormat02B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * string="Java write once, run anywhere."<br>
     * length=50<br>
     * <br>
     * Ғl<br>
     * ߂l:String="Java write once, run anywhere."<br>
     * <br>
     * stringNullł͂ȂAlength
     * string̒Zꍇ̃eXgP[X<br>
     */
    public void testDoFormat02() throws Exception {

        // eXgݒ
        UTUtil.setPrivateField(tag, "length", 50);

        // eXgs
        String result = tag.doFormat("Java write once, run anywhere.");

        // eXgʊmF
        assertEquals("Java write once, run anywhere.", result);

    } /* testDoFormat2 End */

    /**
     * testDoFormat03B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * string=null<br>
     * length=10<br>
     * <br>
     * Ғl<br>
     * ߂l:String=NullPointerException<br>
     * <br>
     * stringNull̏ꍇ̃eXgP[X<br>
     */
    public void testDoFormat03() throws Exception {

        // eXgݒ
        UTUtil.setPrivateField(tag, "length", 10);

        // eXgs
        try {
            tag.doFormat(null);
            fail();
        } catch (NullPointerException ex) {
            // eXgʊmF
            assertEquals(NullPointerException.class.getName(), ex.getClass()
                    .getName());
            return;
        }
    } /* testDoFormat3 End */

    /**
     * testDoFormat04B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * string="Java write once, run anywhere."<br>
     * length=-<br>
     * <br>
     * Ғl<br>
     * ߂l:String=󔒕<br>
     * <br>
     * stringNullł͂ȂAlength̐ݒȂꍇ̃eXgP[X<br>
     */
    public void testDoFormat04() {

        // eXgs
        String result = tag.doFormat("Java write once, run anywhere.");

        // eXgʊmF
        assertEquals("", result);

    } /* testDoFormat4 End */

    /**
     * testRelease01B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * length=24<br>
     * 
     * Ғl
     * ߂l:void<br>
     * length=0<br>
     * 
     * OƂĐݒ肵elA
     * sɊel邱ƂmF<br>
     */
    public void testRelease01() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "length", 24);

        // eXgs
        tag.release();

        // eXgʊmF
        assertEquals(new Integer(0), UTUtil.getPrivateField(tag, "length"));

    } /* testRelease1 End */

    /**
     * testSetLength01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * length="99"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * length="99"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetLength01() throws Exception {
        // eXgs
        tag.setLength(99);

        // eXgʊmF
        assertEquals(new Integer(99), UTUtil.getPrivateField(tag, "length"));

    } /* testSetLength End */

    /**
     * testGetLength01()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :Ȃ<br>
     * Ғl :length=30<br>
     *
     * ZbgĂl擾ł邱ƂmFB<br>
     *
     */
    public void testGetLength01() throws Exception {
        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "length", 30);

        // eXgs
        // eXgʊmF
        assertEquals(30, tag.getLength());
    }

} /* LeftTagTest Class End */
