/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.util.HashMap;

import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.DispatchAction} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * tH[h̐U蕪sANVB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.DispatchAction
 */
@SuppressWarnings("unchecked")
public class DispatchActionTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DispatchActionTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DispatchActionTest(String name) {
        super(name);
    }

    /**
     * testSetEvent01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"event"<br>
     *         () event:null<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) event:"event"<br>
     *         
     * <br>
     * Ɏw肵leventɐɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetEvent01() throws Exception {
        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXg{
        action.setEvent("event");

        // 
        assertEquals("event", UTUtil.getPrivateField(action, "event"));
    }

    /**
     * testDoExecute01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_success"}]<br>
     *                ["forward_success2"F{"ABC"}]<br>
     *         () forward:"success"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *                "BLOCKAGE_THRU_KEY"F"BLOCK"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * "event"ɊY郊NGXg̃p[^l"forward_success"̏ꍇA}bsOɐݒ肳ĂActionForward"success"ԋp邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"폜邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute01() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_success" };
        req.setParameter("event", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        req.setParameter("forward_success2", eventParamValues2);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");
        req.setAttribute("BLOCKAGE_THRU_KEY", "BLOCK");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"success"̃ANVtH[hԋp邱
        assertEquals("success", ret.getName());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_success1"}]<br>
     *         () forward:"success1"<br>
     *         () attribute:null<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:null<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * "event"ɊY郊NGXg̃p[^l"forward_success1"̏ꍇA}bsOɐݒ肳ĂActionForward"success1"݂Ȃnull̃ANVtH[hԋp邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_success1" };
        req.setParameter("event", eventParamValues1);

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // null̃ANVtH[hԋp邱
        assertNull(ret);
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAC
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *         () form:null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_success"}]<br>
     *         () forward:"success"<br>
     *         () attribute:"BLOCKAGE_THRU_KEY"F"BLOCK"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * formExnull̏ꍇAO邱ƂȂ삷邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_KEY"݂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute03() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DynaValidatorActionFormEx formEx = null;

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_success" };
        req.setParameter("event", eventParamValues1);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");
        req.setAttribute("BLOCKAGE_THRU_KEY", "BLOCK");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"success"̃ANVtH[hԋp邱
        assertEquals("success", ret.getName());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:"EVENT_FIELD"<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_success1"}]<br>
     *                ["EVENT_FIELD"F{"forward_success"}]<br>
     *         () forward:"success"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * mapping̃CxgtB[hl"EVENT_FIELD"̏ꍇANGXg̃p[^lL[F"EVENT_FIELD"ƂĒl擾A}bsOɐݒ肳ĂActionForward"success"ԋp邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute04() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_success1" };
        req.setParameter("event", eventParamValues1);
        String[] eventParamValues2 = { "forward_success" };
        req.setParameter("EVENT_FIELD", eventParamValues2);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();
        
        // eventF"EVENT_FIELD"
        UTUtil.setPrivateField(action, "event", "EVENT_FIELD");

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"success"̃ANVtH[hԋp邱
        assertEquals("success", ret.getName());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:InputF"/input.jsp"<br>
     *                ActionForwardNameF"success"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_#input"}]<br>
     *                ["EVENT_FIELD"F{"forward_success"}]<br>
     *         () forward:"#input"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *                "BLOCKAGE_THRU_KEY"F"BLOCK"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:Vɍ쐬ActionFoward<br>
     *                  iPathF"/input.jsp"j<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * NGXg̃p[^l"forward_#input"ŁA}bsOinputƃANVtH[h̗ݒ肵ꍇAInputpXƂActionForwardVɐAԋp邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute05() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setInput("/input.jsp");

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_#input" };
        req.setParameter("event", eventParamValues1);
        String[] eventParamValues2 = { "forward_success" };
        req.setParameter("EVENT_FIELD", eventParamValues2);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");
        req.setAttribute("BLOCKAGE_THRU_KEY", "BLOCK");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"/input.jsp"̃ANVtH[hԋp邱
        assertEquals("/input.jsp", ret.getPath());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:InputF"/input.jsp"<br>
     *                ActionForwardNameF"success"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_#INPUT"}]<br>
     *                ["EVENT_FIELD"F{"forward_success"}]<br>
     *         () forward:"#INPUT"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *                "BLOCKAGE_THRU_KEY"F"BLOCK"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:Vɍ쐬ActionFoward<br>
     *                  iPathF"/input.jsp"j<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * NGXg̃p[^l"forward_#INPUT"Ƒ啶̏ꍇłAInputpXƂActionForwardVɐAԋp邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute06() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setInput("/input.jsp");

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_#INPUT" };
        req.setParameter("event", eventParamValues1);
        String[] eventParamValues2 = { "forward_success" };
        req.setParameter("EVENT_FIELD", eventParamValues2);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");
        req.setAttribute("BLOCKAGE_THRU_KEY", "BLOCK");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"/input.jsp"̃ANVtH[hԋp邱
        assertEquals("/input.jsp", ret.getPath());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *                ActionForwardNameF"default"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:"event"<br>
     *         () params:["not_event"F{"forward_success"}]<br>
     *         () forward:"default"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *                "BLOCKAGE_THRU_KEY"F"BLOCK"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"default")<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * "event"ɊY郊NGXgp[^l݂Ȃߘ_tH[h"default"łꍇA}bsOɐݒ肳ĂActionForward"default"ԋp邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute07() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // "default"̃ANVtH[h̐
        ActionForward dForward = new ActionForward();
        dForward.setName("default");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        mConfig.addForwardConfig(dForward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_success" };
        req.setParameter("not_event", eventParamValues1);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");
        req.setAttribute("BLOCKAGE_THRU_KEY", "BLOCK");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"default"̃ANVtH[hԋp邱
        assertEquals("default", ret.getName());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAC
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_"}]<br>
     *         () forward:""<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *                "BLOCKAGE_THRU_KEY"F"BLOCK"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:null<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * "event"ɊY郊NGXg̃p[^l"forward_"̏ꍇA}bsOɐݒ肳ĂActionForward""݂Ȃnull̃ANVtH[hԋp邱ƂmFB<br>
     * ǃ`FbNtO"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute08() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_" };
        req.setParameter("event", eventParamValues1);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");
        req.setAttribute("BLOCKAGE_THRU_KEY", "BLOCK");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // null̃ANVtH[hԋp邱
        assertNull(ret);
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute09()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:{CANCEL_KEY != null}<br>
     *         () res:not null<br>
     *         () event:null<br>
     *         () eventField:*<br>
     *         () params:not null<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *                "BLOCKAGE_THRU_KEY"F"BLOCK"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:cancell\bhԋpANVpX<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂<br>
     *         
     * <br>
     * NGXgɂCANCEL_KEY݂ꍇAcancell\bhĂяoƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute09() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute(Globals.CANCEL_KEY, "true");
        UTUtil.setPrivateField(req, "params", null);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");
        req.setAttribute("BLOCKAGE_THRU_KEY", "BLOCK");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchActionImpl01();

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);
        
        assertEquals("cancelled", ret.getName());
        
        // 폜ĂȂ
        assertEquals("THRU", req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertEquals("BLOCK", req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *         () form:not null<br>
     *         () req:{CANCEL_KEY != null}<br>
     *         () res:not null<br>
     *         () event:"EVENT_FIELD"<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_success1"}]<br>
     *                ["EVENT_FIELD"F{"forward_success"}]<br>
     *         () forward:"success"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *         
     * <br>
     * NGXgɂCANCEL_KEY݂Acancell\bhnullԋpƂA}bsOɐݒ肳ĂActionForward"success"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute10() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forward = new ActionForward();
        forward.setName("success");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forward);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_success1" };
        req.setParameter("event", eventParamValues1);
        String[] eventParamValues2 = { "forward_success" };
        req.setParameter("EVENT_FIELD", eventParamValues2);
        req.setAttribute(Globals.CANCEL_KEY, "true");
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();
        
        // eventF"EVENT_FIELD"
        UTUtil.setPrivateField(action, "event", "EVENT_FIELD");

        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"success"̃ANVtH[hԋp邱
        assertEquals("success", ret.getName());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }

    /**
     * testDoExecute11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *                ActionForwardNameF"default"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:"EVENT_FIELD"<br>
     *         () eventField:"event"<br>
     *         () params:["event"F{"forward_XXXX"}]<br>
     *         () forward:"default"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"default")<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *
     * <br>
     * ActionMapping ̘_tH[hF"default"ݒ肳ĂOŁA
     * "event"ɊY郊NGXgp[^l"forward_XXXX"
     * iXXXX: ActionMapping ɂ݂͑Ȃ_tH[hĵƂA
     * ԋplƂ "default"ActionMapping ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute11() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forwardSuccess = new ActionForward();
        forwardSuccess.setName("success");
        // "default"̃ANVtH[h̐
        ActionForward forwardDefault = new ActionForward();
        forwardDefault.setName("default");

        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forwardSuccess);
        mConfig.addForwardConfig(forwardDefault);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "forward_XXXX" };
        req.setParameter("event", eventParamValues1);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();
        
        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"default"̃ANVtH[hԋp邱
        assertNotNull(ret);
        assertEquals("default", ret.getName());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }
    
    /**
     * testDoExecute12()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionForwardNameF"success"<br>
     *                ActionForwardNameF"default"<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () event:"EVENT_FIELD"<br>
     *         () eventField:"event"<br>
     *         () params:["forward_XXXX"F{"ABC"}]<br>
     *         () forward:"default"<br>
     *         () attribute:"SERVER_BLOCKAGE_THRU_KEY"F"THRU"<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"default")<br>
     *         (ԕω) restrictionEscapePaths:"SERVER_BLOCKAGE_THRU_KEY""BLOCKAGE_THRU_KEY"݂Ȃ<br>
     *
     * <br>
     * ActionMapping ̘_tH[hF"default"ݒ肳ĂOŁA
     * "event"ɊY郊NGXgp[^l"forward_XXXX"
     * iXXXX: ActionMapping ɂ݂͑Ȃ_tH[hĵƂA
     * ԋplƂ "default"ActionMapping ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute12() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();

        // "success"̃ANVtH[h̐
        ActionForward forwardSuccess = new ActionForward();
        forwardSuccess.setName("success");
        // "default"̃ANVtH[h̐
        ActionForward forwardDefault = new ActionForward();
        forwardDefault.setName("default");

        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forwardSuccess);
        mConfig.addForwardConfig(forwardDefault);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        String[] eventParamValues1 = { "ABC" };
        req.setParameter("forward_XXXX", eventParamValues1);
        // ̐ݒ
        req.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "THRU");

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        // DispatchAction
        DispatchAction action = new DispatchAction();
        
        // eXgs
        ActionForward ret = action.doExecute(mapping, formEx, req, res);

        // ʂ̊mF
        // }bsOɐݒ肳Ă"success"̃ANVtH[hԋp邱
        assertNotNull(ret);
        assertEquals("default", ret.getName());
        // 폜Ă邱
        assertNull(req.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertNull(req.getAttribute("BLOCKAGE_THRU_KEY"));
    }
    
    /**
     * testDoDetermineForward01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["event"F{"forward_success1"}]<br>
     *                ["forward_success2"F{"ABC"}]<br>
     *         () event:"event"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"success1"<br>
     *         
     * <br>
     * paramsɃL["event"݂A̒l"forward_"n܂Ă΁A"forward_"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward01() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward_success1" };
        params.put("event", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        params.put("forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "event");

        // ʊmF
        assertEquals("success1", ret);
    }

    /**
     * testDoDetermineForward02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["event"F{"forward1_success","forward_success1"}]<br>
     *                ["forward_success2"F{"ABC"}]<br>
     *         () event:"event"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"success1"<br>
     *         
     * <br>
     * paramsɃL["event"݂A̓1̒l"forward_"n܂Ă΁A"forward_"񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward02() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward1_success", "forward_success1" };
        params.put("event", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        params.put("forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "event");

        // ʊmF
        assertEquals("success1", ret);
    }

    /**
     * testDoDetermineForward03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["event"F{"success1","success2"}]<br>
     *                ["forward_success2"F{"ABC"}]<br>
     *         () event:"event"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"success2"<br>
     *         
     * <br>
     * paramsɃL["event"݂A̒l"forward_"n܂̂ꍇA"forward_"n܂L[΁A"forward_"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward03() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "success1", "success2" };
        params.put("event", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        params.put("forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "event");

        // ʊmF
        assertEquals("success2", ret);
    }

    /**
     * testDoDetermineForward04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["not_event"F{"forward_success1"}]<br>
     *                ["forward_success2"F{"ABC"}]<br>
     *         () event:"event"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"success2"<br>
     *         
     * <br>
     * paramsɃL["event"݂ȂꍇA"forward_"n܂L[΁A"forward_"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward04() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward_success1" };
        params.put("not_event", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        params.put("forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "event");

        // ʊmF
        assertEquals("success2", ret);
    }

    /**
     * testDoDetermineForward05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["not_event"F"forward_success1"]<br>
     *                ["not_forward_success2"F{"ABC"}]<br>
     *         () event:"event"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"default"<br>
     *         
     * <br>
     * paramsɃL["event"݂A"forward_"n܂L[݂ȂꍇA"default"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward05() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward_success1" };
        params.put("not_event", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        params.put("not_forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "event");

        // ʊmF
        assertEquals("default", ret);
    }

    /**
     * testDoDetermineForward06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["event"F{"forward_"}]<br>
     *                ["forward_success2"F{"ABC"}]<br>
     *         () event:"event"<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * paramsɃL["event"݂A̒l"forward_"̏ꍇA󕶎ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward06() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward_" };
        params.put("event", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        params.put("not_forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "event");

        // ʊmF
        assertEquals("", ret);
    }

    /**
     * testDoDetermineForward07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAC
     * <br><br>
     * ͒lF() params:Map<br>
     *         () event:"event"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"default"<br>
     *         
     * <br>
     * params̏ꍇA"default"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward07() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "event");

        // ʊmF
        assertEquals("default", ret);
    }

    /**
     * testDoDetermineForward08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["event"F{"forward_success1"}]<br>
     *                ["forward_success2"F{"forward_ABC","forward_success"}]<br>
     *         () event:"forward_success2"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"ABC"<br>
     *         
     * <br>
     * eventField"forward_success2"ɂꍇAparamsɃL[݂A̒l"forward_"n܂Ă΁A"forward_"ԋp邱ƂmFB<br>
     * "forward_"n܂l݂ꍇ́Aindex̍łႢl"forward_"񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward08() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward_success1" };
        params.put("event", eventParamValues1);
        String[] eventParamValues2 = { "forward_ABC", "forward_success" };
        params.put("forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "forward_success2");

        // ʊmF
        assertEquals("ABC", ret);
    }

    /**
     * testDoDetermineForward09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:["event"F{"forward_success1"}]<br>
     *                ["forward_"F{"forward_ABC"}]<br>
     *         () event:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * eventField󕶎ɐݒ肵Aparams擾l"forward_"̏ꍇA󕶎ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward09() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward_success1" };
        params.put("event", eventParamValues1);
        String[] eventParamValues2 = { "forward_ABC" };
        params.put("forward_", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "");

        // ʊmF
        assertEquals("", ret);
    }

    /**
     * testDoDetermineForward10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAC
     * <br><br>
     * ͒lF() params:[""F{"forward_success1"}]<br>
     *                ["forward_success2"F{"ABC"}]<br>
     *         () event:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:"success1"<br>
     *         
     * <br>
     * eventField󕶎ɂꍇAparamsɃL[݂A̒l"forward_"n܂Ă΁A"forward_"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward10() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "forward_success1" };
        params.put("", eventParamValues1);
        String[] eventParamValues2 = { "ABC" };
        params.put("forward_success2", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "");

        // ʊmF
        assertEquals("success1", ret);
    }

    /**
     * testDoDetermineForward11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() params:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:"default"<br>
     *         
     * <br>
     * paramsnull̏ꍇA"default"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward11() throws Exception {
        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(null, "event");
        
        // ʊmF
        assertEquals("default", ret);
    }
    
    /**
     * testDoDetermineForward12()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FAC
     * <br><br>
     * ͒lF() params:["forward_success.x"F{"100"}]<br>
     *                ["forward_success.y"F{"200"}]<br>
     *         () event:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:"success"<br>
     *         
     * <br>
     * eventField󕶎ɂꍇAparamsɃL[݂A̒l"forward_"n܂A".x"".y"IĂ΁A"forward_"".x"".y"ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoDetermineForward12() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        String[] eventParamValues1 = { "100" };
        params.put("forward_success.x", eventParamValues1);
        String[] eventParamValues2 = { "200" };
        params.put("forward_success.y", eventParamValues2);

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        String ret = action.doDetermineForward(params, "");

        // ʊmF
        assertEquals("success", ret);
    }


    /**
     * testExists01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:{["PARAM_NAME":"PARAM_VALUE"]}<br>
     *         () name:"PARAM_NAME"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * paramsnameL[ƂvfꍇAtrueԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExists01() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        params.put("PARAM_NAME", "PARAM_VALUE");

        // NGXgp[^
        String name = "PARAM_NAME";

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        boolean ret = action.exists(params, name);

        // ʊmF
        assertTrue(ret);
    }

    /**
     * testExists02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() params:Map<br>
     *         () name:"PARAM_NAME"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * paramsnameL[ƂvfȂꍇAfalseԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExists02() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();

        // NGXgp[^
        String name = "PARAM_NAME";

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        boolean ret = action.exists(params, name);

        // ʊmF
        assertFalse(ret);
    }

    /**
     * testExists03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() params:{["":"PARAM_VALUE"]}<br>
     *         () name:""<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:|<br>
     *         
     * <br>
     * name󕶎̏ꍇłOɁAʓIȕƓl̏s邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExists03() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = new HashMap();
        params.put("", "PARAM_VALUE");

        // NGXgp[^
        String name = "";

        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXgs
        boolean ret = action.exists(params, name);

        // ʊmF
        assertTrue(ret);
    }

    /**
     * testExists04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() params:null<br>
     *         () name:"PARAM_NAME"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:|<br>
     *         (ԕω) O:NullPointerException<br>
     *         
     * <br>
     * paramsnull̏ꍇANullPointerException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExists04() throws Exception {
        // NGXgp[^i}bv`j
        HashMap params = null;

        // NGXgp[^
        String name = "PARAM_NAME";

        // DispatchAction
        DispatchAction action = new DispatchAction();

        try {
            // eXgs
            action.exists(params, name);
            fail();
        } catch (NullPointerException npe) {
            // ʊmF
        }
    }

    /**
     * testCancelled01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:null<br>
     *         
     * <br>
     * nullԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCancelled01() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();
        
        // ActionFormEx̍쐬
        DispatchAction_DynaValidatorActionFormExStub01 formEx =
            new DispatchAction_DynaValidatorActionFormExStub01();

        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        
        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXg{
        ActionForward af = action.cancelled(mapping, formEx, req, res);
        
        // 
        assertNull(af);
    }

    /**
     * testCancelled02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         
     * <br>
     * ҒlF(߂l) ActionForward:null<br>
     *         
     * <br>
     * nullԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCancelled02() throws Exception {
        // ActionMapping쐬
        ActionMappingEx mapping = new ActionMappingEx();
        
        // HTTPNGXg̐
        MockHttpServletRequest req = new MockHttpServletRequest();

        // HTTPX|X̐
        MockHttpServletResponse res = new MockHttpServletResponse();

        
        // DispatchAction
        DispatchAction action = new DispatchAction();

        // eXg{
        ActionForward af = action.cancelled(mapping, null, req, res);
        
        // 
        assertNull(af);
    }

}
