/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader;
import jp.terasoluna.fw.web.struts.action.MockWebApplicationContext;
import jp.terasoluna.fw.web.struts.actions.BLogicAction;
import jp.terasoluna.fw.web.struts.actions.ClearSessionAction;
import jp.terasoluna.fw.web.struts.actions.DispatchAction;
import jp.terasoluna.fw.web.struts.actions.ForwardAction;
import jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class GeneralConfigurationReflectorTest {

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * supports\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : null</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : false</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSupports001() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        boolean result = reflector.supports(action, beanName, mapping, servlet,
                applicationContext);

        // 
        assertFalse(result);
    }

    /**
     * supports\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new org.apache.struts.actions.ForwardAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : false</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSupports002() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new org.apache.struts.actions.ForwardAction();
        String beanName = null;
        ActionMapping mapping = new ActionMapping();
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        boolean result = reflector.supports(action, beanName, mapping, servlet,
                applicationContext);

        // 
        assertFalse(result);
    }

    /**
     * supports\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ForwardAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : true</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSupports003() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ForwardAction();
        String beanName = null;
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        boolean result = reflector.supports(action, beanName, mapping, servlet,
                applicationContext);

        // 
        assertTrue(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : null</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration001() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ForwardAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration002() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ForwardAction();
        String beanName = null;
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new BLogicAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testSetConfiguration003() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new BLogicAction();
        String beanName = null;
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new DispatchAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration004() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new DispatchAction();
        String beanName = null;
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ClearSessionAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration010() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ClearSessionAction();
        String beanName = null;
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ClearSessionAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(clearSessionKeysBeanName : "clearSessionKeysBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration011() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ClearSessionAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String clearSessionKeysBeanName = "clearSessionKeysBean";
        // mapping.setClearSessionKeysBeanName(clearSessionKeysBeanName);

        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ClearSessionAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(clearSessionKeysBeanName : "clearSessionKeysBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration012() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ClearSessionAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String clearSessionKeysBeanName = "clearSessionKeysBean";
        // mapping.setClearSessionKeysBeanName(clearSessionKeysBeanName);

        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ClearSessionAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(clearSessionKeysBeanName : "clearSessionKeysBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(clearSessionKeysBeanName) : Boolean.TRUE, <br>
     * getBean(clearSessionKeysBeanName) : new ArrayList(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testSetConfiguration013() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ClearSessionAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String clearSessionKeysBeanName = "clearSessionKeysBean";
        // mapping.setClearSessionKeysBeanName(clearSessionKeysBeanName);

        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(clearSessionKeysBeanName,
                Boolean.TRUE);
        List clearSessionKeysBeanList = new ArrayList();
        applicationContext.addBeanMap(clearSessionKeysBeanName,
                clearSessionKeysBeanList);

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ClearSessionAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(clearSessionKeysBeanName : "clearSessionKeysBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(clearSessionKeysBeanName) : Boolean.TRUE, <br>
     * getBean(clearSessionKeysBeanName) : new Object(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration014() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ClearSessionAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String clearSessionKeysBeanName = "clearSessionKeysBean";
        // mapping.setClearSessionKeysBeanName(clearSessionKeysBeanName);

        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(clearSessionKeysBeanName,
                Boolean.TRUE);
        Object clearSessionKeysBeanList = new Object();
        applicationContext.addBeanMap(clearSessionKeysBeanName,
                clearSessionKeysBeanList);

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration020() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ReloadCodeListAction();
        String beanName = null;
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(codeListLoaderBeanName : "codeListLoaderBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration021() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ReloadCodeListAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String codeListLoaderBeanName = "codeListLoaderBean";
        // mapping.setCodeListLoaderBeanName(codeListLoaderBeanName);

        ActionServlet servlet = null;
        ApplicationContext applicationContext = null;

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(codeListLoaderBeanName : "codeListLoaderBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext()</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration022() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ReloadCodeListAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String codeListLoaderBeanName = "codeListLoaderBean";
        // mapping.setCodeListLoaderBeanName(codeListLoaderBeanName);

        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(codeListLoaderBeanName : "codeListLoaderBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(codeListLoaderBeanName) : Boolean.TRUE, <br>
     * getBean(codeListLoaderBeanName) : new ReloadableCodeListLoader() {}, <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration023() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ReloadCodeListAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String codeListLoaderBeanName = "codeListLoaderBean";
        // mapping.setCodeListLoaderBeanName(codeListLoaderBeanName);

        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(codeListLoaderBeanName,
                Boolean.TRUE);
        ReloadableCodeListLoader codeListLoaderBean = new ReloadableCodeListLoader() {
            public void reload() {
            }

            public CodeBean[] getCodeBeans() {
                return null;
            }

            public void load() {
            }

            public CodeBean[] getCodeBeans(Locale locale) {
                return null;
            }
        };
        applicationContext.addBeanMap(codeListLoaderBeanName,
                codeListLoaderBean);

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }

    /**
     * setConfiguration\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>action : new ReloadCodeListAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(codeListLoaderBeanName : "codeListLoaderBean")</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( containsBean(codeListLoaderBeanName) : Boolean.TRUE, <br>
     * getBean(codeListLoaderBeanName) : new Object(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : not null</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetConfiguration024() throws Exception {
        GeneralConfigurationReflector reflector = new GeneralConfigurationReflector();

        // p[^
        Action action = new ReloadCodeListAction();
        String beanName = null;

        ResolverActionMapping mapping = new ResolverActionMapping();
        String codeListLoaderBeanName = "codeListLoaderBean";
        // mapping.setCodeListLoaderBeanName(codeListLoaderBeanName);

        ActionServlet servlet = null;
        MockWebApplicationContext applicationContext = new MockWebApplicationContext();
        applicationContext.addContainsBeanMap(codeListLoaderBeanName,
                Boolean.TRUE);
        Object codeListLoaderBean = new Object();
        applicationContext.addBeanMap(codeListLoaderBeanName,
                codeListLoaderBean);

        // eXg
        Action result = reflector.setConfiguration(action, beanName, mapping,
                servlet, applicationContext);

        // 
        assertNotNull(result);
    }
}
