/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.CallableStatementResultSetHandler;
import com.mockrunner.jdbc.PreparedStatementResultSetHandler;
import com.mockrunner.jdbc.StatementResultSetHandler;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockCallableStatement;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockDatabaseMetaData;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockSavepoint;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.mock.jdbc.MockStruct;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MockConnection
implements Connection {
    private StatementResultSetHandler statementHandler = new StatementResultSetHandler();
    private PreparedStatementResultSetHandler preparedStatementHandler = new PreparedStatementResultSetHandler();
    private CallableStatementResultSetHandler callableStatementHandler = new CallableStatementResultSetHandler();
    private DatabaseMetaData metaData = new MockDatabaseMetaData();
    private Map savepoints;
    private int savepointCount;
    private boolean closed;
    private boolean autoCommit;
    private boolean readOnly;
    private int holdability;
    private int level;
    private Map typeMap;
    private String catalog;
    private int numberCommits;
    private int numberRollbacks;
    private Properties clientInfo;

    public MockConnection() {
        ((MockDatabaseMetaData)this.metaData).setConnection(this);
        this.closed = false;
        this.autoCommit = false;
        this.readOnly = false;
        this.holdability = 1;
        try {
            this.level = this.metaData.getDefaultTransactionIsolation();
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
        this.typeMap = new HashMap();
        this.savepoints = new HashMap();
        this.savepointCount = 0;
        this.catalog = null;
        this.numberCommits = 0;
        this.numberRollbacks = 0;
        this.clientInfo = new Properties();
    }

    public void setMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData != null && databaseMetaData instanceof MockDatabaseMetaData) {
            ((MockDatabaseMetaData)databaseMetaData).setConnection(this);
        }
        this.metaData = databaseMetaData;
    }

    public int getNumberCommits() {
        return this.numberCommits;
    }

    public int getNumberRollbacks() {
        return this.numberRollbacks;
    }

    public Map getSavepointMap() {
        return Collections.unmodifiableMap(this.savepoints);
    }

    public void resetNumberCommits() {
        this.numberCommits = 0;
    }

    public void resetNumberRollbacks() {
        this.numberRollbacks = 0;
    }

    public void resetSavepointMap() {
        this.savepoints.clear();
    }

    public StatementResultSetHandler getStatementResultSetHandler() {
        return this.statementHandler;
    }

    public PreparedStatementResultSetHandler getPreparedStatementResultSetHandler() {
        return this.preparedStatementHandler;
    }

    public CallableStatementResultSetHandler getCallableStatementResultSetHandler() {
        return this.callableStatementHandler;
    }

    public Statement createStatement() throws SQLException {
        MockStatement mockStatement = new MockStatement(this);
        this.getStatementResultSetHandler().addStatement(mockStatement);
        return mockStatement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        MockStatement mockStatement = new MockStatement(this, n, n2);
        this.getStatementResultSetHandler().addStatement(mockStatement);
        return mockStatement;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        MockStatement mockStatement = new MockStatement(this, n, n2, n3);
        this.getStatementResultSetHandler().addStatement(mockStatement);
        return mockStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        MockCallableStatement mockCallableStatement = new MockCallableStatement(this, string);
        this.getCallableStatementResultSetHandler().addCallableStatement(mockCallableStatement);
        return mockCallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        MockCallableStatement mockCallableStatement = new MockCallableStatement((Connection)this, string, n, n2);
        this.getCallableStatementResultSetHandler().addCallableStatement(mockCallableStatement);
        return mockCallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        MockCallableStatement mockCallableStatement = new MockCallableStatement(this, string, n, n2, n3);
        this.getCallableStatementResultSetHandler().addCallableStatement(mockCallableStatement);
        return mockCallableStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        MockPreparedStatement mockPreparedStatement = new MockPreparedStatement(this, string);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(mockPreparedStatement);
        return mockPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        MockPreparedStatement mockPreparedStatement = new MockPreparedStatement((Connection)this, string, n, n2);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(mockPreparedStatement);
        return mockPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        MockPreparedStatement mockPreparedStatement = new MockPreparedStatement(this, string, n, n2, n3);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(mockPreparedStatement);
        return mockPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.verifyAutoGeneratedKeysParameter(n);
        MockPreparedStatement mockPreparedStatement = new MockPreparedStatement((Connection)this, string, n == 1);
        this.getPreparedStatementResultSetHandler().addPreparedStatement(mockPreparedStatement);
        return mockPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.prepareStatement(string, 1);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.prepareStatement(string, 1);
    }

    public Blob createBlob() throws SQLException {
        return new MockBlob(new byte[0]);
    }

    public Clob createClob() throws SQLException {
        return new MockClob("");
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        MockArray mockArray = new MockArray(objectArray);
        mockArray.setBaseTypeName(string);
        return mockArray;
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        return new MockStruct(string, objectArray);
    }

    private void verifyAutoGeneratedKeysParameter(int n) throws SQLException {
        if (1 != n && 2 != n) {
            throw new SQLException("autoGeneratedKeys must be either Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS");
        }
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.level;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.clientInfo);
        return properties;
    }

    public String getClientInfo(String string) throws SQLException {
        return this.clientInfo.getProperty(string);
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public boolean isValid(int n) throws SQLException {
        return !this.isClosed();
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.autoCommit = bl;
    }

    public void setCatalog(String string) throws SQLException {
        this.catalog = string;
    }

    public void setHoldability(int n) throws SQLException {
        this.holdability = n;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint("");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        MockSavepoint mockSavepoint = new MockSavepoint(string, this.savepointCount);
        this.savepoints.put(new Integer(mockSavepoint.getSavepointId()), mockSavepoint);
        ++this.savepointCount;
        return mockSavepoint;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.level = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setClientInfo(Properties properties) {
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    public void setClientInfo(String string, String string2) {
        this.clientInfo.setProperty(string, string2);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        MockSavepoint mockSavepoint = (MockSavepoint)this.savepoints.get(new Integer(savepoint.getSavepointId()));
        if (mockSavepoint.isReleased()) {
            throw new SQLException("Savepoint with id " + mockSavepoint.getSavepointId() + " and name " + mockSavepoint.getSavepointName() + " is released");
        }
        mockSavepoint.setReleased(true);
    }

    public void commit() throws SQLException {
        ++this.numberCommits;
    }

    public void rollback() throws SQLException {
        ++this.numberRollbacks;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        MockSavepoint mockSavepoint = (MockSavepoint)this.savepoints.get(new Integer(savepoint.getSavepointId()));
        if (mockSavepoint.isReleased()) {
            throw new SQLException("Savepoint with id " + mockSavepoint.getSavepointId() + " and name " + mockSavepoint.getSavepointName() + " is released");
        }
        mockSavepoint.setRolledBack(true);
        ++this.numberRollbacks;
    }

    public void clearWarnings() throws SQLException {
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    public Object unwrap(Class clazz) throws SQLException {
        throw new SQLException("No object found for " + clazz);
    }
}

