/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockDataSource;
import com.mockrunner.mock.jdbc.MockDriver;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JDBCMockObjectFactory {
    private MockDataSource dataSource = this.createMockDataSource();
    private MockDriver driver = this.createMockDriver();
    private MockConnection connection = this.createMockConnection();
    private Set preservedDrivers = new HashSet();

    public JDBCMockObjectFactory() {
        this.setUpDependencies();
    }

    private void setUpDependencies() {
        this.dataSource.setupConnection(this.connection);
        this.driver.setupConnection(this.connection);
        this.registerMockDriver();
    }

    private void deregisterDrivers() {
        try {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                DriverManager.deregisterDriver(enumeration.nextElement());
            }
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    private void deregisterMockDrivers() {
        try {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                Driver driver = enumeration.nextElement();
                if (!(driver instanceof MockDriver)) continue;
                DriverManager.deregisterDriver(driver);
            }
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    private void preserveDrivers() {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            if (driver instanceof MockDriver) continue;
            this.preservedDrivers.add(driver);
        }
    }

    public void registerMockDriver() {
        try {
            this.preserveDrivers();
            this.deregisterDrivers();
            DriverManager.registerDriver(this.driver);
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    public void restoreDrivers() {
        this.deregisterMockDrivers();
        try {
            Iterator iterator = this.preservedDrivers.iterator();
            while (iterator.hasNext()) {
                DriverManager.registerDriver((Driver)iterator.next());
            }
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
        this.preservedDrivers.clear();
    }

    public MockConnection createMockConnection() {
        return new MockConnection();
    }

    public MockDriver createMockDriver() {
        return new MockDriver();
    }

    public MockDataSource createMockDataSource() {
        return new MockDataSource();
    }

    public MockDataSource getMockDataSource() {
        return this.dataSource;
    }

    public MockDriver getMockDriver() {
        return this.driver;
    }

    public MockConnection getMockConnection() {
        return this.connection;
    }
}

