/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.io.impl;

import java.util.Iterator;
import java.util.Map;
import jp.terasoluna.fw.ex.unit.io.Comparison;
import jp.terasoluna.fw.ex.unit.io.InputSource;
import jp.terasoluna.fw.ex.unit.io.OutputTarget;
import jp.terasoluna.fw.ex.unit.util.DefaultEqualsStrategy;
import jp.terasoluna.fw.ex.unit.util.EqualsStrategy;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInputSource<T>
implements InputSource<T> {
    protected String[] header = null;
    protected Map<String, String> headerMap = null;
    protected EqualsStrategy equalStrategy = new DefaultEqualsStrategy();

    @Override
    public Comparison compare(InputSource<T> target) {
        Iterator<T> targetItr = target.getIterator();
        Iterator thisItr = this.getIterator();
        int index = 0;
        boolean targetHasNext = targetItr.hasNext();
        boolean thisHasNext = thisItr.hasNext();
        while (targetHasNext && thisHasNext) {
            Object o1 = thisItr.next();
            T o2 = targetItr.next();
            if (!this.getEqualStrategy().equals(o1, o2)) {
                String message = "index[" + index + "] " + ToStringBuilder.reflectionToString(o1) + " does't equal " + ToStringBuilder.reflectionToString(o2);
                return Comparison.notEqual(message);
            }
            ++index;
            targetHasNext = targetItr.hasNext();
            thisHasNext = thisItr.hasNext();
        }
        return targetHasNext || thisHasNext ? Comparison.notEqual("length is wrong") : Comparison.equal();
    }

    @Override
    public void to(OutputTarget<T> target) {
        Iterator itr = this.getIterator();
        if (this.getHeader() != null) {
            target.writeHeader(this.getHeader());
        }
        while (itr.hasNext()) {
            Object obj = itr.next();
            target.write(obj);
        }
        target.close();
    }

    public EqualsStrategy getEqualStrategy() {
        return this.equalStrategy;
    }

    public void setEqualStrategy(EqualsStrategy equalStrategy) {
        this.equalStrategy = equalStrategy;
    }

    public String[] getHeader() {
        return this.header;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }
}

