/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.taglib;


import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;

import jp.terasoluna.fw.web.struts.form.ActionFormUtil;
import jp.terasoluna.fw.web.struts.taglib.PageLinksTag;

import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.taglib.TagUtils;

/**
 * y[WPʂɃy[WJڂPageLinksTag̊g@\B
 * {IȎdlTERASOLUNAt[[N񋟂PageLinksTagɏB<br/>
 * <br/>
 * <br/>
 * <strong>^OT|[g鑮</strong>
 * <p>y[WNg@\ł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1">
 *   <tr>
 *    <td><b></b></td>
 *    <td><b>ftHgl</b></td>
 *    <td><b>K{</b></td>
 *    <td><b>s</b></td>
 *    <td><b>Tv</b></td>
 *   </tr>
 *   <tr>
 *    <td><code>id</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      ̑ɕ񂪎w肳ꂽꍇA
 *      y[WN̏o͐ʂł͂Ȃy[WReLXgɕۑB
 *      ͕̑ۑL[ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>action</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      ꗗ\ʂ̕\sANVpXw肷B<br/>
 *      submitfalsȅꍇ͕K{ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>name</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      \sAJnsCfbNXAꗗSs擾Beanw肷B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>rowProperty</code></td>
 *    <td>-</td>
 *    <td><code>true</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      \sێtB[hw肷B
 *      namew肳ĂȂꍇ͒ڒl擾B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>indexProperty</code></td>
 *    <td>-</td>
 *    <td><code>true</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      \JnCfbNXێtB[hw肷B
 *      namew肳ĂȂꍇ͒ڒl擾B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>totalProperty</code></td>
 *    <td>-</td>
 *    <td><code>true</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      <code>&lt;logic:iterate&gt;</code>vfɂ
 *      `ꂽꗗ̑SsێtB[hw肷B
 *      namew肳ĂȂꍇ͒ڒl擾B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>scope</code></td>
 *    <td>-</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      nameŎw肵Bean擾XR[vw肷B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>submit</code></td>
 *    <td><code>false</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Nł͂ȂATu~bgsꍇtruew肷BftHgfalseB
 *      falsȅꍇAactionK{ƂȂB
 *      ȂȂtrueɐݒ肷action͖ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>forward</code></td>
 *    <td><code>false</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      TERASOLUNADispatchActiongpătH[hɂU蕪sꍇ
 *      gp鑮Btruew肷eventɐݒ肳ꂽlHidden^Oo͂B
 *      ܂AHidden^Ovalue"forward_pageLinks"ƂB
 *      ftHgfalseB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>event</code></td>
 *    <td><code>"event"</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      TERASOLUNADispatchActiongpătH[hɂU蕪sꍇ
 *      gp鑮BforwardtrueɂꍇȂɎw肵O
 *      Hidden^OBftHg"event"ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>resetIndex</code></td>
 *    <td><code>false</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Tu~bgɗLɂȂ鑮ŁAtrueɐݒ肷
 *      w͈̓Zbgs߂startIndexendIndexHidden^Oo͂B
 *      ftHgfalseB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>currentPageIndex</code></td>
 *    <td><code>"currentPageIndex"</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Ήꗗ̌݃y[Wy[WReLXgɕۑۂ̃L[ƂȂB
 *      ftHg"currentPageIndex"ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>totalPageCount</code></td>
 *    <td><code>"totalPageCount"</code></td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      Ήꗗ̑y[Wy[WReLXgɕۑۂ̃L[ƂȂB
 *      ftHg"totalPageCount"ƂȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td><code>pageJump</code></td>
 *    <td>false</td>
 *    <td><code>false</code></td>
 *    <td><code>true</code></td>
 *    <td align="left">
 *      g@\̃y[WWvtH[gpꍇtruew肷BftHgfalseB
 *      submit=true͎gpłȂB
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 * <br/>
 * 
 * <br/>
 * 
 * <strong>gp@</strong>
 * <li>vpeBt@C̐ݒ</li>
 * <p/>
 * {IȎgp@TERASOLUNAt[[N񋟂PageLinksTagɏB<br/>
 * g@\ɂĈȉɋLڂB<br/>
 * <p/>
 * <li>vpeBt@Cݒ̏</li>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.first.char=<i>&lt;\&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>\</i>&nbsp;F
 * ʂɕ\Aŏ̃y[WɑJڂ郊NB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.last.char=<i>&lt;\&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>\</i>&nbsp;F
 * ʂɕ\AŌy[WɑJڂ郊NB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂y[WN\Jn^OB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂y[WN\I^OB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.page.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂ey[WɑJڂ郊N\Jn^OB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.page.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂ey[WɑJڂ郊N\I^OB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.prev.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂Õy[WɑJڂ郊N\Jn^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.start.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.prev.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂Õy[WɑJڂ郊N\I^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.end.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.next.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂鎟̃y[WɑJڂ郊N\Jn^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.start.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.next.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂鎟̃y[WɑJڂ郊N\I^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.end.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.first.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂ŏ̃y[WɑJڂ郊N\Jn^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.satrt.prev.tag</code>Ŏw肳ꂽ񂪏o͂B<br/>
 * &nbsp;&nbsp;<code>pageLinks.start.prev.tag</code>w肳ĂȂꍇ́A<code>pageLinks.start.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.first.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂ŏ̃y[WɑJڂ郊N\I^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.end.prev.tag</code>Ŏw肳ꂽ񂪏o͂B<br/>
 * &nbsp;&nbsp;<code>pageLinks.end.prev.tag</code>w肳ĂȂꍇ́A<code>pageLinks.end.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.last.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂Ō̃y[WɑJڂ郊N\Jn^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.start.next.tag</code>Ŏw肳ꂽ񂪏o͂B<br/>
 * &nbsp;&nbsp;<code>pageLinks.start.next.tag</code>w肳ĂȂꍇ́A<code>pageLinks.start.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.last.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂Ō̃y[WɑJڂ郊N\I^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.end.next.tag</code>Ŏw肳ꂽ񂪏o͂B<br/>
 * &nbsp;&nbsp;<code>pageLinks.end.next.tag</code>w肳ĂȂꍇ́A<code>pageLinks.end.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.active.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂錻݃y[W\Jn^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.start.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.active.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂錻݃y[W\I^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.end.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.disable.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂郊NȂ\Jn^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.start.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.disable.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂郊NȂ\I^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.end.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.start.jump.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂y[WWvtH[\Jn^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.start.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.end.jump.tag=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * o͂y[WWvtH[\I^OB<br/>
 * &nbsp;&nbsp;w肵Ȃꍇ<code>pageLinks.end.page.tag</code>Ŏw肳ꂽ񂪏o͂B
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.jump.text.attributes=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * y[WWvtH[gp̃eLXgtH[ݒtB[hB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.jump.submit.attributes=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * y[WWvtH[gp̃Tu~bg{^ݒtB[hB
 * </p>
 * <p>
 * &nbsp;&nbsp;<code><b>pageLinks.jump.submit.char=<i>&lt;o͕&gt;</i></b></code><br/>
 * &nbsp;&nbsp;<i>o͕</i>&nbsp;F
 * y[WWvtH[gp̃Tu~bg{^valueݒ蕶BftHg"submit"ƂȂB
 * </p>
 * <br/>
 * <li>vpeBt@Cݒ</li>
 * <P>
 * <code>
 * &nbsp;&nbsp;pageLinks.first.char=First<br/>
 * &nbsp;&nbsp;pageLinks.last.char=Last<br/>
 * &nbsp;&nbsp;pageLinks.start.tag=&lt;ul&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.tag=&lt;/ul&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.page.tag=&lt;li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.page.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.prev.tag=&lt;li class="prev"&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.prev.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.next.tag=&lt;li class="next"&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.next.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.first.tag=&lt;li class="first"&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.first.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.last.tag=&lt;li class="last"&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.last.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.active.tag=&lt;li class="active"&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.active.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.disable.tag=&lt;li class="disable"&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.disable.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.start.jump.tag=&lt;li class="jump"&gt;<br/>
 * &nbsp;&nbsp;pageLinks.end.jump.tag=&lt;/li&gt;<br/>
 * &nbsp;&nbsp;pageLinks.jump.text.attributes=size="3" maxlength="2"<br/>
 * &nbsp;&nbsp;pageLinks.jump.submit.attributes=class="DisableDoubleClick"<br/>
 * &nbsp;&nbsp;pageLinks.jump.submit.char=click<br/>
 * </code>
 * </p>
 * <p/>
 * @see jp.terasoluna.fw.web.struts.taglib.PageLinksTag
 */
public class PageLinksTagEx extends PageLinksTag {
    /**
     * VAo[WUIDB
     */
    private static final long serialVersionUID = -6012015988097621650L;

    /**
     * ONXB
     */
    private static Log log =
         LogFactory.getLog(PageLinksTag.class);

    /**
     * ANVURL
     */
    protected String url = null;

    /**
     * ANVtH[
     */
    protected String formName = null;

    /**
     * y[WWvtH[gptO.
     */
    protected boolean pageJump = false;

    /**
     * url̐ݒlԋp.
     * 
     * @return ݒ肳Ăl
     */
    public String getUrl() {
        return url;
    }

    /**
     * urlݒ肷.
     * 
     * @param url
     *            ݒ肷l
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * formName̐ݒlԋp.
     * 
     * @return ݒ肳Ăl
     */
    public String getFormName() {
        return formName;
    }

    /**
     * formNameɒlݒ肷.
     * 
     * @param formName
     *            ݒ肷l
     */
    public void setFormName(String formName) {
        this.formName = formName;
    }

    /**
     * pageJump̐ݒlԋp.
     * 
     * @return ݒ肳Ăl
     */
    public boolean getPageJump() {
        return pageJump;
    }

    /**
     * pageJumpɒlݒ肷.
     * 
     * @param pageJump ݒ肷l
     */
    public void setPageJump(boolean pageJump) {
        this.pageJump = pageJump;
    }

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WN֘AڊJnp̃vpeB̍\vf.
     */
    protected static final String START_LINKS = "start";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WN֘AڏIp̃vpeB̍\vf.
     */
    protected static final String END_LINKS = "end";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ŏy[Wւ̃y[WWvpÑvpeB̍\vf.
     */
    protected static final String FIRST_LINKS = "first";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * Ōy[Wւ̃y[WWvpÑvpeB̍\vf.
     */
    protected static final String LAST_LINKS = "last";

    /**
     * y[WWvpTu~bg{^valuȅl.
     */
    protected static final String JUMPFORM_SUBMIT_DEFAULT = "submit";

    /**
     * y[WN@\ŏo͂JavaScript̏o̓tO.
     */
    protected static String PAGEJUMP_JAVASCRIPT_KEY = "pageJumpJavaScriptKey";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WN\Jn^ÕvpeB.
     */
    protected static final String START_PAGELINKS_TAG = "pageLinks.start.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WN\I^ÕvpeB.
     */
    protected static final String END_PAGELINKS_TAG = "pageLinks.end.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ey[WɑJڂ郊N\Jn^ÕvpeB.
     */
    protected static final String START_PAGE_TAG = "pageLinks.start.page.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ey[WɑJڂ郊N\I^ÕvpeB.
     */
    protected static final String END_PAGE_TAG = "pageLinks.end.page.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * Õy[WɑJڂ郊N\Jn^ÕvpeB.
     */
    protected static final String START_PREV_TAG = "pageLinks.start.prev.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * Õy[WɑJڂ郊N\I^ÕvpeB.
     */
    protected static final String END_PREV_TAG = "pageLinks.end.prev.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ̃y[WɑJڂ郊N\Jn^ÕvpeB.
     */
    protected static final String START_NEXT_TAG = "pageLinks.start.next.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ̃y[WɑJڂ郊N\I^ÕvpeB.
     */
    protected static final String END_NEXT_TAG = "pageLinks.end.next.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ŏ̃y[WɑJڂ郊N\Jn^ÕvpeB.
     */
    protected static final String START_FIRST_TAG = "pageLinks.start.first.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ŏ̃y[WɑJڂ郊N\I^ÕvpeB.
     */
    protected static final String END_FIRST_TAG = "pageLinks.end.first.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * Ō̃y[WɑJڂ郊N\Jn^ÕvpeB.
     */
    protected static final String START_LAST_TAG = "pageLinks.start.last.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * Ō̃y[WɑJڂ郊N\I^ÕvpeB.
     */
    protected static final String END_LAST_TAG = "pageLinks.end.last.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ݃y[W\Jn^ÕvpeB.
     */
    protected static final String START_ACTIVE_TAG = "pageLinks.start.active.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * ݃y[W\I^ÕvpeB.
     */
    protected static final String END_ACTIVE_TAG = "pageLinks.end.active.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * NȂ\Jn^ÕvpeB.
     */
    protected static final String START_DISABLE_TAG = "pageLinks.start.disable.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * NȂ\I^ÕvpeB.
     */

    protected static final String END_DISABLE_TAG = "pageLinks.end.disable.tag";
    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WWvtH[\Jn^ÕvpeB.
     */
    protected static final String START_JUMPFORM_TAG = "pageLinks.start.jump.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WWvtH[\I^ÕvpeB.
     */
    protected static final String END_JUMPFORM_TAG = "pageLinks.end.jump.tag";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WWvtH[gp̃eLXgtH[ݒp̃vpeB.
     */
    protected static final String JUMPFORM_TEXT_ATTRIBUTES = "pageLinks.jump.text.attributes";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WWvtH[gp̃Tu~bg{^ݒp̃vpeB.
     */
    protected static final String JUMPFORM_SUBMIT_ATTRIBUTES = "pageLinks.jump.submit.attributes";

    /**
     * <code>ApplicationResources</code> t@Cɂ
     * y[WWvtH[gp̃Tu~bg{^valueݒp̃vpeB.
     */
    protected static final String JUMPFORM_SUBMIT_VALUE = "pageLinks.jump.submit.char";

    /**
     * y[WN\Jn^O.
     */
    protected String startPageLinksTag = null;

    /**
     * y[WN\I^O.
     */
    protected String endPageLinksTag = null;

    /**
     * ey[WɑJڂ郊N\Jn^O.
     */
    protected String startPageTag = null;

    /**
     * ey[WɑJڂ郊N\I^O.
     */
    protected String endPageTag = null;

    /**
     * Õy[WɑJڂ郊N\Jn^O.
     */
    protected String startPrevTag = null;

    /**
     * Õy[WɑJڂ郊N\I^O.
     */
    protected String endPrevTag = null;

    /**
     * ̃y[WɑJڂ郊N\Jn^O.
     */
    protected String startNextTag = null;

    /**
     * ̃y[WɑJڂ郊N\I^O.
     */
    protected String endNextTag = null;

    /**
     * ŏ̃y[WɑJڂ郊N\Jn^O.
     */
    protected String startFirstTag = null;

    /**
     * ŏ̃y[WɑJڂ郊N\I^O.
     */
    protected String endFirstTag = null;

    /**
     * Ō̃y[WɑJڂ郊N\Jn^O.
     */
    protected String startLastTag = null;

    /**
     * Ō̃y[WɑJڂ郊N\I^O.
     */
    protected String endLastTag = null;

    /**
     * ݃y[W\Jn^O.
     */
    protected String startActiveTag = null;

    /**
     * ݃y[W\I^O.
     */
    protected String endActiveTag = null;

    /**
     * NȂ\Jn^O.
     */
    protected String startDisableTag = null;

    /**
     * NȂ\I^O.
     */
    protected String endDisableTag = null;

    /**
     * y[WWvtH[\Jn^O.
     */
    protected String startJumpFormTag = null;

    /**
     * y[WWvtH[\I^O.
     */
    protected String endJumpFormTag = null;

    /**
     * y[WWvtH[gp̃eLXgtH[ݒtB[h.
     */
    protected String jumpFormTextAttributes = null;

    /**
     * y[WWvtH[gp̃Tu~bg{^ݒtB[h.
     */
    protected String jumpFormSubmitAttributes = null;

    /**
     * y[WWvtH[gp̃Tu~bg{^valueݒ蕶.
     */
    protected String jumpFormSubmitValue = JUMPFORM_SUBMIT_DEFAULT;

    /**
     * ^O]JnɌĂ΂郁\bh.
     * 
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        //`FbN
        if (!submit && (action == null || "".equals(action))) {
            log.error(ERROR_MESSAGE_ACTION_REQUIRED);
            throw new JspException(ERROR_MESSAGE_ACTION_REQUIRED);
        }

        // vpeBt@C擾^Ȍ
        initTagProperty();

        // TagUtils̃CX^X
        TagUtils tagUtils = TagUtils.getInstance();

        // X|Xp[^̎擾
        HttpServletResponse response = (HttpServletResponse) pageContext
                .getResponse();

        // ANVURL̐ݒ
        setUrl(response.encodeURL(tagUtils.getActionMappingURL(action,
                pageContext)));

        //ANVtH[擾
        setFormName(ActionFormUtil
                .getActionFormName((HttpServletRequest) pageContext
                        .getRequest()));

        // vpeBt@C擾^Ȍ
        initTagProperty();

        // vpeBt@Cy[WWvpN^O擾
        getLinkProperty();

        //\s擾
        Object objRow = lookup(pageContext, name, rowProperty, scope);
        int row = getInt(objRow);

        //擾\s0ȉ̏ꍇ͏IB
        if (row <= 0) {
            if (log.isWarnEnabled()) {
                log.warn(WARN_MESSAGE_ILLEGAL_ROW);
            }
            return EVAL_BODY_INCLUDE;
        }

        //JnsCfbNX擾
        Object objIndex = lookup(pageContext, name, indexProperty, scope);
        int startIndex = getInt(objIndex);

        //S擾
        Object objTotal = lookup(pageContext, name, totalProperty, scope);
        int totalCount = getInt(objTotal);

        //StringBuilder̐
        StringBuilder sb = new StringBuilder();

        //݃y[WAy[Wݒ肷B
        attributePageCount(
                getPageIndex(row, startIndex), getPageCount(row, totalCount));

        //y[WNJn^Oǉ
        sb.append(startPageLinksTag);

        if (submit) {
            //submittruêƂ́ATu~bgsy[WNo͂B

            //\sAJnCfbNX̃^Oo
            defineHtml(row, startIndex, totalCount);

            //Tu~bgpJavaScripto
            addSubmitJS();

            //ŏy[WN̐
            addFirstSubmit(sb, row, startIndex, totalCount);

            //Oy[WN̐ݒ
            addPrevSubmit(sb, row, startIndex, totalCount);

            //y[WԍN̐ݒ
            addDirectSubmit(sb, row, startIndex, totalCount);

            //y[WN̐ݒ
            addNextSubmit(sb, row, startIndex, totalCount);

            //Ōy[WN̐
            addLastSubmit(sb, row, startIndex, totalCount);

        } else {
            //submitfalsȅꍇ

            //ŏy[WN̐
            addFirstLink(sb, row, startIndex, totalCount);

            //Oy[WN̐ݒ
            addPrevLink(sb, row, startIndex, totalCount);

            //y[WԍN̐ݒ
            addDirectLink(sb, row, startIndex, totalCount);

            //y[WN̐ݒ
            addNextLink(sb, row, startIndex, totalCount);

            //Ōy[WN̐
            addLastLink(sb, row, startIndex, totalCount);

            // pageJumptruêƂ́Ay[WWvptH[ǉo͂B
            if (pageJump) {
                // y[WWvpJavaScripto
                addJumpFormJS(row, getPageIndex(row, startIndex), getPageCount(row, totalCount));

                // y[WWvptH[o
                addJumpForm(sb, row, startIndex);
            }
        }

        //y[WNI^Oǉ
        sb.append(endPageLinksTag);

        //StringBuilderɂ߂eo͂B
        if (id == null || "".equals(id)) {
            try {
                JspWriter writer = pageContext.getOut();
                writer.println(sb.toString());
            } catch (IOException e) {
                log.error(e.getMessage());
                throw new JspTagException(e.toString());
            }
        } else {
            pageContext.setAttribute(id, sb.toString());
        }

        return EVAL_BODY_INCLUDE;

    }

    /**
     * HTML̒`o͂.
     * 
     * @param row \s
     * @param startIndex \JnCfbNX
     * @param totalCount S
     * @throws JspException JSPO
     */
    @Override
    protected void defineHtml(int row, int startIndex, int totalCount)
        throws JspException {
    
        JspWriter writer = pageContext.getOut();
        try {
    
            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + rowProperty)) {
    
                //\Hidden^Oǉ
                writer.println("<input type=\"hidden\" name=\""
                        + rowProperty + "\" value=\"" + row + "\"/>");
    
                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + rowProperty);
            }
    
            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + indexProperty)) {
    
                //\JnCfbNXHidden^Oǉ
                writer.println("<input type=\"hidden\" name=\""
                        + indexProperty + "\" value=\"" + startIndex + "\"/>");
    
                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + indexProperty);
            }
    
            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + event) && forward) {
    
                //\JnCfbNXHidden^Oǉ
                writer.println("<input type=\"hidden\" name=\"" + event
                        + "\" value=\"\"/>");
    
                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + event);
            }
    
            //OHidden^Oo͂Ȃ߁AtOm߂B
            if (!getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                    + "resetIndex") && resetIndex) {
    
                //startIndexHidden^Oǉ
                if (!"startIndex".equals(indexProperty)) {
                    writer.println("<input type=\"hidden\" name=\"" +
                            "startIndex\" value=\"" + startIndex + "\"/>");
                }
    
                //endIndexHidden^Oǉ
                int endIndex = startIndex + row - 1;
                if (endIndex >= totalCount) {
                    writer.println("<input type=\"hidden\" name=\"" +
                            "endIndex\" value=\"" + (totalCount - 1) + "\"/>");
                } else {
                    writer.println("<input type=\"hidden\" name=\"" +
                            "endIndex\" value=\"" + endIndex + "\"/>");
                }
    
                //o͂tO𗧂ĂB
                setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY
                        + "resetIndex");
            }
    
        } catch (IOException e) {
            log.error(e.getMessage());
            throw new JspTagException(e.toString());
        }
    }

    /**
     * Tu~bgsꍇJavaScripto͂.
     * 
     * @throws JspException 
     */
    protected void addSubmitJS() throws JspException{
    
        // xJavaScript͏o͂Ȃ
        if (getPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY)) {
                return;
        }

        JspWriter writer = pageContext.getOut();

        try {
            writer.println("");
            writer.println("<script type=\"text/javascript\">");
            writer.println("<!--");
            writer.println("  if(typeof(teralib) === \"undefined\"){");
            writer.println("    teralib = {};");
            writer.println("  }");
            writer.println("  teralib.pageLinkSubmit = function(rowProperty, indexProperty, row, startIndex){");
            writer.println("    var submitForm = document.getElementById('"+ formName + "_pageLinks');");
            writer.println("    submitForm[rowProperty].value = row;");
            writer.println("    submitForm[indexProperty].value = startIndex;");
        
            //forwardtruȅꍇ́AeventHidden^O  
            //p[^ݒ肷B
            if(forward) {
                writer.println("    submitForm." + event + ".value = \"" + FORWARD_NAME + "\";");
            }
        
            writer.println("    submitForm.submit();");
            writer.println("  }");
            writer.println("// -->");
            writer.println("</script>");
            writer.println("");
        
        } catch (IOException e) {
            log.error(e.getMessage());
            throw new JspException(e.toString());
        }

        // o͂tO𗧂ĂB
        setPageContextFlg(pageContext, PAGELINKS_JAVASCRIPT_KEY);

    }

    /**
     * ŏ̃y[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    protected void addFirstSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        // ŏy[W\郊N擾
        String startKey = FIRST_LINKS + CHAR_LINKS;
        String startValue = links.get(startKey);
    
        // ŏy[W\񂪎w肳ĂꍇA
        // \y[Wŏy[WȊȌꍇ
        // ŏy[W̃Nǉ
        if (startValue != null && !"".equals(startValue)) {
    
            if (startIndex == 0 || totalCount <= 0) {
                //݃y[Wŏy[WƈvA܂͈ꗗ̑S0ȉ̏ꍇ
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(startValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startFirstTag, startPrevTag, startPageTag);
                appendSubmitAnchor(sb, rowProperty, row,indexProperty, 0, startValue);
                appendIfNotEmpty(sb, endFirstTag, endPrevTag, endPageTag);
            }
        }
    }

    /**
     * Oy[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    @Override
    protected void addPrevSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        // Oy[WN̐
        for (int i = maxLinkNo; i > 0; i--) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);
            if (linkValue == null || "".equals(linkValue)) {
                continue;
            }
            int index = startIndex - (i * row);
            if (index < 0) {
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(linkValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startPrevTag, startPageTag);
                appendSubmitAnchor(sb, rowProperty, row,indexProperty, index, linkValue);
                appendIfNotEmpty(sb, endPrevTag, endPageTag);
                }
        }
    }

    /**
     * y[WԍNStringBuilderɒǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    protected void addDirectSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        addDirectAnchor(sb, row, startIndex, totalCount);
    }

    /**
     * y[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    @Override
    protected void addNextSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        // y[WN̐
        for (int i = 1; i <= maxLinkNo; i++) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);
    
            if (linkValue == null || "".equals(linkValue)) {
                continue;
            }
    
            int index = startIndex + (i * row);
            if (index > (totalCount - 1)) {
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(linkValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startNextTag, startPageTag);
                appendSubmitAnchor(sb, rowProperty, row,indexProperty, index, linkValue);
                appendIfNotEmpty(sb, endNextTag, endPageTag);
            }
        }
    }

    /**
     * ŏĨy[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    protected void addLastSubmit(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        // ŏIy[W\郊N擾
        String endKey = LAST_LINKS + CHAR_LINKS;
        String endValue = links.get(endKey);
    
        // ŏIy[W̕\JnCfbNX擾
        int endPageStartIndex = getEndPageStartIndex(row, totalCount);
    
        // ŏIy[W\񂪎w肳ĂꍇA
        // \y[WŏIy[WȊȌꍇ
        // ŏIy[W̃Nǉ
        if (endValue != null && !"".equals(endValue)) {
    
            if (endPageStartIndex == startIndex || totalCount <= 0) {
                //݃y[WŌy[WƈvA܂͈ꗗ̑S0ȉ̏ꍇ
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(endValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startLastTag, startNextTag, startPageTag);
                appendSubmitAnchor(sb, rowProperty, row,indexProperty, endPageStartIndex, endValue);
                appendIfNotEmpty(sb, endLastTag, endNextTag, endPageTag);
            }
        }
    }

    /**
     * ŏy[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    protected void addFirstLink(StringBuilder sb, int row, int startIndex,int totalCount){
        // ŏy[W\郊N擾
        String startKey = FIRST_LINKS + CHAR_LINKS;
        String startValue = links.get(startKey);

        // ŏy[W\񂪎w肳ĂꍇA
        // \y[Wŏy[WȊȌꍇ
        // ŏy[W̃Nǉ
        if (startValue != null && !"".equals(startValue)) {
            if (startIndex == 0 || totalCount <= 0) {
                //݃y[Wŏy[WƈvA܂͈ꗗ̑S0ȉ̏ꍇ
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(startValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startFirstTag, startPrevTag, startPageTag);
                appendLinkAnchor(sb, rowProperty, row, indexProperty, 0, startValue);
                appendIfNotEmpty(sb, endFirstTag, endPrevTag, endPageTag);
            }
        }
    }

    /**
     * Oy[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    @Override
    protected void addPrevLink(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        // Oy[WN̐
        for (int i = maxLinkNo; i > 0; i--) {
            String linkKey = PREV_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);

            if (linkValue == null || "".equals(linkValue)) {
                continue;
            }

            int index = startIndex - (i * row);
            if (index < 0) {
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(linkValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startPrevTag, startPageTag);
                appendLinkAnchor(sb, rowProperty, row, indexProperty, index, linkValue);
                appendIfNotEmpty(sb, endPrevTag, endPageTag);
            }
        }
    }

    /**
     * y[WԍNStringBuilderɒǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    protected void addDirectLink(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        addDirectAnchor(sb, row, startIndex, totalCount);
    }

    /**
     * y[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    @Override
    protected void addNextLink(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        // y[WN̐
        for (int i = 1; i <= maxLinkNo; i++) {
            String linkKey = NEXT_LINKS + i + CHAR_LINKS;
            String linkValue = links.get(linkKey);

            if (linkValue == null || "".equals(linkValue)) {
                continue;
            }

            int index = startIndex + (i * row);
            if (index > (totalCount - 1)) {
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(linkValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startNextTag, startPageTag);
                appendLinkAnchor(sb, rowProperty, row, indexProperty, index, linkValue);
                appendIfNotEmpty(sb, endNextTag, endPageTag);
            }
        }

    }

    /**
     * ŏĨy[WNǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    protected void addLastLink(StringBuilder sb, int row, int startIndex,
            int totalCount){
        // ŏIy[W\郊N擾
        String endKey = LAST_LINKS + CHAR_LINKS;
        String endValue = links.get(endKey);

        // ŏIy[W̕\JnCfbNX擾
        int endPageStartIndex = getEndPageStartIndex(row, totalCount);

        // ŏIy[W\񂪎w肳ĂꍇA
        // \y[WŏIy[WȊȌꍇ
        // ŏIy[W̃Nǉ
        if (endValue != null && !"".equals(endValue)) {

            if (endPageStartIndex == startIndex || totalCount <= 0) {
                //݃y[WŌy[WƈvA܂͈ꗗ̑S0ȉ̏ꍇ
                appendIfNotEmpty(sb, startDisableTag, startPageTag);
                sb.append(endValue);
                appendIfNotEmpty(sb, endDisableTag, endPageTag);
            } else {
                appendIfNotEmpty(sb, startLastTag, startNextTag, startPageTag);
                appendLinkAnchor(sb, rowProperty, row, indexProperty, endPageStartIndex, endValue);
                appendIfNotEmpty(sb, endLastTag, endNextTag, endPageTag);
            }
        }
    }

    /**
     * y[WWvtH[{^JavaScripto͂.
     * 
     * @param row
     *            \s
     * @param pageIndex
     *            ݃y[W̃CfbNX
     * @param pageCount
     *            y[W
     * @throws JspException
     *             JSPO
     */
    protected void addJumpFormJS(int row, int pageIndex, int pageCount) throws JspException{
        // xJavaScript͏o͂Ȃ
        if (getPageContextFlg(pageContext, PAGEJUMP_JAVASCRIPT_KEY)) {
                return;
        }

        JspWriter writer = pageContext.getOut();

        try {
            writer.println("");
            writer.println("<script type=\"text/javascript\">");
            writer.println("<!--");
            writer.println("  if(typeof(teralib) === \"undefined\"){");
            writer.println("    teralib = {};");
            writer.println("  }");
            writer.println("  teralib.pageLinkJump = function(form, row, indexProperty){");
            writer.println("    var jump = form.elements['jumpIndex'];");
            writer.println("    var index = form.elements[indexProperty];");
            writer.println("    var idx;");
            writer.println("    var jumpValue = parseInt(jump.value,10);");
            writer.println("    if( jumpValue == " + pageIndex + " ){");
            writer.println("      return false;");
            writer.println("    } else if( 0 < jumpValue ){");
            writer.println("      idx = (jumpValue -1) * " + row + ";");
            writer.println("      index.value = idx;");
            writer.println("      return true;");
            writer.println("    } else {");
            writer.println("      return false;");
            writer.println("    }");
            writer.println("  }");
            writer.println("// -->");
            writer.println("</script>");
            writer.println("");
        } catch (IOException e) {
            log.error(e.getMessage());
            throw new JspTagException(e.toString());
        }

        // o͂tO𗧂ĂB
        setPageContextFlg(pageContext, PAGEJUMP_JAVASCRIPT_KEY);

    }

    /**
     * y[WWvgp̃tH[o͂.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @throws JspException
     *             JSPO
     */
    protected void addJumpForm(StringBuilder sb, int row, int startIndex) {
        appendIfNotEmpty(sb, startJumpFormTag, startPageTag);
        
        sb.append("<form name=\"");
        sb.append(name);
        sb.append("\" method=\"post\" action=\"");
        sb.append(url);
        sb.append("\" onsubmit=\"return teralib.pageLinkJump(this, ");
        sb.append(row).append(",'");
        sb.append(indexProperty);
        sb.append("')\"/>");
    
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(rowProperty);
        sb.append("\" value=\"");
        sb.append(row);
        sb.append("\"/>");
    
        
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(indexProperty);
        sb.append("\"/>");
    
        sb.append("<input type=\"text\" name=\"jumpIndex\" ");
        sb.append(jumpFormTextAttributes);
        sb.append("/>");
    
        sb.append("<input type=\"submit\" value=\"");
        sb.append(jumpFormSubmitValue);
        sb.append("\" ");
        sb.append(jumpFormSubmitAttributes);
        sb.append("/>");
        sb.append("</form>");
    
        appendIfNotEmpty(sb, endJumpFormTag, endPageTag);
    }

    /**
     * y[WNpAJ[쐬.
     * 
     * @param sb
     *           ǉΏۂStringBuilder
     * @param rowProperty
     *           \s̃tB[h
     * @param row
     *           \s
     * @param indexProperty
     *           \JnCfbNX̃tB[h
     * @param startIndex
     *           \JnCfbNX
     * @param text
     *           N
     */
    protected void appendLinkAnchor(StringBuilder sb, String rowProperty, int row, String indexProperty, int startIndex, String text){
        sb.append("<a href=\"" + url);
        if(url.indexOf("?") < 0){
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(rowProperty).append("=").append(row);
        sb.append("&").append(indexProperty).append("=").append(startIndex);
        sb.append("\">");
        sb.append(text);
        sb.append("</a>");
    }

    /**
     * y[WNiTu~bgsꍇjpAJ[쐬.
     * 
     * @param sb
     *           ǉΏۂStringBuilder
     * @param rowProperty
     *           \s̃tB[h
     * @param row
     *           \s
     * @param indexProperty
     *           \JnCfbNX̃tB[h
     * @param startIndex
     *           \JnCfbNX
     * @param text
     *           N
     */
    protected void appendSubmitAnchor(StringBuilder sb, String rowProperty, int row, String indexProperty, int startIndex, String text){
        sb.append("<a href=\"#\" onclick=\"return teralib.pageLinkSubmit('");
        sb.append(rowProperty).append("','");
        sb.append(indexProperty).append("',");
        sb.append(row).append(",");
        sb.append(startIndex).append(")\">");
        sb.append(text);
        sb.append("</a>");
    }


    /**
     * y[WԍNStringBuilderɒǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param row
     *            \s
     * @param startIndex
     *            \JnCfbNX
     * @param totalCount
     *            ꗗ̑S
     */
    protected void addDirectAnchor(StringBuilder sb, int row, int startIndex,
            int totalCount) {
        // y[WWvpN̒ڔԍw̕\ő吔擾
        String directLinkNo = links.get(MAX_DSP_SIZE);
        if (directLinkNo != null) {
            try {
                maxPageCount = Integer.parseInt(directLinkNo);
            } catch (NumberFormatException e) {
                // NumberFormatExceptionꍇA
                // ̃vpeB͖maxDirectLinkCountɂ
                // ftHglgp
            }
        }

        // y[W擾B
        int pageCount = getPageCount(row, totalCount);

        // ݂̃y[WCfbNX擾B
        int pageIndex = getPageIndex(row, startIndex);

        // \ŏIy[Wѕ\Jny[W
        int startPage = 0;
        int endPage = 0;

        // y[WAy[WԍN̕\傫A
        // A\y[WCfbNXAy[WԍN̕\̔
        // 傫ꍇ́A\Jny[WCfbNXA\y[WCfbNX
        // 킹ĕϓB
        // ƂāAy[WFPOy[WAy[WԍN̕\FTA
        // \y[WCfbNXFT̏ꍇAstartPageQƂȂ
        // endPageTƂȂB̏ꍇAʂɕ\郊Ńu3 4 5 6 7vƂȂB
        if (pageCount > maxPageCount && pageIndex > (maxPageCount / 2)) {

            // \ŏIy[Wőy[WƂB
            endPage = maxPageCount;

            startPage = (pageIndex - (endPage / 2)) - 1;
            if (startPage + endPage > pageCount) {
                startPage = pageCount - endPage;
            }
        } else {
            endPage = pageCount < maxPageCount ? pageCount : maxPageCount;
            startPage = 0;
        }

        // y[WԍN̐[v
        int size = startPage + endPage;
        for (int i = startPage; i < size; i++) {
            int idx = i + 1;
            if (pageIndex == idx) {
                appendActiveTag(sb, idx);
            } else {
                sb.append(startPageTag);
                if(submit){
                    appendSubmitAnchor(sb, rowProperty, row, indexProperty, (i * row), String.valueOf(idx));
                } else {
                    appendLinkAnchor(sb, rowProperty, row, indexProperty, (i * row), String.valueOf(idx));
                }
                sb.append(endPageTag);
            }
        }
    }

    /**
     * ݃y[WɃANeBu^Oǉ.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param idx
     *            y[Wԍ
     */
    protected void appendActiveTag(StringBuilder sb, int idx){
        appendIfNotEmpty(sb, startActiveTag, startPageTag);
        sb.append(idx);
        appendIfNotEmpty(sb, endActiveTag, endPageTag);
    }

    /**
     * ŏIy[W̕\JnCfbNXvZĕԋp.
     * 
     * @param row
     *            \s
     * @param totalCount
     *            ꗗ̑S
     * @return ZoCfbNX
     */
    protected int getEndPageStartIndex(int row, int totalCount) {

        // ŏIy[Wԍiy[Wj擾
        int endPage = getPageCount(row, totalCount);

        // ŏIy[WԍŏIy[W̕\JnCfbNXZo
        int endPageStartIndex = endPage * row - row;

        return endPageStartIndex;
    }

    /**
     * <code>ApplicationResources</code> t@CŐݒ肵
     * ^O̖ߍ݂s.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param value
     *            D^O
     * @param defaultValue
     *            փ^O
     */
    static void appendIfNotEmpty(StringBuilder sb, String value, String defaultValue){
        if(value != null && !("".equals(value))){
            sb.append(value);
        } else if(defaultValue != null){
            sb.append(defaultValue);
        }
    }

    /**
     * <code>ApplicationResources</code> t@CŐݒ肵
     * ^O̖ߍ݂s.
     * 
     * @param sb
     *            ǉΏۂStringBuilder
     * @param value1
     *            D^O1
     * @param value2
     *            D^O2
     * @param defaultValue
     *            փ^O
     */
    static void appendIfNotEmpty(StringBuilder sb, String value1, String value2, String defaultValue){
        if(value1 != null && !("".equals(value1))){
            sb.append(value1);
        } else {
            appendIfNotEmpty(sb, value2, defaultValue);
        }
    }

    /**
     * vpeBt@Cɒ`Ăy[WWvpN`擾B
     * 擾NXϐɊi[B
     */
    private void getLinkProperty() {
        // vpeBt@Cɒ`Ă郊N\o^
        Enumeration<String> enume
            = PropertyUtil.getPropertyNames(PAGE_LINKS_PREFIX);
        while (enume.hasMoreElements()) {
            String propName = (String) enume.nextElement();
            String id = propName.substring(PAGE_LINKS_PREFIX.length());
            String link = PropertyUtil.getProperty(propName);

            // őy[WWvݒ
            if ((id != null)
                    && (id.startsWith(PREV_LINKS)
                    || id.startsWith(NEXT_LINKS))) {
                String strLinkNo = id.substring(4, id.lastIndexOf(CHAR_LINKS));
                int intLinkNo = 0;
                try {
                    intLinkNo = Integer.parseInt(strLinkNo);
                } catch (NumberFormatException e) {
                    // Ȃ
                    continue;
                }
                if (intLinkNo > maxLinkNo) {
                    maxLinkNo = intLinkNo;
                }
                links.put(id, link);
            } else if((id != null)
                           && id.startsWith(FIRST_LINKS)
                           || id.startsWith(LAST_LINKS)){
                links.put(id, link);
            } else if (MAX_DSP_SIZE.equals(id)) {
                links.put(id, link);
            }
        }
    }

    /**
     * ^O擾ANXϐɊi[.
     * 񂪂Ȃꍇ̓ftHglݒ肷.
     */
    private void initTagProperty() {
        //^O̎擾
        startPageLinksTag = PropertyUtil.getProperty(START_PAGELINKS_TAG, "");
        endPageLinksTag =   PropertyUtil.getProperty(END_PAGELINKS_TAG, "");
        startPageTag =      PropertyUtil.getProperty(START_PAGE_TAG, "");
        endPageTag =        PropertyUtil.getProperty(END_PAGE_TAG, "");
        startPrevTag =      PropertyUtil.getProperty(START_PREV_TAG, "");
        endPrevTag =        PropertyUtil.getProperty(END_PREV_TAG, "");
        startNextTag =      PropertyUtil.getProperty(START_NEXT_TAG, "");
        endNextTag =        PropertyUtil.getProperty(END_NEXT_TAG, "");
        startFirstTag =     PropertyUtil.getProperty(START_FIRST_TAG, "");
        endFirstTag =       PropertyUtil.getProperty(END_FIRST_TAG, "");
        startLastTag =      PropertyUtil.getProperty(START_LAST_TAG, "");
        endLastTag =        PropertyUtil.getProperty(END_LAST_TAG, "");
        startActiveTag =    PropertyUtil.getProperty(START_ACTIVE_TAG, "");
        endActiveTag =      PropertyUtil.getProperty(END_ACTIVE_TAG, "");
        startDisableTag =   PropertyUtil.getProperty(START_DISABLE_TAG, "");
        endDisableTag =     PropertyUtil.getProperty(END_DISABLE_TAG, "");
        startJumpFormTag =  PropertyUtil.getProperty(START_JUMPFORM_TAG, "");
        endJumpFormTag =    PropertyUtil.getProperty(END_JUMPFORM_TAG, "");

        //y[WWvtH[gp̊evpeBݒ
        jumpFormTextAttributes =     PropertyUtil.getProperty(JUMPFORM_TEXT_ATTRIBUTES, "");
        jumpFormSubmitAttributes =  PropertyUtil.getProperty(JUMPFORM_SUBMIT_ATTRIBUTES, "");
        jumpFormSubmitValue =    PropertyUtil.getProperty(JUMPFORM_SUBMIT_VALUE, JUMPFORM_SUBMIT_DEFAULT);

    }

    /**
     * ׂẴAP[gꂽ.
     */
    @Override
    public void release() {
        super.release();
        startPageLinksTag = null;
        endPageLinksTag = null;
        startPageTag = null;
        endPageTag = null;
        startPrevTag = null;
        endPrevTag = null;
        startNextTag = null;
        endNextTag = null;
        startFirstTag = null;
        endFirstTag = null;
        startLastTag = null;
        endLastTag = null;
        startActiveTag = null;
        endActiveTag = null;
        startDisableTag = null;
        endDisableTag = null;
        startJumpFormTag = null;
        endJumpFormTag = null;
        jumpFormTextAttributes = null;
        jumpFormSubmitAttributes = null;
        jumpFormSubmitValue = JUMPFORM_SUBMIT_DEFAULT;
        url = null;
        pageJump = false;
    }
}
