/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.codelist;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.CodeListLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMultilingualCodeListLoader
implements CodeListLoader {
    private Log log = LogFactory.getLog(AbstractMultilingualCodeListLoader.class);
    protected Map<Locale, List<CodeBean>> localeMap = null;
    protected Locale defaultLocale = new Locale(Locale.getDefault().getLanguage());

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public CodeBean[] getCodeBeans() {
        return this.createCodeBeans(this.defaultLocale);
    }

    public CodeBean[] getCodeBeans(Locale locale) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getCodeBeans(" + locale + ") called."));
        }
        CodeBean[] result = this.createCodeBeans(locale);
        if (locale != null && result.length == 0) {
            result = this.createCodeBeans(this.defaultLocale);
        }
        return result;
    }

    protected CodeBean[] createCodeBeans(Locale locale) {
        List<CodeBean> codeLists;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("createCodeBeans(" + locale + ") called."));
        }
        if (this.localeMap == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"field codeListsMap is null.");
            }
            return new CodeBean[0];
        }
        if (locale == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("arg locale is null. replace locale default : " + this.defaultLocale));
            }
            if (this.defaultLocale == null) {
                throw new IllegalStateException("Default locale is null.");
            }
            locale = this.defaultLocale;
        }
        if ((codeLists = this.localeMap.get(locale)) == null) {
            if (locale.getVariant().length() > 0) {
                return this.createCodeBeans(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (locale.getCountry().length() > 0) {
                return this.createCodeBeans(new Locale(locale.getLanguage()));
            }
            return new CodeBean[0];
        }
        CodeBean[] cb = new CodeBean[codeLists.size()];
        for (int i = 0; i < codeLists.size(); ++i) {
            cb[i] = new CodeBean();
            cb[i].setId(codeLists.get(i).getId());
            cb[i].setName(codeLists.get(i).getName());
        }
        return cb;
    }

    protected Locale createLocale(String language, String country, String variant) {
        if (language == null || language.length() == 0) {
            return this.defaultLocale;
        }
        if (country == null || country.length() == 0) {
            return new Locale(language);
        }
        if (variant == null || variant.length() == 0) {
            return new Locale(language, country);
        }
        return new Locale(language, country, variant);
    }
}

