/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.web.struts.action;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.web.RequestUtil;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

public abstract class AbstractExceptionHandler
extends ExceptionHandler {
    public ActionForward execute(Exception ex, ExceptionConfig ae, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ActionForward forward = this.getActionForward(ex, ae, mapping, request);
        this.setModule(forward, ex, ae, mapping);
        String bundleKey = this.getBundleKey(ae);
        MessageResources resources = this.getMessageResources(request, bundleKey);
        ActionMessages errors = this.getErrors(ex, ae, resources);
        this.storeException(request, errors, forward, ae.getScope());
        this.logException(ex);
        this.setRequestAttribute(request, ex, ae, mapping);
        return forward;
    }

    protected ActionForward getActionForward(Exception ex, ExceptionConfig ae, ActionMapping mapping, HttpServletRequest request) {
        ActionForward forward = null;
        forward = ae.getPath() != null ? new ActionForward(ae.getPath()) : mapping.getInputForward();
        return forward;
    }

    protected String getBundleKey(ExceptionConfig ae) {
        if (ae.getBundle() != null) {
            return ae.getBundle();
        }
        return "org.apache.struts.action.MESSAGE";
    }

    protected MessageResources getMessageResources(HttpServletRequest request, String bundleKey) {
        MessageResources messageResources = (MessageResources)request.getAttribute(bundleKey);
        if (messageResources != null) {
            return messageResources;
        }
        return (MessageResources)RequestUtil.getServletContext((HttpServletRequest)request).getAttribute(bundleKey);
    }

    protected void storeException(HttpServletRequest request, ActionMessages errors, ActionForward forward, String scope) {
        if ("request".equals(scope)) {
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        } else {
            request.getSession().setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        }
    }

    protected void setRequestAttribute(HttpServletRequest request, Exception ex, ExceptionConfig ae, ActionMapping mapping) {
        request.setAttribute("org.apache.struts.action.EXCEPTION", (Object)ex);
        request.setAttribute("javax.servlet.jsp.jspException", (Object)ex);
    }

    protected abstract ActionMessages getErrors(Exception var1, ExceptionConfig var2, MessageResources var3);

    protected abstract void setModule(ActionForward var1, Exception var2, ExceptionConfig var3, ActionMapping var4);
}

