/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.terasoluna.fw.util.GenericsUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericPropertyUtil {
    private static final Log log = LogFactory.getLog(GenericPropertyUtil.class);

    public static Class resolveCollectionType(Object bean, String name) throws IllegalArgumentException, IllegalStateException {
        return GenericPropertyUtil.resolveType(bean, name, Collection.class, 0);
    }

    public static Class resolveType(Object bean, String name, Class genericClass, int index) throws IllegalArgumentException, IllegalStateException {
        if (bean == null) {
            throw new IllegalArgumentException("Argument 'bean' (" + Object.class.getName() + " is null");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Argument 'name' (" + String.class.getName() + " is empty");
        }
        Method method = GenericPropertyUtil.getMethod(bean, name);
        return GenericPropertyUtil.resolveType(genericClass, method.getReturnType(), method.getGenericReturnType(), index);
    }

    protected static Method getMethod(Object bean, String name) throws IllegalArgumentException {
        PropertyDescriptor descriptor = null;
        try {
            descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)name);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to detect getter for " + bean.getClass().getName() + "#" + name, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to detect getter for " + bean.getClass().getName() + "#" + name, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to detect getter for " + bean.getClass().getName() + "#" + name, e);
        }
        Method method = null;
        if (descriptor != null) {
            method = descriptor.getReadMethod();
        }
        if (method == null) {
            throw new IllegalArgumentException(bean.getClass().getName() + " has no getter for property " + name);
        }
        return method;
    }

    protected static Class resolveType(Class genericClass, Class clazz, Type type, int index) throws IllegalArgumentException, IllegalStateException {
        Class resolved;
        block11: {
            List<ParameterizedType> ancestorTypeList;
            block10: {
                if (genericClass == null) {
                    throw new IllegalArgumentException("Argument 'genericsClass' (" + Class.class.getName() + ") is null");
                }
                if (clazz == null || !genericClass.isAssignableFrom(clazz)) {
                    throw new IllegalStateException(genericClass + " is not assignable from " + clazz);
                }
                ancestorTypeList = null;
                try {
                    ancestorTypeList = GenericsUtil.getAncestorTypeList(genericClass, clazz);
                }
                catch (IllegalStateException e) {
                    if (!log.isTraceEnabled()) break block10;
                    log.trace((Object)e.getMessage());
                }
            }
            if (ancestorTypeList == null) {
                ancestorTypeList = new ArrayList<ParameterizedType>();
            }
            if (type instanceof ParameterizedType) {
                ancestorTypeList.add(0, (ParameterizedType)type);
            }
            if (ancestorTypeList.size() <= 0) {
                throw new IllegalStateException("No parameterizedType was detected.");
            }
            ParameterizedType parameterizedType = ancestorTypeList.get(ancestorTypeList.size() - 1);
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            if (index < 0 || index >= actualTypes.length) {
                throw new IllegalArgumentException("Argument 'index'(" + Integer.toString(index) + ") is out of bounds of" + " generics parameters");
            }
            resolved = Object.class;
            try {
                resolved = GenericsUtil.resolveTypeVariable(actualTypes[index], ancestorTypeList);
            }
            catch (IllegalStateException e) {
                if (!log.isTraceEnabled()) break block11;
                log.trace((Object)e.getMessage());
            }
        }
        return resolved;
    }
}

