/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.castor.jdo.engine.SQLTypeConverters;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.mapping.BindingType;
import org.castor.util.Messages;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptorImpl;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorRegistry;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.AbstractMappingLoader;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldHandlerFriend;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.NamedQuery;
import org.exolab.castor.mapping.xml.Param;
import org.exolab.castor.mapping.xml.types.SqlDirtyType;

public final class JDOMappingLoader
extends AbstractMappingLoader {
    private static final char LEFT_PARAM_SEPARATOR = '[';
    private static final char RIGHT_PARAM_SEPARATOR = ']';
    private Hashtable _keyGenDefs = new Hashtable();
    private Hashtable _keyGenDescs = new Hashtable();
    private Hashtable _namedQueries = new Hashtable();
    private BaseFactory _factory;
    private KeyGeneratorRegistry _keyGenReg = new KeyGeneratorRegistry();
    static /* synthetic */ Class class$org$exolab$castor$mapping$FieldHandler;

    public static String definition2param(String sqlTypeDef) {
        int left = sqlTypeDef.indexOf(91);
        int right = sqlTypeDef.indexOf(93);
        if (right < 0) {
            right = sqlTypeDef.length();
        }
        if (left < 0) {
            return null;
        }
        return sqlTypeDef.substring(left + 1, right);
    }

    public static String definition2type(String sqlTypeDef) {
        int sep = sqlTypeDef.indexOf(91);
        if (sep < 0) {
            return sqlTypeDef;
        }
        return sqlTypeDef.substring(0, sep);
    }

    public JDOMappingLoader(ClassLoader loader) {
        super(loader);
    }

    public BindingType getBindingType() {
        return BindingType.JDO;
    }

    protected ClassDescriptor createDescriptor(ClassMapping clsMap) throws MappingException {
        if (clsMap.getMapTo() == null || clsMap.getMapTo().getTable() == null) {
            return AbstractMappingLoader.NO_DESCRIPTOR;
        }
        ClassDescriptor clsDesc = null;
        if (clsDesc != null && clsDesc instanceof JDOClassDescriptor) {
            return clsDesc;
        }
        clsDesc = super.createDescriptor(clsMap);
        if (clsDesc.getIdentity() == null) {
            throw new MappingException("mapping.noIdentity", clsDesc.getJavaClass().getName());
        }
        String keyGenName = clsMap.getKeyGenerator();
        KeyGeneratorDescriptor keyGenDesc = null;
        if (keyGenName != null) {
            KeyGeneratorDef keyGenDef = (KeyGeneratorDef)this._keyGenDefs.get(keyGenName);
            Properties params = new Properties();
            String keyGenFactoryName = keyGenName;
            if (keyGenDef != null) {
                keyGenFactoryName = keyGenDef.getName();
                Enumeration enumeration = keyGenDef.enumerateParam();
                while (enumeration.hasMoreElements()) {
                    Param par = (Param)enumeration.nextElement();
                    params.put(par.getName(), par.getValue());
                }
            }
            if ((keyGenDesc = (KeyGeneratorDescriptor)this._keyGenDescs.get(keyGenName)) == null) {
                keyGenDesc = new KeyGeneratorDescriptor(keyGenName, keyGenFactoryName, params, this._keyGenReg);
                this._keyGenDescs.put(keyGenName, keyGenDesc);
            }
        }
        JDOClassDescriptor classDescriptor = new JDOClassDescriptor(clsDesc, keyGenDesc);
        Enumeration namedQueriesEnum = clsMap.enumerateNamedQuery();
        while (namedQueriesEnum.hasMoreElements()) {
            NamedQuery namedQuery = (NamedQuery)namedQueriesEnum.nextElement();
            try {
                if (this._namedQueries.contains(namedQuery.getName())) {
                    throw new MappingException("Duplicate entry for named query with name " + namedQuery.getName());
                }
                classDescriptor.addNamedQuery(namedQuery.getName(), namedQuery.getQuery());
                this._namedQueries.put(namedQuery.getName(), namedQuery);
            }
            catch (QueryException e) {
                throw new MappingException(e);
            }
        }
        return classDescriptor;
    }

    protected String[] getSqlTypes(FieldMapping fieldMap) {
        int current;
        if (fieldMap.getSql() == null) {
            return new String[0];
        }
        String sqlType = fieldMap.getSql().getType();
        if (sqlType == null) {
            return new String[0];
        }
        ArrayList<String> types = new ArrayList<String>();
        int begin = 0;
        int state = 0;
        block4: for (current = 0; current < sqlType.length(); ++current) {
            switch (state) {
                case 0: {
                    if (sqlType.charAt(current) == ' ') {
                        types.add(sqlType.substring(begin, current));
                        begin = current + 1;
                        continue block4;
                    }
                    if (sqlType.charAt(current) != '[') continue block4;
                    state = 1;
                    continue block4;
                }
                case 1: {
                    if (sqlType.charAt(current) != ']') continue block4;
                    state = 0;
                }
            }
        }
        types.add(sqlType.substring(begin, current));
        String[] result = new String[types.size()];
        return types.toArray(result);
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        TypeConvertor convertorTo = null;
        TypeConvertor convertorFrom = null;
        String convertorParam = null;
        String typeName = null;
        Class sqlType = null;
        fieldType = Types.typeFromPrimitive(fieldType);
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (fieldMap.getSql() != null && sqlTypes.length > 0) {
            typeName = sqlTypes[0];
            sqlType = SQLTypeInfos.sqlTypeName2javaType(JDOMappingLoader.definition2type(typeName));
        } else {
            sqlType = fieldType;
        }
        if (this._factory != null) {
            sqlType = this._factory.adjustSqlType(sqlType);
        }
        if (fieldType != sqlType) {
            block14: {
                try {
                    convertorTo = SQLTypeConverters.getConvertor(sqlType, fieldType);
                }
                catch (MappingException ex) {
                    boolean isTypeSafeEnum = false;
                    if (fieldType != null && !JDOMappingLoader.isPrimitive(fieldType)) {
                        Constructor cons = null;
                        try {
                            cons = fieldType.getConstructor(EMPTY_ARGS);
                            if (!Modifier.isPublic(cons.getModifiers())) {
                                cons = null;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                        try {
                            int mods;
                            Method method;
                            Class<?> returnType;
                            if (cons == null && (returnType = (method = fieldType.getMethod("valueOf", STRING_ARG)).getReturnType()) != null && fieldType.isAssignableFrom(returnType) && Modifier.isStatic(mods = method.getModifiers())) {
                                convertorTo = new SQLTypeConverters.Convertor(sqlType, fieldType){
                                    private Method method = null;

                                    public Object convert(Object obj, String param) {
                                        try {
                                            if (this.method == null) {
                                                this.method = this.toType().getMethod("valueOf", STRING_ARG);
                                            }
                                            return this.method.invoke((Object)this.toType(), (String)obj);
                                        }
                                        catch (Exception ex) {
                                            return null;
                                        }
                                    }
                                };
                                Types.addEnumType(fieldType);
                                isTypeSafeEnum = true;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                    }
                    if (isTypeSafeEnum) break block14;
                    throw new MappingException("mapping.noConvertor", sqlType.getName(), fieldType.getName());
                }
            }
            convertorFrom = SQLTypeConverters.getConvertor(fieldType, sqlType);
            if (typeName != null) {
                convertorParam = JDOMappingLoader.definition2param(typeName);
            }
        }
        return new TypeInfo(fieldType, convertorTo, convertorFrom, convertorParam, fieldMap.getRequired(), null, colHandler);
    }

    protected FieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        int[] sqlTypeNum;
        if (fieldMap.getSql() == null) {
            return super.createFieldDesc(javaClass, fieldMap);
        }
        String fieldName = fieldMap.getName();
        Class fieldType = null;
        if (fieldMap.getType() != null) {
            try {
                fieldType = this.resolveType(fieldMap.getType());
            }
            catch (ClassNotFoundException except) {
                throw new MappingException("mapping.classNotFound", fieldMap.getType());
            }
        }
        CollectionHandler colHandler = null;
        if (fieldMap.getCollection() != null) {
            Class colType = CollectionHandlers.getCollectionType(fieldMap.getCollection().toString());
            colHandler = CollectionHandlers.getHandler(colType);
            if (colType.getName().equals("java.util.Iterator") && fieldMap.getLazy()) {
                String err = "Lazy loading not supported for collection type 'iterator'";
                throw new MappingException(err);
            }
            if (colType.getName().equals("java.util.Enumeration") && fieldMap.getLazy()) {
                String err = "Lazy loading not supported for collection type 'enumerate'";
                throw new MappingException(err);
            }
        }
        TypeInfo typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
        ExtendedFieldHandler exfHandler = null;
        FieldHandler handler = null;
        if (fieldMap.getHandler() != null) {
            Class handlerClass = null;
            try {
                handlerClass = this.resolveType(fieldMap.getHandler());
            }
            catch (ClassNotFoundException except) {
                throw new MappingException("mapping.classNotFound", fieldMap.getHandler());
            }
            if (!(class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = JDOMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).isAssignableFrom(handlerClass)) {
                String err = "The class '" + fieldMap.getHandler() + "' must implement " + (class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = JDOMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).getName();
                throw new MappingException(err);
            }
            Constructor constructor = null;
            try {
                constructor = handlerClass.getConstructor(new Class[0]);
                handler = (FieldHandler)constructor.newInstance(new Object[0]);
            }
            catch (Exception except) {
                String err = "The class '" + handlerClass.getName() + "' must have a default public constructor.";
                throw new MappingException(err);
            }
            if (handler instanceof ExtendedFieldHandler) {
                exfHandler = (ExtendedFieldHandler)handler;
            }
            colHandler = typeInfo.getCollectionHandler();
            typeInfo.setCollectionHandler(null);
            handler = new FieldHandlerImpl(handler, typeInfo);
            typeInfo.setCollectionHandler(colHandler);
        }
        boolean generalized = exfHandler instanceof GeneralizedFieldHandler;
        FieldHandler custom = handler;
        if (generalized) {
            fieldType = ((GeneralizedFieldHandler)exfHandler).getFieldType();
        }
        if (generalized || handler == null) {
            AbstractMappingLoader.TypeInfoReference typeInfoRef = new AbstractMappingLoader.TypeInfoReference(this);
            typeInfoRef.typeInfo = typeInfo;
            handler = this.createFieldHandler(javaClass, fieldType, fieldMap, typeInfoRef);
            if (custom != null) {
                ((GeneralizedFieldHandler)exfHandler).setFieldHandler(handler);
                handler = custom;
            } else {
                typeInfo = typeInfoRef.typeInfo;
            }
        }
        String[] sqlName = fieldMap.getSql().getName();
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (sqlTypes.length > 0) {
            sqlTypeNum = new int[sqlTypes.length];
            for (int i = 0; i < sqlTypes.length; ++i) {
                String sqlTypeString = JDOMappingLoader.definition2type(sqlTypes[i]);
                Class sqlType = SQLTypeInfos.sqlTypeName2javaType(sqlTypeString);
                if (this._factory != null) {
                    sqlType = this._factory.adjustSqlType(sqlType);
                }
                sqlTypeNum[i] = SQLTypeInfos.javaType2sqlTypeNum(sqlType);
            }
        } else {
            Class sqlType = typeInfo.getFieldType();
            if (this._factory != null) {
                sqlType = this._factory.adjustSqlType(sqlType);
            }
            sqlTypeNum = new int[]{SQLTypeInfos.javaType2sqlTypeNum(sqlType)};
        }
        JDOFieldDescriptorImpl jdoFieldDescriptor = new JDOFieldDescriptorImpl(fieldName, typeInfo, handler, fieldMap.getTransient(), sqlName, sqlTypeNum, fieldMap.getSql().getManyTable(), fieldMap.getSql().getManyKey(), !SqlDirtyType.IGNORE.equals(fieldMap.getSql().getDirty()), fieldMap.getSql().getReadOnly());
        jdoFieldDescriptor.setRequired(fieldMap.getRequired());
        if (exfHandler != null) {
            ((FieldHandlerFriend)exfHandler).setFieldDescriptor(jdoFieldDescriptor);
        }
        if (fieldMap.getSql().getTransient()) {
            jdoFieldDescriptor.setTransient(true);
        }
        return jdoFieldDescriptor;
    }

    protected void loadMappingInternal(MappingRoot mapping, Object param) throws MappingException {
        this._factory = (BaseFactory)param;
        Enumeration enumeration = mapping.enumerateKeyGeneratorDef();
        while (enumeration.hasMoreElements()) {
            KeyGeneratorDef keyGenDef = (KeyGeneratorDef)enumeration.nextElement();
            String name = keyGenDef.getAlias();
            if (name == null) {
                name = keyGenDef.getName();
            }
            if (this._keyGenDefs.get(name) != null) {
                throw new MappingException(Messages.format("mapping.dupKeyGen", name));
            }
            this._keyGenDefs.put(name, keyGenDef);
        }
        super.loadMappingInternal(mapping, null);
        this._keyGenDefs = null;
        this._keyGenDescs = null;
        this._keyGenReg = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

