/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor;

import java.util.Locale;
import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor.CastorView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public class CastorViewResolver
extends UrlBasedViewResolver
implements Ordered,
InitializingBean {
    private static Log log = LogFactory.getLog(CastorViewResolver.class);
    private int order = Integer.MAX_VALUE;
    private OXMapper oxmapper = null;

    public CastorViewResolver() {
        this.setViewClass(CastorView.class);
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public OXMapper getOxmapper() {
        return this.oxmapper;
    }

    public void setOxmapper(OXMapper oxmapper) {
        this.oxmapper = oxmapper;
    }

    public void afterPropertiesSet() {
        if (this.oxmapper == null) {
            log.error((Object)"OXMapper class isn't set in CastorViewResolver. Check Spring Bean definition file.");
            throw new IllegalStateException("OXMapper class isn't set in CastorViewResolver. Check Spring Bean definition file.");
        }
    }

    protected Class requiredViewClass() {
        return CastorView.class;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        CastorView view = (CastorView)this.buildView(viewName);
        if (view == null) {
            return null;
        }
        view.setOxmapper(this.oxmapper);
        view.setApplicationContext(this.getApplicationContext());
        view.afterPropertiesSet();
        return view;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        if (StringUtils.hasText((String)viewName)) {
            return null;
        }
        return super.buildView(viewName);
    }
}

