/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionResolveDelegatorImpl
implements ExceptionResolveDelegator {
    private static Log log = LogFactory.getLog(ExceptionResolveDelegatorImpl.class);
    protected static final String EXCEPTION_KEY = "exception";
    protected static final String ERROR_TYPE_HEADER_NAME_KEY = "errorTypeHeaderName";
    protected String mappingKey = null;
    protected Object mappingValues = null;
    protected String viewName = null;
    protected String errorType = null;
    protected String errorCode = null;
    protected String errorTypeHeaderName = "exception";

    @Override
    public void initMapping(String mappingKey, Object mappingValues, Map<String, String> params) {
        String[] mappingValueArray;
        String errorTypeName;
        if (mappingValues == null) {
            String message = "linkedExceptionMappings[" + mappingKey + "] value is null. " + "Check Spring Bean definition file.";
            log.error((Object)message);
            throw new IllegalStateException(message);
        }
        if (!(mappingValues instanceof String)) {
            String message = "linkedExceptionMappings[" + mappingKey + "] value is not String type. " + "Check Spring Bean definition file.";
            log.error((Object)message);
            throw new IllegalStateException(message);
        }
        if (params != null && (errorTypeName = params.get(ERROR_TYPE_HEADER_NAME_KEY)) != null && errorTypeName.length() != 0) {
            this.errorTypeHeaderName = errorTypeName;
        }
        if ((mappingValueArray = StringUtils.commaDelimitedListToStringArray((String)((String)mappingValues))).length < 2) {
            String message = "linkedExceptionMappings[" + mappingKey + "] value is insufficient. Two values are necessary. " + "Check Spring Bean definition file.";
            log.error((Object)message);
            throw new IllegalStateException(message);
        }
        for (int i = 0; i < mappingValueArray.length; ++i) {
            mappingValueArray[i] = mappingValueArray[i].trim();
            if (!"".equals(mappingValueArray[i])) continue;
            String message = "linkedExceptionMappings[" + mappingKey + "] value[" + i + "] is empty. " + "Check Spring Bean definition file.";
            log.error((Object)message);
            throw new IllegalStateException(message);
        }
        this.mappingKey = mappingKey;
        this.mappingValues = mappingValues;
        this.viewName = mappingValueArray[0];
        this.errorType = mappingValueArray[1];
        if (mappingValueArray.length > 2) {
            this.errorCode = mappingValueArray[2];
        }
    }

    @Override
    public void setHeader(HttpServletResponse response) {
        response.setHeader(this.errorTypeHeaderName, this.errorType);
    }

    @Override
    public void addObjectToModel(ModelAndView mv) {
        if (this.errorCode != null) {
            mv.addObject("errorCode", (Object)this.errorCode);
        }
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }
}

