package jp.terasoluna.fw.ex.unit.util;

import java.util.Map;
import java.util.TreeMap;

import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;

/**
 * VXeϐ̃eXgp[eBeB
 * 
 * <p>
 * VXeϐ(<code>System.getEnv("xxx")</code>Ŏ擾łl)vOŕύXE폜ł܂B <br>
 * ̃[eBeBJUnitŎgpꍇAK㏈<code>{@link SystemEnvUtils#restoreEnv()}</code> sāAύXȌԂɖ߂ƁB
 * </p>
 * @since 2.1.0
 */
public class SystemEnvUtils {
    /**
     * VXeϐێNXB
     */
    protected static final Class<?> processEnvironmentClass;
    /**
     * VXeϐ}bvB
     */
    protected static final Map<String, String> env;
    /**
     * ۑVXeϐ}bvB
     */
    protected static final Map<String, String> savedMap = new TreeMap<String, String>();

    static {
        try {
            processEnvironmentClass = Class
                    .forName("java.lang.ProcessEnvironment");
        } catch (ClassNotFoundException e) {
            throw new UTRuntimeException(e);
        }
        env = ReflectionUtils.getField(processEnvironmentClass,
                "theCaseInsensitiveEnvironment");
        savedMap.putAll(env);
    }

    /**
     * VXeϐݒ肵܂B
     * 
     * @param key ϐ
     * @param value ϐl
     */
    public static synchronized void setEnv(String key, String value) {
        env.put(key, value);
    }

    /**
     * VXeϐ폜܂B
     * 
     * @param key ϐ
     */
    public static synchronized void removeEnv(String key) {
        env.remove(key);
    }

    /**
     * VXeϐύXOɖ߂܂B
     */
    public static synchronized void restoreEnv() {
        env.clear();
        env.putAll(savedMap);
    }
}
