/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.util.Map;
import junit.framework.AssertionFailedError;
import servletunit.struts.MockStrutsTestCase;

/**
 *  validation.xml eXgpɊgTestCaseNXB
 * <BR><BR>
 * <PRE>
 * [gp]
 * public class LogonBLogicValidationTest extends ValidationTestCase {
 *
 *  // ftHg̃NGXgp[^
 *  // (͒l`FbNG[ɂȂȂT^IȐlw肷)
 *  static final String[][] defaultParams = {
 *      // p[^, p[^l
 *      {"userCode", "X"},
 *      {"userPassword", "X"},
 *  };
 *
 *  //eXgP[Xʂ̏
 *  protected void setUp() throws Exception {
 *      super.setUp();
 *
 *      // eXgpActionServletNX̐ݒ
 *      setActionServlet(new UTActionServlet());
 *
 *      // WebAvP[Ṽ[gfBNgw
 *      setContextDirectory(new File("webapps"));
 *
 *      // eXgΏۂ̃ANVpX܂struts-configt@Cw
 *      setConfigFile("logon", "/WEB-INF/struts-logon-config.xml");
 *
 *      // eXgΏۂ̃ANVpXw
 *      setRequestPathInfo("/logon", "/logonBLogic.do");
 *  }
 *
 *  // nP[X
 *  public void testNormal() {
 *      // ̓f[^ݒ
 *      setRequestParams(defaultParams);
 *
 *      // eXgs
 *      actionPerform();
 *
 *      // eXgʊmF
 *      verifyNoActionErrors();  // ͒l`FbNG[B
 *  }
 *
 *  // ͒l`FbNG[P[X
 *  public void testUserCode01() {
 *      // ̓f[^ݒ
 *      setRequestParams(defaultParams, "userCode", "");
 *
 *      // eXgs
 *      actionPerform();
 *
 *      // eXgʊmF
 *      verifyActionErrors(errorsRequired);  // errors.requiredG[
 *  }
 *}
 * </PRE>
 * 
 */
public class ValidationTestCase extends MockStrutsTestCase {

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsRequired =   { "errors.required" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsMinlength =  { "errors.minlength" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsMaxlength =  { "errors.maxlength" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsInvalid =    { "errors.invalid" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsByte =       { "errors.byte" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsShort =      { "errors.short" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsInteger =    { "errors.integer" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsLong =       { "errors.long" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsFloat =      { "errors.float" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsDouble =     { "errors.double" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsDate =       { "errors.date" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsRange =      { "errors.range" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsCreditcard = { "errors.creditcard" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsEmail =      { "errors.email" };
    


    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsAlphaNumericString = 
                                        { "errors.alphaNumericString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsHankakuKanaString = 
                                        { "errors.hankakuKanaString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsHankakuString = 
                                        { "errors.hankakuString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsZenkakuString = 
                                        { "errors.zenkakuString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsZenkakuKanaString = 
                                        { "errors.zenkakuKanaString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsCapAlphaNumericString = 
                                        { "errors.capAlphaNumericString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsNumericString = 
                                        { "errors.numericString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsNumber = 
                                        { "errors.number" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsProhibited = 
                                        { "errors.prohibited" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsLengthString = 
                                        { "errors.lengthString" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsAlphaNumericStringArray = 
                                        { "errors.alphaNumericStringArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsHankakuKanaStringArray = 
                                        { "errors.hankakuKanaStringArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsHankakuStringArray = 
                                        { "errors.hankakuStringArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsZenkakuStringArray = 
                                        { "errors.zenkakuStringArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsZenkakuKanaStringArray = 
                                        { "errors.zenkakuKanaStringArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsCapAlphaNumericStringArray = 
                                        { "errors.capAlphaNumericStringArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsNumberArray = 
                                        { "errors.numberArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsNumericStringArray = 
                                        { "errors.numericStringArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsProhibitedArray = 
                                        { "errors.prohibitedArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsLengthStringArray = 
                                        { "errors.lengthStringArray" };


    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsRequiredArray = 
                                        { "errors.requiredArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsRequiredifArray = 
                                        { "errors.requiredifArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsMinLengthArray = 
                                        { "errors.minlengthArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsMaxLengthArray = 
                                        { "errors.maxlengthArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsMaskArray = 
                                        { "errors.maskArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsByteArray = 
                                        { "errors.byteArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsShortArray = 
                                        { "errors.shortArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsIntegerArray = 
                                        { "errors.integerArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsLongArray = 
                                        { "errors.longArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsDoubleArray = 
                                        { "errors.doubleArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsDateArray = 
                                        { "errors.dateArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsIntRangeArray = 
                                        { "errors.intRangeArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsFloatRangeArray = 
                                        { "errors.floatRangeArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsCreditCardArray = 
                                        { "errors.creditCardArray" };

    /**
     * ActionError̃R[hBeXgʂ̌(verifyActionErrors)ɗpB
     */
    protected static String[] errorsEmailArray = 
                                        { "errors.emailArray" };

    
    /**
     * RXgN^B
     */
    public ValidationTestCase() {
        super();
    }

    /**
     * RXgN^B
     * 
     * @param testName 
     */
    public ValidationTestCase(String testName) {
        super(testName);
    }

    /**
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        // X[p[NX̓\bhĂяoB
        super.setUp();

        // request̒u
        request =
            new HttpServletRequestSimulatorEx(config.getServletContext());
    }

    /**
     * NGXgp[^̒ǉB
     * 
     * @param parameterName p[^
     * @param parameterValue p[^l
     */
    public void addRequestParameter(String parameterName,
                                     String parameterValue) {

        // eNX̓\bhĂяoB
        super.addRequestParameter(parameterName, parameterValue);
    }


    /**
     * NGXgp[^̒ǉB
     * 
     * @param parameterName p[^
     * @param parameterValue p[^l
     */
    public void addRequestParameter(String parameterName,
                                     Object parameterValue) {

        // Ăяõ`FbNieNXɂȂĎĂj
        if (!isInitialized) {
            throw new AssertionFailedError(
                "You are overriding the setUp() method without calling " +
                "super.setUp().  You must call the superclass setUp() " +
                "method in your TestCase subclass to ensure proper " +
                "initialization.");
        }
        
        // NGXgĩbNjɃp[^ǉ
        HttpServletRequestSimulatorEx requestEx = 
            (HttpServletRequestSimulatorEx) request;
        requestEx.addParameter(parameterName, parameterValue);
    }


    /**
     * NGXgp[^̐ݒB
     * 
     * @param defaultParams ftHg̃p[^l
     * @param name ftHg㏑p[^̖O
     * @param value ftHg㏑p[^̒l
     */
    protected void setRequestParams(String[][] defaultParams, String name, 
            String value) {

        for(int i = 0; i < defaultParams.length; i++) {
            String paramName = defaultParams[i][0];
            String paramValue = 
                defaultParams[i][0].equals(name) ? value
                                                 : defaultParams[i][1]; 
            addRequestParameter(paramName, paramValue);
        }
    }

    /**
     * NGXgp[^̐ݒB
     * 
     * @param defaultParams ftHg̃p[^l
     * @param name ftHg㏑p[^̖O
     * @param value ftHg㏑p[^̒l
     */
    protected void setRequestParams(Object[][] defaultParams, String name, 
            Object value) {

        for (int i=0; i < defaultParams.length; i++) {
            String paramName = (String) defaultParams[i][0];
            Object paramValue =
                defaultParams[i][0].equals(name) ? value
                                                 : defaultParams[i][1]; 
            addRequestParameter(paramName, paramValue);
        }
    }

    /**
     * NGXgp[^̐ݒB
     * 
     * @param defaultParams ftHg̃p[^l
     * @param paramsMap ftHg㏑p[^̖OƒlMap
     */
    protected void setRequestParams(Object[][] defaultParams, Map paramsMap) {

        for (int i=0; i < defaultParams.length; i++) {
            String paramName = (String) defaultParams[i][0];
            Object paramValue =
                (paramsMap.containsKey(paramName)) ? paramsMap.get(paramName)
                                                   : defaultParams[i][1];
            addRequestParameter(paramName, paramValue);
        }
    }

    /**
     * NGXgp[^̐ݒiׂăftHglŐݒjB
     * 
     * @param defaultParams ftHg̃p[^l
     */
    protected void setRequestParams(String[][] defaultParams) {
        setRequestParams(defaultParams, null, null);
    }

    /**
     * NGXgp[^̐ݒiׂăftHglŐݒjB
     * 
     * @param defaultParams ftHg̃p[^l
     */
    protected void setRequestParams(Object[][] defaultParams) {
        setRequestParams(defaultParams, null, null);
    }


}
