/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import jp.terasoluna.fw.web.struts.action.ActionMappingEx;

/**
 * ResolverActionMapping
 * <p>
 * ActionMappingEx̊gNXB
 * </p>
 * <p>
 * ȉ̐ݒstruts-configōsB
 * </p>
 * <li>saveToken</li><br>
 * <li>tokenCheck</li><br>
 * <li>saveMessageScope</li><br>
 * <li>event</li><br>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.action.resolver.ActionResolver
 * @see jp.terasoluna.fw.web.struts.action.resolver.BLogicActionResolver
 * @see jp.terasoluna.fw.web.struts.action.resolver.GeneralActionResolver
 * @see jp.terasoluna.fw.web.struts.action.resolver.ConfigurationReflector
 * @see jp.terasoluna.fw.web.struts.action.resolver.GeneralConfigurationReflector
 * @see jp.terasoluna.fw.web.struts.action.ActionMappingEx
 * @see jp.terasoluna.fw.web.struts.actions.ActionEx
 * @see jp.terasoluna.fw.web.struts.actions.ForwardAction
 * @see jp.terasoluna.fw.web.struts.actions.DispatchAction
 * @see jp.terasoluna.fw.web.struts.actions.LogoffAction
 * @see jp.terasoluna.fw.web.struts.actions.MakeSessionDirectoryAction
 */
public class ResolverActionMapping extends ActionMappingEx {
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 3477242525714643403L;

    /** bZ[W̃XR[vFNGXg */
    public static final String SCOPE_REQUEST = "request";

    /** bZ[W̃XR[vFZbV */
    public static final String SCOPE_SESSION = "session";

    /** gUNVg[N̕ۑ邩ǂ(ActionEx) */
    private boolean saveToken = true;

    /** gUNVg[N`FbNsǂ(ActionEx) */
    private boolean tokenCheck = false;

    /** bZ[WۑXR[v(AbstractBLogicAction) */
    private String saveMessageScope = SCOPE_REQUEST;

    /** Jڐ\vpeBB(DispatchAction) */
    private String event = null;

    /**
     * gUNVg[NۑtO(ActionEx)擾
     * @return the saveToken
     */
    public boolean isSaveToken() {
        return saveToken;
    }

    /**
     * gUNVg[NۑtO(ActionEx)ݒ肷
     * @param saveToken the saveToken to set
     */
    public void setSaveToken(boolean saveToken) {
        this.saveToken = saveToken;
    }

    /**
     * gUNVg[N`FbNtO(ActionEx)擾
     * @return the tokenCheck
     */
    public boolean isTokenCheck() {
        return tokenCheck;
    }

    /**
     * gUNVg[N`FbNtO(ActionEx)ݒ肷
     * @param tokenCheck the tokenCheck to set
     */
    public void setTokenCheck(boolean tokenCheck) {
        this.tokenCheck = tokenCheck;
    }

    /**
     * bZ[WۑXR[v(AbstractBLogicAction)擾
     * @return the saveMessageScope
     */
    public String getSaveMessageScope() {
        return saveMessageScope;
    }

    /**
     * bZ[WۑXR[v(AbstractBLogicAction)ݒ肷
     * @param saveMessageScope the saveMessageScope to set
     */
    public void setSaveMessageScope(String saveMessageScope) {
        this.saveMessageScope = saveMessageScope;
    }

    /**
     * Jڐ\vpeBB(DispatchAction)擾
     * @return the event
     */
    public String getEvent() {
        return event;
    }

    /**
     * Jڐ\vpeBB(DispatchAction)ݒ肷
     * @param event the event to set
     */
    public void setEvent(String event) {
        this.event = event;
    }
}
