/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.common.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import jp.terasoluna.fw.web.struts.actions.ActionEx;

/**
 * [o͋NۃNX<br>
 * PDF`̒[쐬o͂sȂB<br>
 * [pTemplateJasperReport𗘗pB<br>
 * ȉ̂S̃\bh邱ƂŒ[̐oB<br>
 * <li>getParameterMap(ActionForm, HttpServletRequest)<br>
 * &nbsp;&nbsp;- e[ɏo͂ύX\ȌŒ蕶擾B<br>
 * &nbsp;&nbsp;&nbsp; Œ蕶̂߁A擾oȂĂ[͐B</li>
 * <br><br>
 * <li>getReportData(ActionForm, HttpServletRequest)<br>
 * &nbsp;&nbsp;- [ŏo͂擾B<br>
 * &nbsp;&nbsp;&nbsp; [o͑Ώۂ̂߁A擾oȂꍇ͋̒[
 * </li>
 * <br><br>
 * <li>getTemplatePath(ActionForm, HttpServletRequest)<br>
 * &nbsp;&nbsp;- [pTemplatet@C̃pX擾B</li>
 * <br><br>
 * <li>getFileName(ActionForm, HttpServletRequest)<br>
 * &nbsp;&nbsp;- 钠[t@C̃t@C擾B</li>
 * <br><br>
 * EʏCP0005F[o͏
 * 
 * @see jp.terasoluna.fw.web.struts.actions.ActionEx
 * 
 * 
 * 
 * @param <T> [o͏IuWFNg
 */
public abstract class AbstractReportAction<T> extends ActionEx {
    
    /**
     * [o͂sȂB<br>
     * <br>
     * o͂钠[͈ȉ̌`ŏo͂B<br>
     * Et@C`FPDF`<br>
     * Et@CFgetFileNamě<br>
     * ̒[o͂ꍇAʃt@Cɕ̒[B
     * 
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * 
     * @return JڏsȂ߁AkԂB
     * 
     * @exception JRException [쐬Ŗ肪ꍇ
     * @exception IOException Stream̏Ŗ肪ꍇ
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
        throws JRException, IOException {
        
        // p[^̐
        Map paramMap = getParameterMap(form, request);
        
        //Templatet@C̃Xg[擾B
        InputStream inputStream = null;
        JasperReport jasperReport = null;
        
        try {
            inputStream = Thread.currentThread().getContextClassLoader().
                    getResourceAsStream(getTemplatePath(form, request));
        
            //Report(Template)̐
            jasperReport = JasperCompileManager.compileReport(inputStream);
            
        } finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        
        //f[^x[X̎擾l
        List<T> list = getReportData(form, request);
                
        //JavaBeanpConnection𐶐
        JRBeanCollectionDataSource dataSource =
            new JRBeanCollectionDataSource(list);
        
        //ReportɃf[^ݒ
        JasperPrint jasperPrint =
            JasperFillManager.fillReport(jasperReport, paramMap, dataSource);
        
        //ContentType̐ݒ
        response.setContentType("application/pdf");
        
        //PDFt@Cݒ
        response.setHeader("Content-Disposition",
                "attachment; filename=\"" + getFileName(form, request) + "\"");
        
        //X|XouputStream擾
        ServletOutputStream outputStream = response.getOutputStream();
        
        //OupurtStreamPDFt@C̓eݒB
        try {
            JasperExportManager.exportReportToPdfStream(jasperPrint,
                    outputStream);
            outputStream.flush();
        } finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }

        //JڏsȂ߁AkԂB
        return null;
    }
    
    /**
     * p[^}bvԂB<br>
     * p[^͒[o͎ASĂ̒[ɏo͂łB<br>
     * 
     * @param form ANVtH[
     * @param request NGXg
     * 
     * @return p[^}bv
     */
    public abstract Map getParameterMap(ActionForm form,
            HttpServletRequest request);
    
    /**
     * [o͏񃊃XgԂB<br>
     * ̒[o͂ꍇȀXgƂĕԂB
     * 
     * @param form ANVtH[
     * @param request NGXg
     * 
     * @return [o͏񃊃Xg
     */
    public abstract List<T> getReportData(ActionForm form,
            HttpServletRequest request);
    
    /**
     * ev[gt@C̑΃pXԂB<br>
     * ΃pX̓NXpX̃[gƂċLqB<br>
     * <br>
     *  ӓ_FNXpXł͂Ȃt@C͑ΉoȂB
     * 
     * @param form ANVtH[
     * @param request NGXg
     * 
     * @return ev[gt@C̑΃pX
     */
    public abstract String getTemplatePath(ActionForm form,
            HttpServletRequest request);

    /**
     * 钠[̃t@CԂB<br>
     * 
     * @param form ANVtH[
     * @param request NGXg
     * 
     * @return t@C
     */
    public abstract String getFileName(ActionForm form,
            HttpServletRequest request);
}
