/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

import jp.terasoluna.utlib.TagUTUtil;
import junit.framework.TestCase;

/**
 * DateTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class DateTagTest extends TestCase {

    // eXgΏ
    DateTag tag = null;

    /**
     * Constructor for DateTagTest.
     * @param arg0
     */
    public DateTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (DateTag) TagUTUtil.create(DateTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoFormat01B<br>
     * <br>
     * (n)<br>
     * ϓ_FE<br>
     * <br>
     * ͒l<br>
     * date="2004-11-24 10:31:00.000000000"<br>
     * pattern="yyyy.MM.dd"<br>
     * <br>
     * Ғl<br>
     * ߂l:String="2004.11.24"<br>
     * <br>
     * сAtH[}bgp^[ȏꍇ̃eXgP[X<br>
     */
    public void testDoFormat01() throws Exception {

        // eXgf[^ݒ
        Timestamp time = Timestamp.valueOf("2004-11-24 10:31:00.000000000");
        Date date = new Date(time.getTime());
        tag.pattern = "yyyy.MM.dd";

        // eXgs
        String result = tag.doFormat(date);

        // eXgʊmF
        assertEquals("2004.11.24", result);

    } /* testDoFormat01 End */

    /**
     * testDoFormat02B<br>
     * <br>
     * (ُn)<br>
     * ϓ_FG<br>
     * <br>
     * ͒l<br>
     * date=Null<br>
     * pattern="yyyy.MM.dd"<br>
     * <br>
     * Ғl<br>
     * ߂l:String=NullPointerException<br>
     * <br>
     * Null̏ꍇ̃eXgP[X<br>
     */
    public void testDoFormat02() throws Exception {

        // eXgf[^ݒ
        tag.pattern = "yyyy.MM.dd";

        // eXgs
        try{
            tag.doFormat(null);
        }catch(NullPointerException ex){

            // eXgʊmF
            assertEquals(NullPointerException.class.getName(), ex.getClass()
                    .getName());
            return;
        }

        fail();

    } /* testDoFormat02 End */

    /**
     * testDoFormat03B<br>
     * <br>
     * (ُn)<br>
     * ϓ_FG<br>
     * <br>
     * ͒l<br>
     * date="2004-11-24 10:31:00.000000000"<br>
     * pattern=Null<br>
     * <br>
     * Ғl<br>
     * ߂l:String=NullPointerException<br>
     * <br>
     * p^[Null̏ꍇ̃eXgP[X<br>
     */
    public void testDoFormat03() {

        // eXgf[^ݒ
        Timestamp time = Timestamp.valueOf("2004-11-24 10:31:00.000000000");
        Date date = new Date(time.getTime());
        tag.pattern = null;

        // eXgs
        try{
            tag.doFormat(date);
        }catch(NullPointerException ex){

            // eXgʊmF
            assertEquals(NullPointerException.class.getName(), ex.getClass()
                    .getName());
            return;
        }

        fail();

    } /* testDoFormat03 End */
    
    /**
     * testDoFormat04B<br>
     * <br>
     * (n)<br>
     * ϓ_FC<br>
     * <br>
     * ͒l<br>
     * date="2009/01/09 12:34:56"getDefaultDateFormat()Date^Ƀp[X<br>
     * pattern="yyyy.MM.dd HH.mm.ss"<br>
     * <br>
     * Ғl<br>
     * ߂l:String="2009.01.09 12.34.56"<br>
     * <br>
     * ftHg̃tH[}bgp^[12̓tDate^Ƀp[XA
     * ēxtɃtH[}bgꍇA0ł͂Ȃ12ƕ\邱ƁB
     * <br>
     */
    public void testDoFormat04() throws Exception {

        // eXgf[^ݒ
        SimpleDateFormat sdf = new SimpleDateFormat(tag.getDefaultDateFormat());
        Date date = sdf.parse("2009/01/09 12:34:56");
        tag.pattern = "yyyy.MM.dd hh.mm.ss";

        // eXgs
        String result = tag.doFormat(date);

        // eXgʊmF
        assertEquals("2009.01.09 12.34.56", result);

    } /* testDoFormat04 End */

} /* DateTagTest Class End */
