/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.util;

import java.util.Map;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.spring.mock.MockWebApplicationContext;
import junit.framework.TestCase;

import org.apache.struts.util.MessageResources;
import org.springframework.beans.BeansException;
import org.springframework.context.MessageSource;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

/**
 * {@link SpringMessageResourcesFactory} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * SpringMessageResourcesFactory𐶐t@NgNX<br>
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.util.SpringMessageResourcesFactory
 */
public class SpringMessageResourcesFactoryTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SpringMessageResourcesFactoryTest.class);
    }

    /**
     * ̃eXgP[XŗpApplicationContext
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    private WebApplicationContext context = null;
    
    /**
     * s.
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @SuppressWarnings("unchecked")
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        // ContextLoader.getCurrentWebApplicationContext()̕ԋpl
        // bNApplicationContextZbgĂB
        Map currentContextPerThread = (Map) UTUtil.getPrivateField(
                ContextLoader.class, "currentContextPerThread");
        String[] configLocations = new String[] {
        "jp/terasoluna/fw/web/struts/util/SpringMessageResourcesFacotryTest01.xml"};
        this.context = new MockWebApplicationContext(configLocations);
        currentContextPerThread.put(
            Thread.currentThread().getContextClassLoader(), this.context);
    }

    /**
     * Is.
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.context = null;
    }
    
    /**
     * testCreateResources01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config:"notExistBeanName"i݂ȂBeanj<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesFacotryTest01.xml<br>
     * <br>
     * ҒlF(߂l) SpringMessageResources:-<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.message.bean.exception"<br>
     *                    bvOFBeansExceptioñTuNX<br>
     *         (ԕω) O:yERROROz"notExistBeanName is not found or it is not MessageSource instance."<br>
     *         
     * <br>
     * ݂ȂBeannꍇAG[Oo͂A
     * OX[邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources01() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        
        // eXg{
        try {
            factory.createResources("notExistBeanName");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.message.bean.exception", e.getErrorCode());
            assertTrue(e.getCause() instanceof BeansException);
            assertTrue(LogUTUtil.checkError("notExistBeanName is not found or it is not MessageSource instance."));
        }
    }
    
    /**
     * testCreateResources02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:""i󕶎j<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesFacotryTest01.xml<br>
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config=""<br>
     *                    returnNull=MessageResourcesFactory.getReturnNull()<br>
     *                    messageSource=OŃZbgapplicationContext<br>
     *         
     * <br>
     * 󕶎BeannꍇASpringMessageResources邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources02() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        
        // eXg{
        MessageResources resources = factory.createResources("");
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("", UTUtil.getPrivateField(resources, "config"));
        assertEquals(factory.getReturnNull(),
                    UTUtil.getPrivateField(resources, "returnNull"));
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
    }
    
    /**
     * testCreateResources03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:null<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesFacotryTest01.xml<br>
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config=null<br>
     *                    returnNull=MessageResourcesFactory.getReturnNull()<br>
     *                    messageSource=OŃZbgapplicationContext<br>
     *         
     * <br>
     * nullBeannꍇASpringMessageResources邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources03() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        
        // eXg{
        MessageResources resources = factory.createResources(null);
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals(null, UTUtil.getPrivateField(resources, "config"));
        assertEquals(factory.getReturnNull(),
                    UTUtil.getPrivateField(resources, "returnNull"));
        assertSame(this.context, UTUtil.getPrivateField(resources, "messageSource"));
    }
    
    /**
     * testCreateResources04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:"messageSource"i݂Beanj<br>
     *         (O) applicationContext:bNApplicationContext<br>
     *         (O) ContextLoader.getCurrentWebApplicationContext()̕ԋpl:
     *                    applicationContextƓbNApplicationContext<br>
     *         (O) Bean`t@C:SpringMessageResourcesFacotryTest01.xml<br>
     * <br>
     * ҒlF(߂l) SpringMessageResources:<br>
     *                    factory=߂l𐶐SpringMessageResourcesFactoryCX^Xg<br>
     *                    config="messageSource"<br>
     *                    returnNull=MessageResourcesFactory.getReturnNull()<br>
     *                    messageSource=MessageSourcẽTuNX<br>
     *         
     * <br>
     * ݂BeannꍇASpringMessageResources邱ƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources04() throws Exception {
        // O
        SpringMessageResourcesFactory factory = new SpringMessageResourcesFactory();
        
        // eXg{
        MessageResources resources = factory.createResources("messageSource");
        
        // 
        assertEquals(resources.getClass().getName(),
                SpringMessageResources.class.getName());
        assertSame(factory, UTUtil.getPrivateField(resources, "factory"));
        assertEquals("messageSource", UTUtil.getPrivateField(resources, "config"));
        assertEquals(factory.getReturnNull(),
                    UTUtil.getPrivateField(resources, "returnNull"));
        assertTrue(UTUtil.getPrivateField(resources, "messageSource") instanceof MessageSource);
    }
}
