/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockQueueBrowser;
import com.mockrunner.mock.jms.MockQueueReceiver;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;

public class QueueTransmissionManager
implements Serializable {
    private MockConnection connection;
    private MockSession session;
    private List queueSenderList;
    private List queueReceiverList;
    private List queueBrowserList;

    public QueueTransmissionManager(MockConnection mockConnection, MockSession mockSession) {
        this.connection = mockConnection;
        this.session = mockSession;
        this.queueSenderList = new ArrayList();
        this.queueReceiverList = new ArrayList();
        this.queueBrowserList = new ArrayList();
    }

    public void closeAll() {
        this.closeAllQueueSenders();
        this.closeAllQueueReceivers();
        this.closeAllQueueBrowsers();
    }

    public void closeAllQueueSenders() {
        for (int i = 0; i < this.queueSenderList.size(); ++i) {
            QueueSender queueSender = (QueueSender)this.queueSenderList.get(i);
            try {
                queueSender.close();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void closeAllQueueReceivers() {
        for (int i = 0; i < this.queueReceiverList.size(); ++i) {
            QueueReceiver queueReceiver = (QueueReceiver)this.queueReceiverList.get(i);
            try {
                queueReceiver.close();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void closeAllQueueBrowsers() {
        for (int i = 0; i < this.queueBrowserList.size(); ++i) {
            QueueBrowser queueBrowser = (QueueBrowser)this.queueBrowserList.get(i);
            try {
                queueBrowser.close();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public MockQueueSender createQueueSender(MockQueue mockQueue) {
        MockQueueSender mockQueueSender = new MockQueueSender(this.connection, this.session, mockQueue);
        this.queueSenderList.add(mockQueueSender);
        return mockQueueSender;
    }

    public MockQueueSender getQueueSender(int n) {
        if (this.queueSenderList.size() <= n || n < 0) {
            return null;
        }
        return (MockQueueSender)this.queueSenderList.get(n);
    }

    public MockQueueSender getQueueSender(String string) {
        List list = this.getQueueSenderList(string);
        if (list.size() <= 0) {
            return null;
        }
        return (MockQueueSender)list.get(0);
    }

    public List getQueueSenderList(String string) {
        ArrayList<QueueSender> arrayList = new ArrayList<QueueSender>();
        for (int i = 0; i < this.queueSenderList.size(); ++i) {
            QueueSender queueSender = (QueueSender)this.queueSenderList.get(i);
            try {
                if (!queueSender.getQueue().getQueueName().equals(string)) continue;
                arrayList.add(queueSender);
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getQueueSenderList() {
        return Collections.unmodifiableList(this.queueSenderList);
    }

    public MockQueueReceiver createQueueReceiver(MockQueue mockQueue, String string) {
        MockQueueReceiver mockQueueReceiver = new MockQueueReceiver(this.connection, this.session, mockQueue, string);
        this.queueReceiverList.add(mockQueueReceiver);
        return mockQueueReceiver;
    }

    public MockQueueReceiver getQueueReceiver(int n) {
        if (this.queueReceiverList.size() <= n || n < 0) {
            return null;
        }
        return (MockQueueReceiver)this.queueReceiverList.get(n);
    }

    public MockQueueReceiver getQueueReceiver(String string) {
        List list = this.getQueueReceiverList(string);
        if (list.size() <= 0) {
            return null;
        }
        return (MockQueueReceiver)list.get(0);
    }

    public List getQueueReceiverList(String string) {
        ArrayList<QueueReceiver> arrayList = new ArrayList<QueueReceiver>();
        for (int i = 0; i < this.queueReceiverList.size(); ++i) {
            QueueReceiver queueReceiver = (QueueReceiver)this.queueReceiverList.get(i);
            try {
                if (!queueReceiver.getQueue().getQueueName().equals(string)) continue;
                arrayList.add(queueReceiver);
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getQueueReceiverList() {
        return Collections.unmodifiableList(this.queueReceiverList);
    }

    public MockQueueBrowser createQueueBrowser(MockQueue mockQueue, String string) {
        MockQueueBrowser mockQueueBrowser = new MockQueueBrowser(this.connection, mockQueue, string);
        this.queueBrowserList.add(mockQueueBrowser);
        return mockQueueBrowser;
    }

    public MockQueueBrowser getQueueBrowser(int n) {
        if (this.queueBrowserList.size() <= n || n < 0) {
            return null;
        }
        return (MockQueueBrowser)this.queueBrowserList.get(n);
    }

    public MockQueueBrowser getQueueBrowser(String string) {
        List list = this.getQueueBrowserList(string);
        if (list.size() <= 0) {
            return null;
        }
        return (MockQueueBrowser)list.get(0);
    }

    public List getQueueBrowserList(String string) {
        ArrayList<QueueBrowser> arrayList = new ArrayList<QueueBrowser>();
        for (int i = 0; i < this.queueBrowserList.size(); ++i) {
            QueueBrowser queueBrowser = (QueueBrowser)this.queueBrowserList.get(i);
            try {
                if (!queueBrowser.getQueue().getQueueName().equals(string)) continue;
                arrayList.add(queueBrowser);
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getQueueBrowserList() {
        return Collections.unmodifiableList(this.queueBrowserList);
    }
}

