/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.codelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.object.MappingSqlQuery;


/**
 * R[hXg̏f[^x[XpčsA
 * {@link jp.terasoluna.fw.web.codelist.AbstractMultilingualCodeListLoader}A
 * {@link jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader}
 * NXłB
 *
 * <p>
 * ̃NXpăR[hXg𐶐ꍇ́A
 * dataSourceɎgpf[^\[Xw肵ƁA
 * init-methodloadw肵Aload()\bhŏɎsKvB<br>
 * ܂A{NX̓XbhZ[tł͂Ȃ߁A
 * Ɩǋ@\̓T[oǋ@\𗘗pA
 * R[hXgւ̎QƂsȂԂɂreload()\bh
 * s悤ɕǐ݌vsKvB<br>
 * XbhZ[tƂꍇAR[hXgQƎɔr䂪
 * \򉻂炷ƂȂ蓾邽ߒӂKvłB
 * </p>
 *
 * <p>
 * R[hXgf[^x[X擾邽߂ SQL ́ABean`t@C
 * ݒ肷B
 * </p>
 * <p>
 * <strong>Bean`t@C̐ݒB</strong>
 * <br>
 * f[^\[XTerasolunaDataSourceƂĒ`ĂꍇB
 * </p>
 * <p>
 * <code><pre>
 * &lt;bean id=<strong>&quot;loader1&quot;</strong>
 *       class=&quot;jp.terasoluna.fw.web.codelist.DBCodeListLoader&quot;
 *       init-method=&quot;load&quot;&gt;
 *   &lt;property name=&quot;defaultLocale&quot; value=&quot;ja&quot; /&gt;
 *   &lt;property name=&quot;dataSource&quot;&gt;
 *     &lt;ref bean=<strong>&quot;TerasolunaDataSource&quot;</strong>/&gt;
 *   &lt;/property&gt;
 *   &lt;property name=&quot;sql&quot;&gt;
 *     &lt;value&gt;<strong>SELECT KEY, VALUE, LANGUAGE, COUNTRY, VARIANT FROM CODE_LISTS</strong>&lt;/value&gt;
 *   &lt;/property&gt;
 *
 * &lt;/bean&gt;
 * </code></pre>
 * </p>
 * <p>
 *  SQLŎ擾ꂽR[hXgi[NX LocaleCodeBean ́A
 *  id A nameAlanguageAcountryAvariant A
 *   SELECT Ŏw肳ꂽJ̏Ԃ LocaleCodeBean 
 *  i[B<br>
 *  Lł́A KEY  id AVALUE  nameALANGUAGElanguageA
 *  ACOUNTRYcountryAVARIANTvariant ̏ԂŊi[B<br>
 *  擾ꂽJ2ɖȂꍇAႦΏL
 *   KEY ̂ݎ擾ꍇ́A nameAlanguageAcountryAvariant 
 *   null i[B
 *   SELECT Ŏ擾J6ȏłƂ́A
 *  6߈ȍ~̃J͖B<br>
 *  R[hXgۉΉĂȂꍇ́A
 *  LANGUAGEACOUNTRYAVARIANTJ擾ȂĂ悢B
 * </p>
 * <p>
 * SQLŎ擾ꂽ(LocaleCodeBean)R[hXgƂĕێ
 * Map&lt;Locale,List&lt;CodeBean&gt;&gt;쐬B
 * Map̃L[LocaleLocaleCodeBeanlanguageAcountryAvariant쐬B
 * </p>
 * <p>
 *  JSP ɂāA Struts &lt;logic:iterate&gt;
 *  ^O name A&lt;html:options&gt;^O
 *  collection beanƂĎQƂB<br>
 *  ȉ́Abean &quot;loader1&quot; ƂāA
 *  &lt;html:options&gt;  collectionɎw
 *  ꍇ̗łB
 * </p>
 * <strong>JSP ł̃R[hXggpB</strong><br>
 * <p>
 *  <code><pre>
 *  &lt;ts:defineCodeList id=<b>"loader1"</b> /&gt;
 *  c
 *  &lt;html:select property="selectOptions"&gt;
 *    &lt;html:options collection=<b>"loader1"</b>
 *                  labelProperty="name"
 *                  property="id"/&gt;
 *  &lt;/html:select&gt;
 *  </pre></code>
 * </p>
 * R[hXg̃[hɂẮA
 * {@link
 *  jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction}
 *
 * A܂R[hXgJSPł̎gp@́A
 * {@link
 *  jp.terasoluna.fw.web.taglib.DefineCodeListTag}
 * ƁA
 * {@link
 *  jp.terasoluna.fw.web.taglib.WriteCodeCountTag}
 * QƂ̂ƁB
 *
 * </p>
 * @see jp.terasoluna.fw.web.codelist.CodeBean
 * @see
 *    jp.terasoluna.fw.web.struts.actions.ReloadCodeListAction
 * @see jp.terasoluna.fw.web.taglib.DefineCodeListTag
 * @see jp.terasoluna.fw.web.taglib.WriteCodeCountTag
 */
public class DBCodeListLoader extends AbstractMultilingualCodeListLoader implements ReloadableCodeListLoader {

    /**
     * ONXB
     */
    private Log log = LogFactory.getLog(DBCodeListLoader.class);
    
    /**
     * R[hXg擾邽߂SQLB
     */
    private String sql = null;

    /**
     * DBڑɎgpf[^\[XB
     */
    private DataSource dataSource = null;

    /**
     * R[hXgɎgp郍bNIuWFNgB
     */
    private final Object lockObject = new Object();

	/**
     * R[hXg̏sB
     *
     * <p>
     * {@link #loadCodeList()}gĊɐݒ肳Ă
     * dataSourceƎw肳ꂽSQLɃR[hXg𐶐B
     * R[hXgłɑ݂ꍇɂ́AsȂB
     * </p>
     */
    public void load() {
        if (log.isDebugEnabled()) {
            log.debug("load() called.");
        }
        if (localeMap != null) {
            // łɃR[hXgǂݍ܂ĂƂɂ͉ȂB
            return;
        }
        // R[hXgǂݍށB
        loadCodeList();
    }

    /**
     * R[hXg̍ēǂݍ݂sB
     *
     * <p>
     * codeLists̓{@link #loadCodeList()}
     * ĂяoBƖǒ̊ǗҋƖɂėp邱Ƃ]܂B
     * </p>
     */
    public void reload() {
        if (log.isDebugEnabled()) {
            log.debug("reload() called.");
        }
        if (localeMap == null) {
            // codeLists݂Ȃꍇ͂̂܂loadCodeListĂԁB
            loadCodeList();
        } else {
            synchronized (lockObject) {
                // codeLists݂ꍇA
                // ǂݍݒɍēǂݍ݂hߓB
                loadCodeList();
            }
        }
    }

    /**
     * R[hXgǂݍށB
     *
     * dataSourceƎw肳ꂽSQLɃR[hXg𐶐B
     */
    @SuppressWarnings("unchecked")
    protected void loadCodeList() {
        if (log.isDebugEnabled()) {
            log.debug("loadCodeList() called.");
        }

        Map<Locale, List<CodeBean>> resultMap = 
                                        new HashMap<Locale, List<CodeBean>>();

        // f[^x[XlR[hXg擾B
        MappingSqlQuery query = new DBCodeListQuery(dataSource, sql);
        query.compile();
        List<LocaleCodeBean> resultList = query.execute();
        for (LocaleCodeBean lcb : resultList) {
            CodeBean cb = new CodeBean();
            cb.setId(lcb.getId());
            cb.setName(lcb.getName());

            Locale curLocale = createLocale(lcb);
            if (curLocale == null) {
                curLocale = defaultLocale;
            }

            List<CodeBean> codeList = resultMap.get(curLocale);
            // R[hXg݂ȂꍇAB
            if (codeList == null) {
                codeList = new ArrayList<CodeBean>();
            }
            codeList.add(cb);


            resultMap.put(curLocale, codeList);
        }

        for (Entry<Locale, List<CodeBean>> entry : resultMap.entrySet()) {
            resultMap.put(entry.getKey(), 
                             Collections.unmodifiableList(entry.getValue()));
        }

        localeMap = Collections.unmodifiableMap(resultMap);
    }
    
    /**
     * LocaleIuWFNg𐶐B<br>
     * R[hAR[hAoAgR[hLocaleIuWFNg𐶐B
     * R[h^ĂȂꍇ́AftHgP[̌R[ĥ
     * i[ALocaleIuWFNg𐶐B
     *
     * @param bean R[hXg
     *
     * @return
     *      R[hAR[hAoAgR[hi[LocaleIuWFNgB
     */
    Locale createLocale(LocaleCodeBean bean) {
        return createLocale(bean.getLanguage(), bean.getCountry(), bean
                .getVariant());
    }

    /**
     * dataSource擾B
     *
     * @return dataSource \tB[hlB
     */
    public DataSource getDataSource() {
        return dataSource;
    }

    /**
     * dataSourceݒ肷B
     *
     * @param dataSource dataSource\tB[hlB
     */
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /**
     * R[hXg擾SQL擾B
     * @return SQL
     */
    public String getSql() {
        return sql;
    }

    /**
     * R[hXg擾SQLݒ肷B
     * @param sql SQL
     */
    public void setSql(String sql) {
        this.sql = sql;
    }

}
