/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.actions.AbstractDownloadObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadString
extends AbstractDownloadObject {
    private static final long serialVersionUID = -7476231978581381416L;
    private Log log = LogFactory.getLog(DownloadString.class);
    protected String value = null;

    public DownloadString(String name, String value) {
        super(name, null, null);
        if (value == null) {
            throw new SystemException((Throwable)new IllegalArgumentException("Download content must not be null"), "errors.no.download.content");
        }
        this.value = value;
    }

    public int getLengthOfData() {
        return this.getContent().length;
    }

    protected byte[] getContent() {
        try {
            return this.value.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Charset is not valid.", (Throwable)e);
            }
            return this.value.getBytes();
        }
    }

    protected InputStream getStreamInternal() throws IOException {
        return new ByteArrayInputStream(this.getContent());
    }
}

