/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class ActionServletEx
extends ActionServlet {
    private static final long serialVersionUID = -559409080495147588L;
    private static Log log = LogFactory.getLog(ActionServletEx.class);

    protected ModuleConfig initModuleConfig(String prefix, String paths) throws ServletException {
        String[] pathAry;
        if (log.isDebugEnabled()) {
            StringBuilder logSb = new StringBuilder();
            logSb.append("Initializing module path '");
            logSb.append(prefix);
            logSb.append("' configuration from '");
            logSb.append(paths);
            logSb.append("'");
            log.debug((Object)logSb.toString());
        }
        StringBuilder sb = new StringBuilder();
        for (String path : pathAry = paths.split(",")) {
            sb.append(this.parseModuleConfigPath(path.trim()));
        }
        if (sb.length() > 0 && ',' == sb.charAt(sb.length() - 1)) {
            sb.setLength(sb.length() - 1);
        }
        return super.initModuleConfig(prefix, sb.toString());
    }

    protected String parseModuleConfigPath(String locationPattern) throws UnavailableException {
        StringBuilder sb = new StringBuilder();
        StringBuilder logSb = new StringBuilder();
        ServletContextResourcePatternResolver rpr = new ServletContextResourcePatternResolver(this.getServletContext());
        Resource[] resources = null;
        try {
            resources = rpr.getResources(locationPattern);
        }
        catch (IOException e) {
            this.handleConfigException(locationPattern, e);
        }
        for (Resource resource : resources) {
            if (!(resource instanceof ServletContextResource)) continue;
            ServletContextResource scr = (ServletContextResource)resource;
            sb.append(scr.getPath());
            sb.append(",");
            if (!log.isInfoEnabled()) continue;
            logSb.setLength(0);
            logSb.append("Loading Struts module configurations from ");
            logSb.append(scr.getPath());
            log.info((Object)logSb.toString());
        }
        return sb.toString();
    }

    protected void handleConfigException(String path, Exception e) throws UnavailableException {
        String msg = this.internal.getMessage("configParse", (Object)path);
        log.error((Object)msg, (Throwable)e);
        throw new UnavailableException(msg);
    }
}

