/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib.spring.mock;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.dao.StoredProcedureDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * StoredProcedureDAÕbNAbvNXB
 * 
 * P̎StoredProcedureDAO̎NXƂĐݒ肷B
 *
 */
public class MockStoredProcedureDAO implements StoredProcedureDAO {
    
    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(MockStoredProcedureDAO.class);
    
    /**
     * \bhXgB
     * NX̃\bhsxɁAɊi[B
     */
    private List<DAOParams> storedProcedureDAOParams = new ArrayList<DAOParams>();
    
    /**
     * ߂liX[OIuWFNgj̃Xg
     */
    private List<Object> spDAOResults = new ArrayList<Object>();
    
    /**
     * \bhԋplXgɒǉB
     *
     * @param exception X[OIuWFNg
     */
    public void addResults(RuntimeException exception) {
        this.spDAOResults.add(exception);
    }    
    
    /**
     * \bhXg擾B
     *
     * @return \bhXg
     */
    public List<DAOParams> getStoredProcedureDAOParams() {
        return storedProcedureDAOParams;
    }

    /**
     * storedProcedureDAOParamsɊi[B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     */
    public void executeForObject(String sqlID, Object bindParams) {
        if (log.isDebugEnabled()) {
            log.debug("executeForObject Start.");
        }
        
        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        
        // \bhi[
        params.setMethodName("executeForObject");
        
        // XgɊi[
        storedProcedureDAOParams.add(params);
        
        processExecuteForObject();
        
        if (log.isDebugEnabled()) {
            log.debug("executeForObject End.");
        }
    }

    /**
     * spDAOResults̈ԖڂɊi[ꂽlA
     * RuntimeExceptionIuWFNg̏ꍇ̗͂OX[B
     * X[OspDAOResults͍폜B
     * ȊȌꍇ́AIllegalStateExceptionX[B
     */
    private void processExecuteForObject() {
        
        if (this.spDAOResults.isEmpty()) {
            return;
        }
        
        // OIuWFNg̎擾
        Object obj = this.spDAOResults.get(0);
        
        // X[ς݂ƂȂOIuWFNgXg폜
        this.spDAOResults.remove(0);
        
        if (obj instanceof RuntimeException) {
            throw (RuntimeException)obj;
        }
        throw new IllegalStateException("results value is illegal.");
    }
}