/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.context.RequestContextManager} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Ǘ}l[WB<br>
 * OFThreadLocalNulllɂȂȂB
 * <p>
 *
 * @see jp.terasoluna.fw.web.rich.context.RequestContextManager
 */
public class RequestContextManagerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(RequestContextManagerTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public RequestContextManagerTest(String name) {
        super(name);
    }

    /**
     * testGetRequestContext01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() this.resources:ThreadLocal<br>
     *                iRequestContexto<br>
     *                @requestName="test"<br>
     *                pj<br>
     *
     * <br>
     * ҒlF(߂l) RequestContext:ThreadLocal<br>
     *                  iRequestContexto<br>
     *                  @requestName="test"<br>
     *                  pj<br>
     *
     * <br>
     * resourcesgetter\bh̃eXgB
     * Xbh[Jɐݒ肳Ă鐧ԂB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetRequestContext01() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        RequestContext ctx = new RequestContext();
        ctx.setRequestName("test");
        tlocal.set(ctx);
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        // eXg{
        // 
        assertSame(ctx, RequestContextManager.getRequestContext());
    }

    /**
     * testGetRequestContext02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() this.resources:ThreadLocal<br>
     *                ij<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    ("No RequestContext  bound to thread [<br>
     *                    (Thread.currentThread().getName())])<br>
     *         (ԕω) O:OxFG[<br>
     *                    No RequestContext bound to thread!<br>
     *
     * <br>
     * resourcesgetter\bh̃eXgB
     * Xbh[Jɐ񂪐ݒ肳ĂȂ߁AOB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetRequestContext02() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        try {
            // eXg{
            RequestContextManager.getRequestContext();
            fail();
        } catch (IllegalStateException e) {
            // 
            assertEquals("No RequestContext  bound to thread ["
                    + Thread.currentThread().getName() + "]", e.getMessage());
            assertTrue(
                    LogUTUtil.checkError("No RequestContext bound to thread!"));
        }
    }

    /**
     * testHasRequestContext01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() this.requestName:ThreadLocal<br>
     *                iRequestContexto<br>
     *                @requestName="test"<br>
     *                pj<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * ThreadLocalɒlݒ肳Ă邩郁\bhB
     * ThreadLocalɎsXbh̃IuWFNgZbgp^[̃eXgB
     * TRUEԂB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasRequestContext01() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        RequestContext ctx = new RequestContext();
        ctx.setRequestName("test");
        tlocal.set(ctx);
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        // eXg{
        // 
        assertTrue(RequestContextManager.hasRequestContext());
    }

    /**
     * testHasRequestContext02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() this.requestName:ThreadLocal<br>
     *                ij<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * ThreadLocalɒlݒ肳Ă邩郁\bhB
     * ThreadLocal̃p^[̃eXgBFALSEԂB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasRequestContext02() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        // eXg{
        // 
        assertFalse(RequestContextManager.hasRequestContext());
    }

    /**
     * testBindRequestContext01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() :RequestContexto<br>
     *                @requestName="arg"<br>
     *                p<br>
     *         () this.resources:ThreadLocal<br>
     *                ij<br>
     *
     * <br>
     * ҒlF(ԕω) this.resources:ThreadLocal<br>
     *                    iRequestContexto<br>
     *                    @requestName="arg"<br>
     *                    pj<br>
     *
     * <br>
     * 𐶐郁\bh̃eXgB
     * 񂪋̃Xbh[JIuWFNgɁAReLXgݒ肷B
     * P[XB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testBindRequestContext01() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        RequestContext ctx = new RequestContext();
        ctx.setRequestName("arg");

        // eXg{
        RequestContextManager.bindRequestContext(ctx);

        // 
        ThreadLocal t =
            (ThreadLocal) UTUtil.getPrivateField(
                    RequestContextManager.class, "resources");
        Object result = t.get();
        assertSame(ctx, result);
    }

    /**
     * testBindRequestContext02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() :RequestContexto<br>
     *                @requestName="arg"<br>
     *                p<br>
     *         () this.resources:ThreadLocal<br>
     *                iRequestContexto<br>
     *                @requestName="test"<br>
     *                pj<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    iAlready RequestContext [(ReLXg̕\)]<br>
     *                     [iThread.currentThread().getName()j]j<br>
     *         (ԕω) O:OxFG[<br>
     *                    Already RequestContext bound to thread!<br>
     *
     * <br>
     * 𐶐郁\bh̃eXgB
     * 񂪊ɐݒ肳ĂXbh[JIuWFNgɁA
     * ReLXgݒ肷BP[XB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testBindRequestContext02() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        RequestContext rctx = new RequestContext();
        tlocal.set(rctx);
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        RequestContext ctx = new RequestContext();
        ctx.setRequestName("arg");

        try {
            // eXg{
            RequestContextManager.bindRequestContext(ctx);
            fail();
        } catch (IllegalStateException e) {
            // 
            assertEquals("Already RequestContext [" + rctx + "]" + "   ["
                    + Thread.currentThread().getName() + "]", e.getMessage());
            assertTrue(LogUTUtil.checkError(
                    "Already RequestContext bound to thread!"));
        }
    }

    /**
     * testBindRequestContext03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() :null<br>
     *         () this.resources:ThreadLocal<br>
     *                ij<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException(<br>
     *                    "RequestContext cannot set null.")<br>
     *         (ԕω) O:OxFG[<br>
     *                    RequestContext cannot set null.<br>
     *
     * <br>
     * 𐶐郁\bh̃eXgB
     * Null̐ݒ肵悤ƂP[XBO𓊂B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testBindRequestContext03() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        // eXg{
        try {
            RequestContextManager.bindRequestContext(null);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("RequestContext cannot set null.", e.getMessage());
            assertTrue(LogUTUtil.checkError("RequestContext cannot set null."));
        }
    }

    /**
     * testUnbindRequestContext01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() this.resources:ThreadLocal<br>
     *                ij<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    iNo RequestContext bound to thread<br>
     *                     [iThread.currentThread().getName()j]j<br>
     *         (ԕω) O:OxFG[<br>
     *                    No RequestContext bound to thread!<br>
     *
     * <br>
     * j郁\bhB
     * Xbh[JIuWFNgɉ񂪓ĂȂp^[
     * eXgBOB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testUnbindRequestContext01() throws Exception {
        // O
        ThreadLocal tlocal = new ThreadLocal();
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        // eXg{
        try {
            RequestContextManager.unbindRequestContext();
            fail();
        } catch (IllegalStateException e) {
            assertEquals("No RequestContext  bound to thread ["
                    + Thread.currentThread().getName() + "]", e.getMessage());
            assertTrue(
                    LogUTUtil.checkError("No RequestContext bound to thread!"));
        }
    }

    /**
     * testUnbindRequestContext02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() this.resources:ThreadLocal<br>
     *                iRequestContexto<br>
     *                @requestName="test"<br>
     *                pj<br>
     *
     * <br>
     * ҒlF(ԕω) this.resources:ThreadLocal<br>
     *                    ij<br>
     *
     * <br>
     * j郁\bhB
     * Xbh[JIuWFNgɐ񂪓Ăp^[̃eXgB
     * 񂪍폜BP[XB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testUnbindRequestContext02() throws Exception {
        // O
        ThreadLocal<RequestContext> tlocal = new ThreadLocal<RequestContext>();
        RequestContext ctx = new RequestContext();
        ctx.setRequestName("test");
        tlocal.set(ctx);
        UTUtil.setPrivateField(
                RequestContextManager.class, "resources", tlocal);

        // eXg{
        RequestContextManager.unbindRequestContext();

        // 
        ThreadLocal t = (ThreadLocal)
            UTUtil.getPrivateField(RequestContextManager.class, "resources");
        assertNull(t.get());
    }

}
