/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.Expression;

public class PropertyExpression
implements Expression {
    private String name;

    public PropertyExpression(String string) {
        this.name = string;
    }

    public Object evaluate(Message message) throws JMSException {
        Object object = null;
        if (this.name != null) {
            object = message.getObjectProperty(this.name);
        }
        if (object == null) {
            if (this.name.equals("JMSType")) {
                object = message.getJMSType();
            } else if (this.name.equals("JMSMessageID")) {
                object = message.getJMSMessageID();
            } else if (this.name.equals("JMSCorrelationID")) {
                object = message.getJMSCorrelationID();
            } else if (this.name.equals("JMSPriority")) {
                object = new Integer(message.getJMSPriority());
            } else if (this.name.equals("JMSTimestamp")) {
                object = new Long(message.getJMSTimestamp());
            }
        }
        return object;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)object).name);
    }
}

