/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.SQLUtil;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MockStatement
implements Statement {
    private AbstractResultSetHandler resultSetHandler;
    private ResultSet[] currentResultSets = null;
    private int[] currentUpdateCounts = null;
    private int currentResultSetIndex = 0;
    private int currentUpdateCountIndex = 0;
    private List batches = new ArrayList();
    private String cursorName = "";
    private int querySeconds = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 1;
    private MockResultSet lastGeneratedKeys = null;
    private boolean closed = false;
    private Connection connection;

    public MockStatement(Connection connection) {
        this.connection = connection;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    public MockStatement(Connection connection, int n, int n2) {
        this.connection = connection;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    public MockStatement(Connection connection, int n, int n2, int n3) {
        this.connection = connection;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setResultSetHandler(AbstractResultSetHandler abstractResultSetHandler) {
        this.resultSetHandler = abstractResultSetHandler;
    }

    protected void setResultSets(ResultSet[] resultSetArray) {
        this.currentUpdateCounts = null;
        this.currentResultSets = resultSetArray;
        this.currentResultSetIndex = 0;
        this.currentUpdateCountIndex = 0;
    }

    protected void setUpdateCounts(int[] nArray) {
        this.currentResultSets = null;
        this.currentUpdateCounts = nArray;
        this.currentResultSetIndex = 0;
        this.currentUpdateCountIndex = 0;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        SQLException sQLException = this.resultSetHandler.getSQLException(string);
        if (null != sQLException) {
            throw sQLException;
        }
        this.resultSetHandler.addExecutedStatement(string);
        if (this.resultSetHandler.hasMultipleResultSets(string)) {
            MockResultSet[] mockResultSetArray = this.resultSetHandler.getResultSets(string);
            if (null != mockResultSetArray) {
                return this.cloneAndSetMultipleResultSets(mockResultSetArray);
            }
        } else {
            MockResultSet mockResultSet = this.resultSetHandler.getResultSet(string);
            if (null != mockResultSet) {
                return this.cloneAndSetSingleResultSet(mockResultSet);
            }
        }
        if (this.resultSetHandler.hasMultipleGlobalResultSets()) {
            return this.cloneAndSetMultipleResultSets(this.resultSetHandler.getGlobalResultSets());
        }
        return this.cloneAndSetSingleResultSet(this.resultSetHandler.getGlobalResultSet());
    }

    private MockResultSet cloneAndSetSingleResultSet(MockResultSet mockResultSet) {
        if (null != (mockResultSet = this.cloneResultSet(mockResultSet))) {
            this.resultSetHandler.addReturnedResultSet(mockResultSet);
        }
        this.setResultSets(new MockResultSet[]{mockResultSet});
        this.setLastGeneratedKeysResultSet(null);
        return mockResultSet;
    }

    private MockResultSet cloneAndSetMultipleResultSets(MockResultSet[] mockResultSetArray) {
        if (null != (mockResultSetArray = this.cloneResultSets(mockResultSetArray))) {
            this.resultSetHandler.addReturnedResultSets(mockResultSetArray);
        }
        this.setResultSets(mockResultSetArray);
        this.setLastGeneratedKeysResultSet(null);
        if (null != mockResultSetArray && mockResultSetArray.length > 0) {
            return mockResultSetArray[0];
        }
        return null;
    }

    public int executeUpdate(String string) throws SQLException {
        SQLException sQLException = this.resultSetHandler.getSQLException(string);
        if (null != sQLException) {
            throw sQLException;
        }
        this.resultSetHandler.addExecutedStatement(string);
        if (this.resultSetHandler.hasMultipleUpdateCounts(string)) {
            Object[] objectArray = this.resultSetHandler.getUpdateCounts(string);
            if (null != objectArray) {
                return this.setMultipleUpdateCounts((int[])ArrayUtil.convertToPrimitiveArray(objectArray));
            }
        } else {
            Integer n = this.resultSetHandler.getUpdateCount(string);
            if (null != n) {
                return this.setSingleUpdateCount(n);
            }
        }
        if (this.resultSetHandler.hasMultipleGlobalUpdateCounts()) {
            return this.setMultipleUpdateCounts(this.resultSetHandler.getGlobalUpdateCounts());
        }
        return this.setSingleUpdateCount(this.resultSetHandler.getGlobalUpdateCount());
    }

    private int setSingleUpdateCount(int n) {
        this.setUpdateCounts(new int[]{n});
        this.setLastGeneratedKeysResultSet(null);
        return n;
    }

    private int setMultipleUpdateCounts(int[] nArray) {
        this.setUpdateCounts(nArray);
        this.setLastGeneratedKeysResultSet(null);
        if (null != nArray && nArray.length > 0) {
            return nArray[0];
        }
        return 0;
    }

    public boolean execute(String string) throws SQLException {
        boolean bl = this.isQuery(string);
        if (bl) {
            this.executeQuery(string);
        } else {
            this.executeUpdate(string);
        }
        return bl;
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray = new int[this.batches.size()];
        Throwable throwable = null;
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this.batches.get(i);
            if (this.isQuery(string)) {
                throwable = this.prepareFailedResult(nArray, i, "SQL " + this.batches.get(i) + " in the list of batches returned a ResultSet.", null);
            } else {
                try {
                    nArray[i] = this.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    throwable = this.prepareFailedResult(nArray, i, null, sQLException);
                }
            }
            if (null == throwable || this.resultSetHandler.getContinueProcessingOnBatchFailure()) continue;
            throw throwable;
        }
        if (null != throwable) {
            throw new BatchUpdateException(throwable.getMessage(), ((SQLException)throwable).getSQLState(), ((SQLException)throwable).getErrorCode(), nArray);
        }
        return nArray;
    }

    protected SQLException prepareFailedResult(int[] nArray, int n, String string, SQLException sQLException) {
        nArray[n] = -3;
        if (sQLException instanceof BatchUpdateException) {
            return sQLException;
        }
        int[] nArray2 = (int[])ArrayUtil.truncateArray(nArray, n);
        if (null == sQLException) {
            return new BatchUpdateException(string, nArray2);
        }
        return new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
    }

    public int executeUpdate(String string, int n) throws SQLException {
        int n2 = this.executeUpdate(string);
        this.setGeneratedKeysResultSet(string, n);
        return n2;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.executeUpdate(string, 1);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.executeUpdate(string, 1);
    }

    public boolean execute(String string, int n) throws SQLException {
        boolean bl = this.execute(string);
        this.setGeneratedKeysResultSet(string, n);
        return bl;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.execute(string, 1);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.execute(string, 1);
    }

    private void setGeneratedKeysResultSet(String string, int n) throws SQLException {
        if (1 != n && 2 != n) {
            throw new SQLException("autoGeneratedKeys must be either Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS");
        }
        if (1 == n) {
            this.setLastGeneratedKeysResultSet(this.determineGeneratedKeysResultSet(string));
        } else {
            this.setLastGeneratedKeysResultSet(null);
        }
    }

    protected void setLastGeneratedKeysResultSet(MockResultSet mockResultSet) {
        this.lastGeneratedKeys = mockResultSet;
    }

    protected MockResultSet determineGeneratedKeysResultSet(String string) {
        MockResultSet mockResultSet = this.resultSetHandler.getGeneratedKeys(string);
        if (null != mockResultSet) {
            return mockResultSet;
        }
        return this.resultSetHandler.getGlobalGeneratedKeys();
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    public int getQueryTimeout() throws SQLException {
        return this.querySeconds;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.querySeconds = n;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
        this.cursorName = string;
    }

    protected boolean isQuery(String string) {
        Boolean bl = this.resultSetHandler.getReturnsResultSet(string);
        boolean bl2 = null != bl ? bl : SQLUtil.isSelect(string);
        return bl2;
    }

    public ResultSet getResultSet() throws SQLException {
        if (null == this.currentResultSets) {
            return null;
        }
        if (this.currentResultSetIndex >= this.currentResultSets.length) {
            return null;
        }
        return this.currentResultSets[this.currentResultSetIndex];
    }

    public int getUpdateCount() throws SQLException {
        if (null == this.currentUpdateCounts) {
            return -1;
        }
        if (this.currentUpdateCountIndex >= this.currentUpdateCounts.length) {
            return -1;
        }
        return this.currentUpdateCounts[this.currentUpdateCountIndex];
    }

    public boolean getMoreResults(int n) throws SQLException {
        return this.getMoreResults(n != 2);
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(true);
    }

    private boolean getMoreResults(boolean bl) throws SQLException {
        if (null != this.currentResultSets) {
            if (this.currentResultSetIndex < this.currentResultSets.length) {
                if (null != this.currentResultSets[this.currentResultSetIndex] && bl) {
                    this.currentResultSets[this.currentResultSetIndex].close();
                }
                ++this.currentResultSetIndex;
            }
            return this.currentResultSetIndex < this.currentResultSets.length;
        }
        if (null != this.currentUpdateCounts && this.currentUpdateCountIndex < this.currentUpdateCounts.length) {
            ++this.currentUpdateCountIndex;
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public void addBatch(String string) throws SQLException {
        this.batches.add(string);
    }

    public void clearBatch() throws SQLException {
        this.batches.clear();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (null == this.lastGeneratedKeys) {
            MockResultSet mockResultSet = new MockResultSet("Last statement did not generate any keys");
            mockResultSet.setStatement(this);
            return mockResultSet;
        }
        return this.cloneResultSet(this.lastGeneratedKeys);
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    protected MockResultSet cloneResultSet(MockResultSet mockResultSet) {
        if (null == mockResultSet) {
            return null;
        }
        MockResultSet mockResultSet2 = (MockResultSet)mockResultSet.clone();
        mockResultSet2.setStatement(this);
        return mockResultSet2;
    }

    protected MockResultSet[] cloneResultSets(MockResultSet[] mockResultSetArray) {
        if (null == mockResultSetArray) {
            return null;
        }
        MockResultSet[] mockResultSetArray2 = new MockResultSet[mockResultSetArray.length];
        for (int i = 0; i < mockResultSetArray.length; ++i) {
            if (null == mockResultSetArray[i]) continue;
            mockResultSetArray2[i] = (MockResultSet)mockResultSetArray[i].clone();
            mockResultSetArray2[i].setStatement(this);
        }
        return mockResultSetArray2;
    }
}

