/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.jms.GenericTransmissionManager;
import com.mockrunner.jms.QueueTransmissionManager;
import com.mockrunner.jms.TopicTransmissionManager;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockMessageProducer;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockTopicPublisher;
import java.util.ArrayList;
import java.util.List;

public class TransmissionManagerWrapper {
    private QueueTransmissionManager queueManager;
    private TopicTransmissionManager topicManager;
    private GenericTransmissionManager genericManager;

    public TransmissionManagerWrapper(QueueTransmissionManager queueTransmissionManager, TopicTransmissionManager topicTransmissionManager, GenericTransmissionManager genericTransmissionManager) {
        this.queueManager = queueTransmissionManager;
        this.topicManager = topicTransmissionManager;
        this.genericManager = genericTransmissionManager;
    }

    public QueueTransmissionManager getQueueTransmissionManager() {
        return this.queueManager;
    }

    public TopicTransmissionManager getTopicTransmissionManager() {
        return this.topicManager;
    }

    public GenericTransmissionManager getGenericTransmissionManager() {
        return this.genericManager;
    }

    public MockMessageProducer getMessageProducer(int n) {
        List list = this.getMessageProducerList();
        if (list.size() <= n || n < 0) {
            return null;
        }
        return (MockMessageProducer)list.get(n);
    }

    public List getMessageProducerList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.queueManager.getQueueSenderList());
        arrayList.addAll(this.topicManager.getTopicPublisherList());
        arrayList.addAll(this.genericManager.getMessageProducerList());
        return arrayList;
    }

    public List getQueueSenderList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.queueManager.getQueueSenderList());
        List list = this.genericManager.getMessageProducerList();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof MockQueueSender)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public MockQueueSender getQueueSender(int n) {
        List list = this.getQueueSenderList();
        if (list.size() <= n || n < 0) {
            return null;
        }
        return (MockQueueSender)list.get(n);
    }

    public List getTopicPublisherList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.topicManager.getTopicPublisherList());
        List list = this.genericManager.getMessageProducerList();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof MockTopicPublisher)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public MockTopicPublisher getTopicPublisher(int n) {
        List list = this.getTopicPublisherList();
        if (list.size() <= n || n < 0) {
            return null;
        }
        return (MockTopicPublisher)list.get(n);
    }

    public MockMessageConsumer getMessageConsumer(int n) {
        List list = this.getMessageConsumerList();
        if (list.size() <= n || n < 0) {
            return null;
        }
        return (MockMessageConsumer)list.get(n);
    }

    public List getMessageConsumerList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.queueManager.getQueueReceiverList());
        arrayList.addAll(this.topicManager.getTopicSubscriberList());
        arrayList.addAll(this.topicManager.getDurableTopicSubscriberMap().values());
        return arrayList;
    }
}

