/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import jp.terasoluna.fw.ex.unit.common.DefaultProperties;
import jp.terasoluna.fw.ex.unit.common.PropertyKeys;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.mock.jndi.SimpleNamingContextBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiUtils {
    private static final String RESOURCE = "Resource";
    private static final String CONTEXT_RESOURCE_EXP = "//Context/Resource";

    protected static List<NamedNodeMap> getDataSourceAttributesList(String contextPath) {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream input = loader.getResourceAsStream(contextPath);
            Document doc = null;
            doc = input != null ? builder.parse(input) : builder.parse(contextPath);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(CONTEXT_RESOURCE_EXP);
            Node node = (Node)expr.evaluate(doc, XPathConstants.NODE);
            ArrayList<NamedNodeMap> result = new ArrayList<NamedNodeMap>();
            while (node != null) {
                if (RESOURCE.equals(node.getNodeName())) {
                    result.add(node.getAttributes());
                }
                node = node.getNextSibling();
            }
            return result;
        }
        catch (Exception e) {
            throw new UTRuntimeException(e);
        }
    }

    public static DataSource getDataSource(String name) {
        Hashtable table = (Hashtable)ReflectionUtils.getField(SimpleNamingContextBuilder.getCurrentContextBuilder(), "boundObjects");
        return (DataSource)table.get(name);
    }

    public static void activateDefaultNamingContext() {
        String contextPath = String.format("%s/%s/%s", DefaultProperties.getValue(PropertyKeys.WEBAPP_PATH), DefaultProperties.getValue(PropertyKeys.METAINF_DIR), DefaultProperties.getValue(PropertyKeys.CONTEXT_FILE));
        JndiUtils.activateNamingContext(contextPath);
    }

    public static void activateNamingContext(String name, String driverClassName, String username, String password, String url) {
        DriverManagerDataSource ds = new DriverManagerDataSource(url, username, password);
        ds.setDriverClassName(driverClassName);
        JndiUtils.activateNamingContext(name, (DataSource)ds);
    }

    private static String getNodeValue(NamedNodeMap attributes, String name) {
        Node node = attributes.getNamedItem(name);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static void activateNamingContext(String contextPath) {
        List<NamedNodeMap> attributesList = JndiUtils.getDataSourceAttributesList(contextPath);
        for (NamedNodeMap attributes : attributesList) {
            String name = JndiUtils.getNodeValue(attributes, "name");
            String driverClassName = JndiUtils.getNodeValue(attributes, "driverClassName");
            String username = JndiUtils.getNodeValue(attributes, "username");
            String password = JndiUtils.getNodeValue(attributes, "password");
            String url = JndiUtils.getNodeValue(attributes, "url");
            JndiUtils.activateNamingContext(name, driverClassName, username, password, url);
        }
    }

    public static void activateNamingContext(String name, DataSource ds) {
        try {
            SimpleNamingContextBuilder builder = SimpleNamingContextBuilder.getCurrentContextBuilder();
            if (builder == null) {
                builder = SimpleNamingContextBuilder.emptyActivatedContextBuilder();
            }
            builder.bind(name, (Object)ds);
            String prefixForTomcat = "java:comp/env/";
            if (name.startsWith(prefixForTomcat)) {
                builder.bind(name.substring(prefixForTomcat.length()), (Object)ds);
            } else {
                builder.bind(String.valueOf(prefixForTomcat) + name, (Object)ds);
            }
        }
        catch (Exception e) {
            throw new UTRuntimeException(e);
        }
    }
}

