/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.controllerex.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload.AbstractFileDownloadView;
import jp.terasoluna.rich.functionsample.controllerex.bean.ControllerExFileData;

/**
 * Rg[g̃t@C_E[hr[NX
 *
 */
public class ControllerExFileView extends AbstractFileDownloadView {
    /**
     * _E[hp̃Reg^Cv(<code>application/octetstream</code>)
     */
    public static final String CONTENT_TYPE = "application/octet-stream";
    
    /**
     * X|Xɐݒ肷ARec^CṽL[B
     */
    protected String contentTypeKey = "Content-Disposition";
    
    /**
     * X|Xɐݒ肷ARec^CṽvtBbNXB
     */
    protected String contentTypePrefix = "attachments;filename=";
    
    /**
     * ̓Xg[擾B
     * _E[hΏۂ̃\[X擾B
     * t@CpXŕ\郊\[X擾B
     * t@Cݒ肳ĂȂꍇAOB
     * @param model ƖWbŇʁB
     * @param request HTTPNGXgB
     * @return ̓Xg[B
     * @throws IOException o͗OB
     */
    @Override
    protected final InputStream getInputStream(
            Map model, HttpServletRequest request) throws IOException {
        
        // \[X擾
        //Resource resource = getResource(getFileDownloadModel(model), request);
        
    	ControllerExFileData responseData = getFileDownloadModel(model);
    	
        if (responseData == null) {
            throw new IllegalArgumentException(
                    "FileResponseOutputData is null!");
        }
        
        if (responseData.getDirectoryName() == null) {
            throw new IllegalArgumentException("DirectoryName is Empty.");
        }
        
        if (!StringUtils.hasText(responseData.getFileName())) {
            throw new IllegalArgumentException("FileName is Empty.");
        }
        
        // t@CpX
        String location = responseData.getDirectoryName() + File.separator
            + responseData.getFileName(); 

    	
        try {
            //return resource.getInputStream();
        	return new FileInputStream(location);
        } catch (IOException e) {
            throw e;
        }
    }

    /**
     * fIuWFNgFileDownloadModelCX^X擾B
     * @param model ƖWbŇʁB
     * @return ControllerExFileDataNX
     */
    protected ControllerExFileData getFileDownloadModel(Map model) {
        Object result = model.get(Constants.RESULT_KEY);
        if (result == null) {
            throw new IllegalStateException(
                    "FileResponseOutputData Object is Null.");
        }
        
        // {NXgpꍇAƖWbNɂFileDownloadModelԂȂĂ͂ȂȂB
        if (!(result instanceof ControllerExFileData)) {
            throw new IllegalArgumentException(
                    "FileDownloadView must use FileResponseOutputData class!");
        }
        return (ControllerExFileData) result;
    }

    /**
     * X|Xwb_ǉB
     * @param model ƖWbŇʁB
     * @param request HTTPNGXgB
     * @param response HTTPX|XB
     */
    @Override
    protected final void addResponseHeader(Map model, 
            HttpServletRequest request, HttpServletResponse response) {
        
        response.setContentType(CONTENT_TYPE);
        
        // X|Xwb_ɐݒ肷L[ƒl̃Zbg擾
        Map<String, String> headerMap = 
            createResponseHeaderMap(getFileDownloadModel(model), request);
        
        for (String key : headerMap.keySet()) {
            response.addHeader(key, headerMap.get(key));
        }
    }
    
    /**
     * X|Xwb_ɒǉL[ƒlAMap`ō쐬B
     * @param fdlModel ƖWbNɂĕԂFileDownloadModelCX^XB
     * @param request HTTPNGXgB
     * @return X|Xwb_ɒǉL[ƒlMapB
     */
    protected Map<String, String> createResponseHeaderMap(
            ControllerExFileData fdlModel, HttpServletRequest request) {
        Map<String, String> headerMap = new HashMap<String, String>();
        
        // Rec^Cv
        headerMap.put(contentTypeKey, 
                contentTypePrefix + fdlModel.getFileName());
        return headerMap;
    }
}
