/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.bind.creator;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

/**
 * NG`̃NGXgf[^ɑΉServletRequestDataBinderNXԋpB
 * 
 * <p>
 * Springɒ`ĂServletRequestDataBinderNXƂĕԋpB
 * </p>
 * 
 * <p>
 * }`p[g`Œ`ꂽNGXgf[^ɂΉĂB
 * </p>
 * 
 * <p>
 * {NX̎gp@́A{@link jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController}QƂ邱ƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController
 * @see org.springframework.web.bind.ServletRequestDataBinder
 * 
 */
public class QueryServletRequestDataBinderCreator implements
        ServletRequestDataBinderCreator {

    /**
     * NG`̃NGXgf[^ɑΉServletRequestDataBinderNXԋpB
     * 
     * <p>
     * }`p[g`̃NGXgf[^oCgzɕϊ邱Ƃ\ɂvpeBGfB^ݒ肷B
     * </p>
     * 
     * @param request NG`̃NGXg
     * @param command R}hIuWFNg
     * @param requestName NGXg
     * @return Springɒ`ĂServletRequestDataBinder
     */
    public ServletRequestDataBinder create(HttpServletRequest request,
            Object command, String requestName) {
        // NG`̃NGXgf[^ɑΉServletRequestDataBinderNX𐶐B
        ServletRequestDataBinder binder = new ServletRequestDataBinder(command,
                requestName);
        // ServletRequestDataBinderNXɁA
        // }`p[g`̃NGXgf[^oCgzɕϊ邱Ƃ\ɂvpeBGfB^𐶐
        binder.registerCustomEditor(byte[].class,
                new ByteArrayMultipartFileEditor());
        return binder;
    }

}
