/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.XMLSqlSource;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.config.MappedStatementConfig;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.util.Properties;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlStatementParser {
    private XmlParserState state;

    public SqlStatementParser(XmlParserState config) {
        this.state = config;
    }

    public void parseGeneralStatement(Node node, MappedStatement statement) {
        Properties attributes = NodeletUtils.parseAttributes(node, this.state.getGlobalProps());
        String id = attributes.getProperty("id");
        String parameterMapName = this.state.applyNamespace(attributes.getProperty("parameterMap"));
        String parameterClassName = attributes.getProperty("parameterClass");
        String resultMapName = attributes.getProperty("resultMap");
        String resultClassName = attributes.getProperty("resultClass");
        String cacheModelName = this.state.applyNamespace(attributes.getProperty("cacheModel"));
        String xmlResultName = attributes.getProperty("xmlResultName");
        String resultSetType = attributes.getProperty("resultSetType");
        String fetchSize = attributes.getProperty("fetchSize");
        String allowRemapping = attributes.getProperty("remapResults");
        String timeout = attributes.getProperty("timeout");
        if (this.state.isUseStatementNamespaces()) {
            id = this.state.applyNamespace(id);
        }
        String[] additionalResultMapNames = null;
        if (resultMapName != null) {
            additionalResultMapNames = this.state.getAllButFirstToken(resultMapName);
            resultMapName = this.state.getFirstToken(resultMapName);
            resultMapName = this.state.applyNamespace(resultMapName);
            for (int i = 0; i < additionalResultMapNames.length; ++i) {
                additionalResultMapNames[i] = this.state.applyNamespace(additionalResultMapNames[i]);
            }
        }
        String[] additionalResultClassNames = null;
        if (resultClassName != null) {
            additionalResultClassNames = this.state.getAllButFirstToken(resultClassName);
            resultClassName = this.state.getFirstToken(resultClassName);
        }
        Class[] additionalResultClasses = null;
        if (additionalResultClassNames != null) {
            additionalResultClasses = new Class[additionalResultClassNames.length];
            for (int i = 0; i < additionalResultClassNames.length; ++i) {
                additionalResultClasses[i] = this.resolveClass(additionalResultClassNames[i]);
            }
        }
        this.state.getConfig().getErrorContext().setMoreInfo("Check the parameter class.");
        Class parameterClass = this.resolveClass(parameterClassName);
        this.state.getConfig().getErrorContext().setMoreInfo("Check the result class.");
        Class resultClass = this.resolveClass(resultClassName);
        Integer timeoutInt = timeout == null ? null : new Integer(timeout);
        Integer fetchSizeInt = fetchSize == null ? null : new Integer(fetchSize);
        boolean allowRemappingBool = "true".equals(allowRemapping);
        MappedStatementConfig statementConf = this.state.getConfig().newMappedStatementConfig(id, statement, new XMLSqlSource(this.state, node), parameterMapName, parameterClass, resultMapName, additionalResultMapNames, resultClass, additionalResultClasses, resultSetType, fetchSizeInt, allowRemappingBool, timeoutInt, cacheModelName, xmlResultName);
        this.findAndParseSelectKey(node, statementConf);
    }

    private Class resolveClass(String resultClassName) {
        try {
            if (resultClassName != null) {
                return Resources.classForName(this.state.getConfig().getTypeHandlerFactory().resolveAlias(resultClassName));
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new SqlMapException("Error.  Could not initialize class.  Cause: " + e, e);
        }
    }

    private void findAndParseSelectKey(Node node, MappedStatementConfig config) {
        this.state.getConfig().getErrorContext().setActivity("parsing select key tags");
        boolean foundSQLFirst = false;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                String data = ((CharacterData)child).getData();
                if (data.trim().length() <= 0) continue;
                foundSQLFirst = true;
                continue;
            }
            if (child.getNodeType() != 1 || !"selectKey".equals(child.getNodeName())) continue;
            Properties attributes = NodeletUtils.parseAttributes(child, this.state.getGlobalProps());
            String keyPropName = attributes.getProperty("keyProperty");
            String resultClassName = attributes.getProperty("resultClass");
            String type = attributes.getProperty("type");
            config.setSelectKeyStatement(new XMLSqlSource(this.state, child), resultClassName, keyPropName, foundSQLFirst, type);
            break;
        }
        this.state.getConfig().getErrorContext().setMoreInfo(null);
    }
}

