/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegator;
import jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegatorImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMappingExceptionResolverEx
extends SimpleMappingExceptionResolver
implements InitializingBean {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Map<String, Object> linkedExceptionMappings = null;
    protected Set mappedHandlers = null;
    protected Integer defaultStatusCode = null;
    protected String defaultErrorView = null;
    protected Class<? extends ExceptionResolveDelegator> exceptionResolveDelegatorClass = ExceptionResolveDelegatorImpl.class;
    protected LinkedHashMap<String, ExceptionResolveDelegator> exceptionResolveDelegatorMap = new LinkedHashMap();
    protected Map<String, String> exceptionResolveDelegatorParams = null;
    protected boolean outputErrorLogHandledException = true;

    public void afterPropertiesSet() {
        if (this.linkedExceptionMappings == null) {
            return;
        }
        if (this.exceptionResolveDelegatorClass == null) {
            String message = "SimpleMappingExceptionResolverEx must be set exceptionResolveDelegatorClass. Check Spring Bean definition file.";
            this.log.error((Object)message);
            throw new IllegalStateException(message);
        }
        for (String mappingKey : this.linkedExceptionMappings.keySet()) {
            ExceptionResolveDelegator exceptionResolveDelegator = null;
            try {
                if (!ExceptionResolveDelegator.class.isAssignableFrom(this.exceptionResolveDelegatorClass)) {
                    String message = this.exceptionResolveDelegatorClass.getName() + " is not ExceptionResolveDelegator type. " + "Check Spring Bean definition file.";
                    this.log.error((Object)message);
                    throw new IllegalStateException(message);
                }
                exceptionResolveDelegator = this.exceptionResolveDelegatorClass.newInstance();
            }
            catch (InstantiationException e) {
                String message = this.exceptionResolveDelegatorClass.getName() + " cannot be instantiated. " + "Check Spring Bean definition file.";
                this.log.error((Object)message, (Throwable)e);
                throw new IllegalStateException(message, e);
            }
            catch (IllegalAccessException e) {
                String message = this.exceptionResolveDelegatorClass.getName() + " cannot be instantiated. " + "Check Spring Bean definition file.";
                this.log.error((Object)message, (Throwable)e);
                throw new IllegalStateException(message, e);
            }
            exceptionResolveDelegator.initMapping(mappingKey, this.linkedExceptionMappings.get(mappingKey), this.exceptionResolveDelegatorParams);
            this.exceptionResolveDelegatorMap.put(mappingKey, exceptionResolveDelegator);
        }
    }

    public void setDefaultErrorView(String defaultErrorView) {
        super.setDefaultErrorView(defaultErrorView);
        this.defaultErrorView = defaultErrorView;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Default error view is '" + this.defaultErrorView + "'"));
        }
    }

    public void setExceptionResolveDelegatorClass(Class<? extends ExceptionResolveDelegator> exceptionResolveDelegatorClass) {
        this.exceptionResolveDelegatorClass = exceptionResolveDelegatorClass;
    }

    public void setExceptionResolveDelegatorParams(Map<String, String> exceptionResolveDelegatorParams) {
        this.exceptionResolveDelegatorParams = exceptionResolveDelegatorParams;
    }

    public void setMappedHandlers(Set mappedHandlers) {
        super.setMappedHandlers(mappedHandlers);
        this.mappedHandlers = mappedHandlers;
    }

    public void setDefaultStatusCode(int defaultStatusCode) {
        super.setDefaultStatusCode(defaultStatusCode);
        this.defaultStatusCode = defaultStatusCode;
    }

    @Deprecated
    public void setExceptionMappings(Properties mappings) {
        throw new UnsupportedOperationException();
    }

    public void setLinkedExceptionMappings(Map<String, Object> linkedExceptionMappings) {
        this.linkedExceptionMappings = linkedExceptionMappings;
    }

    public void setOutputErrorLogHandledException(boolean outputErrorLogHandledException) {
        this.outputErrorLogHandledException = outputErrorLogHandledException;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.mappedHandlers != null && !this.mappedHandlers.contains(handler)) {
            return null;
        }
        ExceptionResolveDelegator exceptionResolveDelegator = null;
        for (String mappingKey : this.exceptionResolveDelegatorMap.keySet()) {
            int depth = this.getDepth(mappingKey, ex);
            if (depth < 0) continue;
            exceptionResolveDelegator = this.exceptionResolveDelegatorMap.get(mappingKey);
            break;
        }
        if (exceptionResolveDelegator == null) {
            return null;
        }
        String viewName = exceptionResolveDelegator.getViewName();
        if (viewName == null && this.defaultErrorView != null) {
            viewName = this.defaultErrorView;
        }
        if (viewName != null) {
            if (this.outputErrorLogHandledException) {
                this.log.error((Object)"Handled the following exception.", (Throwable)ex);
            }
            if (this.defaultStatusCode != null) {
                response.setStatus(this.defaultStatusCode.intValue());
            }
            exceptionResolveDelegator.setHeader(response);
            ModelAndView mv = this.getModelAndView(viewName, ex);
            exceptionResolveDelegator.addObjectToModel(mv);
            return mv;
        }
        return null;
    }
}

