// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Validation;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.WebUT.Validation
{
    /// <summary>
    ///TERASOLUNA.Fw.Web.Validation.ValidationInfoAttribute のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Web.Validation.ValidationInfoAttribute 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ValidationInfoAttributeTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値を空文字以外の文字列とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestValidationFilePath01()
        {
            ValidationInfoAttribute target = new ValidationInfoAttribute();

            string val = "AAA.xsd";

            target.ValidationFilePath = val;

            Assert.AreEqual(val, target.ValidationFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値を空文字とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestValidationFilePath02()
        {
            ValidationInfoAttribute target = new ValidationInfoAttribute();

            string val = "";

            target.ValidationFilePath = val;

            Assert.AreEqual(val, target.ValidationFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値をnullとすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestValidationFilePath03()
        {
            ValidationInfoAttribute target = new ValidationInfoAttribute();

            string val = null;

            target.ValidationFilePath = val;

            Assert.AreEqual(val, target.ValidationFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値を空文字以外の文字列とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRuleSet04()
        {
            ValidationInfoAttribute target = new ValidationInfoAttribute();

            string val = "TERASOLUNA";

            target.RuleSet = val;

            Assert.AreEqual(val, target.RuleSet);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値を空文字とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRuleSet05()
        {
            ValidationInfoAttribute target = new ValidationInfoAttribute();

            string val = "";

            target.RuleSet = val;

            Assert.AreEqual(val, target.RuleSet);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///RuleSet のテスト
        ///</summary>
        /// <TestTarget>RuleSet</TestTarget>
        /// <TestCondition>設定する値をnullとすること</TestCondition>
        /// <TestAssertion>RuleSetプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRuleSet06()
        {
            ValidationInfoAttribute target = new ValidationInfoAttribute();

            string val = null;

            target.RuleSet = val;

            Assert.AreEqual(val, target.RuleSet);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値を空文字以外の文字列とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestValidationFilePath07()
        {
            string validationFilePath = "TERASOLUNA.xsd";

            ValidationInfoAttribute target = new ValidationInfoAttribute(validationFilePath);

            string val = "TERASOLUNA.xsd";

            target.ValidationFilePath = val;

            Assert.AreEqual(val, target.ValidationFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値を空文字とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestValidationFilePath08()
        {
            string validationFilePath = "TERASOLUNA.xsd";

            ValidationInfoAttribute target = new ValidationInfoAttribute(validationFilePath);

            string val = "";

            target.ValidationFilePath = val;

            Assert.AreEqual(val, target.ValidationFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///ValidationFilePath のテスト
        ///</summary>
        /// <TestTarget>ValidationFilePath</TestTarget>
        /// <TestCondition>設定する値をnullとすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestValidationFilePath09()
        {
            string validationFilePath = "TERASOLUNA.xsd";

            ValidationInfoAttribute target = new ValidationInfoAttribute(validationFilePath);

            string val = null;

            target.ValidationFilePath = val;

            Assert.AreEqual(val, target.ValidationFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///RuleSet のテスト
        ///</summary>
        /// <TestTarget>RuleSet</TestTarget>
        /// <TestCondition>設定する値を空文字以外の文字列とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRuleSet10()
        {
            string validationFilePath = "TERASOLUNA.xsd";

            ValidationInfoAttribute target = new ValidationInfoAttribute(validationFilePath);

            string val = "TERASOLUNA";

            target.RuleSet = val;

            Assert.AreEqual(val, target.RuleSet);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///RuleSet のテスト
        ///</summary>
        /// <TestTarget>RuleSet</TestTarget>
        /// <TestCondition>設定する値を空文字とすること</TestCondition>
        /// <TestAssertion>ValidationFilePathプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRuleSet11()
        {
            string validationFilePath = "TERASOLUNA.xsd";

            ValidationInfoAttribute target = new ValidationInfoAttribute(validationFilePath);

            string val = "";

            target.RuleSet = val;

            Assert.AreEqual(val, target.RuleSet);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

        /// <summary>
        ///RuleSet のテスト
        ///</summary>
        /// <TestTarget>RuleSet</TestTarget>
        /// <TestCondition>設定する値をnullとすること</TestCondition>
        /// <TestAssertion>RuleSetプロパティに設定した値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestRuleSet12()
        {
            string validationFilePath = "TERASOLUNA.xsd";

            ValidationInfoAttribute target = new ValidationInfoAttribute(validationFilePath);

            string val = null;

            target.RuleSet = val;

            Assert.AreEqual(val, target.RuleSet);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationInfoAttribute), LogLevel.INFO));
        }

    }
}
