// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.Page;
using System.Configuration;
using TERASOLUNA.Fw.WebUT;
using TERASOLUNA.Fw.Web.Configuration.Sql;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.Reflection;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.WebUT.Configuration.Page
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Configuration.PagesCollection のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Configuration.PagesCollection 単体テストをここに含めます
    ///</summary>

    [TestClass()]
    public class PagesCollectionTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///PagesCollection () のテスト
        ///</summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor()
        {
            PagesCollection target = new PagesCollection();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///Add (ConfigurationElement) のテスト
        ///</summary>
        /// <TestTarget>Add()</TestTarget>
        /// <TestCondition>PageElement型インスタンスを引数に指定すること</TestCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        [TestMethod()]
        public void TestAdd01()
        {
            PagesCollection target = new PagesCollection();

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///Add (ConfigurationElement) のテスト
        ///</summary>
        /// <TestTarget>Add()</TestTarget>
        /// <TestCondition>nullを引数に指定すること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestAdd02()
        {
            try
            {
                PagesCollection target = new PagesCollection();
                target.Add(null);
                Assert.Fail("到達してはいけないコードです。");
            }

            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("element", e.ParamName);
            }
            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PagesCollection), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "element"));
        }

        /// <summary>
        ///CollectionType のテスト
        ///</summary>
        /// <TestTarget>CollectionType()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>ConfigurationElementCollectionType.BasicMapが返却されること</TestAssertion>
        [TestMethod()]
        public void TestCollectionType()
        {
            PagesCollection target = new PagesCollection();
            Assert.AreEqual(ConfigurationElementCollectionType.BasicMap, target.CollectionType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///CreateNewElement のテスト
        ///</summary>
        /// <TestTarget>CreateNewElement()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>PageElement型インスタンスが返却されること</TestAssertion>
        [TestMethod()]
        public void TestCreateNewElement01()
        {
            PagesCollection target = new PagesCollection();
            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor(target);

            Assert.IsInstanceOfType(accessor.CreateNewElement(), typeof(PageElement));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///GetElementKey(PageElement) のテスト
        ///</summary>
        /// <TestTarget>GetElementKey()</TestTarget>
        /// <TestCondition>PageElement型インスタンスを引数に指定すること</TestCondition>
        /// <TestAssertion>PageElementのNameに設定した値が返却されること</TestAssertion>
        [TestMethod()]
        public void TestGetElementKey01()
        {
            PagesCollection target = new PagesCollection();
            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor(target);

            PageElement pe = new PageElement("Test", "testPath", "on", "on", "on", "testStatement");
            object ret = accessor.GetElementKey(pe);
            Assert.AreEqual("Test", ret.ToString());

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///GetElementKey(PageElement) のテスト
        ///</summary>
        /// <TestTarget>GetElementKey()</TestTarget>
        /// <TestCondition>PageElement型でないインスタンスを引数に指定すること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestGetElementKey02()
        {
            try
            {
                PagesCollection target = new PagesCollection();
                TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor(target);

                SqlElement se = new SqlElement("Test", "testStatement");
                object ret = accessor.GetElementKey(se);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException ex)
            {
                // 成功
                //ArgumentException exception = ex.InnerException as ArgumentException;
                Assert.IsInstanceOfType(ex, typeof(ArgumentException));
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_TYPE", "element"), ex.Message);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PagesCollection), typeof(ArgumentException), "E_INVALID_TYPE", "element"));
        }

        /// <summary>
        ///GetElementKey(PageElement) のテスト
        ///</summary>
        /// <TestTarget>GetElementKey()</TestTarget>
        /// <TestCondition>nullを引数に指定すること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestGetElementKey03()
        {
            try
            {
                PagesCollection target = new PagesCollection();
                TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor(target);

                PageElement pe = null;
                object ret = accessor.GetElementKey(pe);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException ex)
            {
                // 成功
                //ArgumentNullException exception = ex.InnerException as ArgumentNullException;
                Assert.AreEqual("element", ex.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PagesCollection), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "element"));
        }

        /// <summary>
        ///this[int index] のテスト
        ///</summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>indexに指定したPageElementが返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem01()
        {
            PagesCollection target = new PagesCollection();

            PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
            PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
            PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
            target.Add(val1);
            target.Add(val2);
            target.Add(val3);

            Assert.AreEqual(val1, target[0]);
            Assert.AreEqual(val2, target[1]);
            Assert.AreEqual(val3, target[2]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///this[string name] のテスト
        /// </summary>
        /// <TestTarget>this[string name]</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>nameに指定したPageElementが返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem02()
        {
            PagesCollection target = new PagesCollection();

            PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
            PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
            PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
            target.Add(val1);
            target.Add(val2);
            target.Add(val3);

            Assert.AreEqual(val1, target["XXX_001"]);
            Assert.AreEqual(val2, target["XXX_002"]);
            Assert.AreEqual(val3, target["YYY_003"]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///this[int index] のテスト
        ///</summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition>-1を指定すること</TestCondition>
        /// <TestAssertion>IndexOutOfRangeExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestItem03()
        {
            try
            {
                PagesCollection target = new PagesCollection();

                PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
                PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
                PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
                target.Add(val1);
                target.Add(val2);
                target.Add(val3);

                PageElement element = target[-1];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                Assert.AreEqual("インデックス -1 が範囲を超えています。", e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///this[int index] のテスト
        ///</summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition>要素数より1大きい値を指定すること</TestCondition>
        /// <TestAssertion>IndexOutOfRangeExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestItem04()
        {
            try
            {
                PagesCollection target = new PagesCollection();

                PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
                PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
                PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
                target.Add(val1);
                target.Add(val2);
                target.Add(val3);

                PageElement element = target[3];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                Assert.AreEqual("インデックス 3 が範囲を超えています。", e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///this[string name] のテスト
        /// </summary>
        /// <TestTarget>this[string name]</TestTarget>
        /// <TestCondition>空文字を指定する</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem05()
        {
            PagesCollection target = new PagesCollection();

            PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
            PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
            PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
            target.Add(val1);
            target.Add(val2);
            target.Add(val3);

            Assert.AreEqual(null, target[""]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///this[string name] のテスト
        /// </summary>
        /// <TestTarget>this[string name]</TestTarget>
        /// <TestCondition>nullを指定する</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem06()
        {
            try
            {
                PagesCollection target = new PagesCollection();

                PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
                PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
                PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
                target.Add(val1);
                target.Add(val2);
                target.Add(val3);

                PageElement element = target[null];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (NullReferenceException e)
            {
                // 成功
                Assert.AreEqual("オブジェクト参照がオブジェクト インスタンスに設定されていません。", e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///this[string name] のテスト
        /// </summary>
        /// <TestTarget>this[string name]</TestTarget>
        /// <TestCondition>不正な文字列を指定すること</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem07()
        {
            PagesCollection target = new PagesCollection();

            PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
            PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
            PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
            target.Add(val1);
            target.Add(val2);
            target.Add(val3);

            Assert.AreEqual(null, target["invalid"]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///Count のテスト
        ///</summary>
        ///<TestTarget>Count</TestTarget>
        ///<TestCondition>AddメソッドでPageElementを追加すること</TestCondition>
        ///<TestAssertion>追加した要素数が返却されること</TestAssertion>
        [TestMethod()]
        public void TestCount01()
        {
            PagesCollection target = new PagesCollection();

            PageElement val1 = new PageElement("XXX_001", "/XXX001.aspx", "on", "off", "off", "");
            PageElement val2 = new PageElement("XXX_002", "/XXX001.aspx", "off", "on", "off", "");
            PageElement val3 = new PageElement("YYY_003", "/XXX/YYY001.aspx", "off", "off", "on", "");
            target.Add(val1);
            target.Add(val2);
            target.Add(val3);

            Assert.AreEqual(3, target.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///Count のテスト
        ///</summary>
        ///<TestTarget>Count</TestTarget>
        ///<TestCondition>AddメソッドでPageElementを追加しないこと</TestCondition>
        ///<TestAssertion>0が返却されること</TestAssertion>
        [TestMethod()]
        public void TestCount02()
        {
            PagesCollection target = new PagesCollection();

            Assert.AreEqual(0, target.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        ///IsReadOnly () のテスト
        ///</summary>
        /// <TestTarget>IsReadOnly()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        public void TestIsReadOnly01()
        {
            PagesCollection target = new PagesCollection();
            Assert.IsFalse(target.IsReadOnly());

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// ElementName のテスト
        ///</summary>
        /// <TestTarget>ElementName</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>"page"が返却されること</TestAssertion>
        [TestMethod()]
        public void TestElementName01()
        {
            PagesCollection target = new PagesCollection();
            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Configuration_Page_PagesCollectionAccessor(target);
            string ret = accessor.ElementName;
            Assert.AreEqual("page", ret);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PagesCollection), LogLevel.INFO));
        }
    }
}
