// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.ExceptionTransition;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.WebUT.Configuration.ExceptionTransition
{
    /// <summary>
    /// TERASOLUNA.Fw.Configuration.ExceptionTransitionConfiguration のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Configuration.ExceptionTransitionConfiguration 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class ExceptionTransitionConfigurationTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// GetNextPage (Type) のテスト
        /// </summary>
        /// <TestTarget>GetNextPage (Type)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に設定ファイルに存在する例外が指定されていること
        /// </TestCondition>
        /// <TestAssertion>引数に対応するnextPage属性の設定情報が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        public void TestGetNextPage01()
        {
            Type type = typeof(ArgumentException);

            string expected = "Error1";
            string actual;

            actual = ExceptionTransitionConfiguration.GetNextPage(type);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetNextPage (Type) のテスト
        /// </summary>
        /// <TestTarget>GetNextPage (Type)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に設定ファイルに存在しない例外が指定されていること
        /// </TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        public void TestGetNextPage02()
        {
            Type type = typeof(InvalidOperationException);

            string actual;

            actual = ExceptionTransitionConfiguration.GetNextPage(type);

            Assert.IsNull(actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetNextPage (Type) のテスト
        /// </summary>
        /// <TestTarget>GetNextPage (Type)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数にnullが指定されていること
        /// </TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        public void TestGetNextPage03()
        {
            Type type = null;
            string actual;

            try
            {
                actual = ExceptionTransitionConfiguration.GetNextPage(type);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("type", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                   typeof(ExceptionTransitionConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "type"));
        }

        /// <summary>
        /// GetNextPage (Type) のテスト
        /// </summary>
        /// <TestTarget>GetNextPage (Type)</TestTarget>
        /// <TestCondition>一致したexceptionTypeのnextPageが空文字設定の場合</TestCondition>
        /// <TestAssertion></TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        public void TestGetNextPage04()
        {
            Type type = typeof(InvalidCastException);
            string expected = "";
            string actual;

            actual = ExceptionTransitionConfiguration.GetNextPage(type);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetNextPage (Type) のテスト
        /// </summary>
        /// <TestTarget>GetNextPage (Type)</TestTarget>
        /// <TestCondition>exceptionTypeが空文字設定の場合</TestCondition>
        /// <TestAssertion>例外が発生しないこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        public void TestGetNextPage05()
        {
            Type type = typeof(InvalidOperationException);

            string actual;

            actual = ExceptionTransitionConfiguration.GetNextPage(type);

            Assert.IsNull(actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfiguration), LogLevel.INFO));
        }
    }
}
