// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections;
using System.Collections.Generic;
using System.Web.SessionState;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Session
{
    /// <summary>
    /// ZbṼCtTCNxǗ܂B
    /// </summary>
    public class SessionManager
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(SessionManager));

        /// <summary>
        /// xǗ}X^ZbVɓo^Ƃ̃ZbV L[łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "SESSION_MANAGER_LEVEL_MASTER" łB
        /// </remarks>
        public static readonly string SESSION_MANAGER_LEVEL_MASTER = "SESSION_MANAGER_LEVEL_MASTER";

        /// <summary>
        /// L[Ǘ}X^ZbVɓo^Ƃ̃ZbV L[łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "SESSION_MANAGER_KEY_MASTER" łB
        /// </remarks>
        public static readonly string SESSION_MANAGER_KEY_MASTER = "SESSION_MANAGER_KEY_MASTER";

        /// <summary>
        /// ZbVłB
        /// </summary>
        private HttpSessionState _session = null;

        /// <summary>
        /// pIuWFNgłB
        /// </summary>
        private static object _syncRoot = new Object();

        /// <summary>
        /// <see cref="HttpSessionState"/> 擾܂B
        /// </summary>
        protected virtual HttpSessionState Session
        {
            get { return _session; }
        }

        /// <summary>
        /// xǗ}X^ZbV擾܂B
        /// </summary>
        /// <value>CtTCN xƂ̍ڂǗ邽߂̃xǗ}X^B</value>
        protected virtual IDictionary<int, IList<string>> LevelMaster
        {
            get
            {
                if (Session[SESSION_MANAGER_LEVEL_MASTER] == null)
                {
                    lock (_syncRoot)
                    {
                        if (Session[SESSION_MANAGER_LEVEL_MASTER] == null)
                        {
                            Session[SESSION_MANAGER_LEVEL_MASTER] = new Dictionary<int, IList<string>>();
                        }
                    }

                }
                return (IDictionary<int, IList<string>>)Session[SESSION_MANAGER_LEVEL_MASTER];
            }
        }

        /// <summary>
        /// L[Ǘ}X^ZbV擾܂B
        /// </summary>
        /// <value>ZbV L[ɑΉCtTCN xǗ邽߂̃L[Ǘ}X^B</value>
        protected virtual IDictionary<string, int> KeyMaster
        {
            get
            {
                if (Session[SESSION_MANAGER_KEY_MASTER] == null)
                {
                    lock (_syncRoot)
                    {
                        if (Session[SESSION_MANAGER_KEY_MASTER] == null)
                        {
                            Session[SESSION_MANAGER_KEY_MASTER] = new Dictionary<string, int>();
                        }
                    }
                }
                return (IDictionary<string, int>)Session[SESSION_MANAGER_KEY_MASTER];
            }
        }

        /// <summary>
        /// <see cref="SessionManager"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="session">ZbVB</param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="session"/>  null QƂłB
        /// </exception>
        public SessionManager(HttpSessionState session)
        {
            if (session == null)
            {
                ArgumentNullException exception = new ArgumentNullException("session");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "session"), exception);
                }
                throw exception;
            }

            _session = session;
        }

        /// <summary>
        /// CtTCNǗĂʂ̃ZbVl擾܂B
        /// </summary>
        /// <param name="name">ZbVl̃L[B </param>
        /// <returns>w肳ꂽÕZbVԒlB </returns>
        /// <remarks>
        /// <para>ǂݎpłBZbVւ̓o^͂ł܂B</para>
        /// <para>w肳ꂽ <paramref name="name"/> ̗vfCtTCNǗɂȂꍇ́Anull Ԃ܂B</para>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="name"/> 󕶎łB
        /// </exception>
        public virtual object this[string name]
        {
            get
            {
                if (name == null)
                {
                    ArgumentNullException exception = new ArgumentNullException("name");
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(string.Format(
                            Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                    }
                    throw exception;
                }
                if (name.Length == 0)
                {
                    string message = string.Format(Properties.Resources.E_EMPTY_STRING, "name");
                    ArgumentException exception = new ArgumentException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }

                object value = null;
                IDictionary<string, int> keyMaster = KeyMaster;
                if (keyMaster.ContainsKey(name))
                {
                    value = Session[name];
                }

                return value;
            }
        }

        /// <summary>
        /// VڂZbVɒǉACtTCNǗ܂B
        /// ܂́ÃCtTCNǗĂ鍀ڂXV܂B
        /// </summary>
        /// <param name="name">ZbVɒǉ鍀ڂ̖OB</param>
        /// <param name="value">ZbVɒǉ鍀ڂ̒lB</param>
        /// <param name="lifeCycleLevel">ZbVɒǉ鍀ڂ̃CtTCN xB</param>
        /// <remarks>
        /// <para>CtTCN xɂ0ȏ̐w肵ĂB</para>
        /// <para>CtTCN x0ł󂢊KwƂȂ܂B</para>
        /// <para>
        /// <paramref name="name"/> ̃CtTCN xǗڂQƂꍇA
        /// ̍ڂAw肳ꂽ <paramref name="value"/> ɂď㏑܂B
        /// </para>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="name"/> 󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="lifeCycleLevel"/>  0 菬w肳܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// CtTCNǗÕZbVŁAłɓL[ōڂo^Ă܂B
        /// </item>
        /// <item>
        /// <paramref name="name"/>  <paramref name="lifeCycleLevel"/> ƈقȂ
        /// CtTCN xŁAłɊǗĂ܂B
        /// </item>
        /// </list>
        /// </exception>
        public virtual void Add(string name, Object value, int lifeCycleLevel)
        {
            if (name == null)
            {
                ArgumentNullException exception = new ArgumentNullException("name");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                }
                throw exception;
            }
            if (name.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "name");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            if (lifeCycleLevel < 0)
            {
                string message = string.Format(Properties.Resources.E_LIFE_CYCLE_LEVEL);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ZbVǗɓo^
            RegisterItem(name, value, lifeCycleLevel);
        }

        /// <summary>
        /// w肳ꂽCtTCN x[CtTCN x̍ڂZbV폜A
        /// CtTCNǗO܂B
        /// </summary>
        /// <param name="lifeCycleLevel"> ZbV폜鍀ڂ̃CtTCN xB</param>
        /// <remarks>
        /// <para>
        /// <paramref name="lifeCycleLevel"/>  1 w肵ꍇACtTCN x 1,2,3, ̍ڂA
        /// ZbV폜ACtTCNǗO܂B
        /// </para>
        /// <para>
        /// 폜悤ƂCtTCN xCtTCN xǗɂȂꍇAO̓X[܂B
        /// </para>
        /// </remarks>
        /// <exception cref="ArgumentException">
        /// <paramref name="lifeCycleLevel"/>  0 菬w肳܂B
        /// </exception>
        public virtual void Remove(int lifeCycleLevel)
        {
            if (lifeCycleLevel < 0)
            {
                string message = string.Format(Properties.Resources.E_LIFE_CYCLE_LEVEL);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ZbVǗlifeCycleLevel[Kw̍ڂ폜
            RemoveLevels(lifeCycleLevel);
        }

        /// <summary>
        /// ZbV獀ڂ폜ACtTCNǗO܂B 
        /// </summary>
        /// <param name="name">ZbV폜ACtTCNǗOڂ̖OB </param>
        /// <remarks>
        /// <para>
        /// <paramref name="name"/> Ŏw肳ꂽڂCtTCN xǗɂȂꍇAO̓X[܂B
        /// </para>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="name"/> 󕶎łB
        /// </exception>
        public virtual void Remove(string name)
        {
            if (name == null)
            {
                ArgumentNullException exception = new ArgumentNullException("name");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                }
                throw exception;
            }
            if (name.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "name");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ZbVǗnameL[Ƃēo^Ă鍀ڂ폜
            RemoveItem(name);
        }

        /// <summary>
        /// ZbV烉CtTCNǗɂSẴL[ƒl폜܂B 
        /// </summary>
        public virtual void RemoveAll()
        {
            Remove(0);
        }

        /// <summary>
        /// CtTCNǗĂ邷ׂĂ̒l̃L[擾܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// CtTCN xǗĂȂꍇAvf0 <see cref="IList{String}"/> Ԃ܂B
        /// </para>
        /// </remarks>
        /// <returns>
        /// CtTCNǗĂ邷ׂĂ̒l̃L[i[ <see cref="IList{String}"/>B
        /// </returns>
        public virtual IList<string> GetKeys()
        {
            IDictionary<string, int> keyMaster = KeyMaster;            

            // ̃Rs[Xgɋlߑւ
            IList<string> keyList = new List<string>();
            foreach (string key in keyMaster.Keys)
            {
                keyList.Add(string.Copy(key));
            }

            return keyList;
        }

        /// <summary>
        /// w肵CtTCN xɂ邷ׂĂ̒l̃L[擾܂B
        /// </summary>
        /// <param name="lifeCycleLevel">擾L[̃CtTCN xB</param>
        /// <remarks>
        /// <para>
        /// w肵CtTCN xǗĂȂꍇAvf 0  <see cref="IList{String}"/> Ԃ܂B
        /// </para>
        /// </remarks>
        /// <returns>
        /// <paramref name="lifeCycleLevel"/> Ŏw肵CtTCN xɂ
        /// ׂĂ̒l̃L[i[ <see cref="IList{String}"/>B
        /// </returns>
        /// <exception cref="ArgumentException">
        /// <paramref name="lifeCycleLevel"/> 0菬w肳܂B
        /// </exception>
        public virtual IList<string> GetKeys(int lifeCycleLevel)
        {
            if (lifeCycleLevel < 0)
            {
                string message = string.Format(Properties.Resources.E_LIFE_CYCLE_LEVEL);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            IDictionary<int, IList<string>> levelMaster = LevelMaster;
            IList<string> keyList = new List<string>();
            if (levelMaster.ContainsKey(lifeCycleLevel))
            {
                // ̃Rs[Xgɋlߑւ
                foreach (string key in levelMaster[lifeCycleLevel])
                {
                    keyList.Add(string.Copy(key));
                }
            }

            return keyList;
        }

        /// <summary>
        /// CtTCNǗĂAׂẴCtTCN x擾܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// CtTCN xǗĂȂꍇAvf 0  <see cref="IList{String}"/> Ԃ܂B
        /// </para>
        /// </remarks>
        /// <returns>CtTCNǗĂAׂẴCtTCN xB</returns>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate")]
        public virtual IList<int> GetLifeCycleLevels()
        {
            // xǗ}X^擾
            IDictionary<int, IList<string>> levelMaster = LevelMaster;

            // xǗ}X^̃L[(x)擾ă\[g
            int[] levels = new int[levelMaster.Count];
            levelMaster.Keys.CopyTo(levels, 0);
            Array.Sort(levels);

            // \[gL[(x)Xgɋlߑւ
            IList<int> levelList = new List<int>();
            for (int i = 0; i < levels.Length; i++)
            {
                levelList.Add(levels[i]);
            }

            return levelList;
        }

        /// <summary>
        /// w肵ږ̃CtTCN x擾܂B
        /// </summary>
        /// <param name="name">CtTCN x擾ږB</param>
        /// <remarks>
        /// <para>
        /// w肵ږCtTCNǗĂȂꍇA-1 Ԃ܂B
        /// </para>
        /// </remarks>
        /// <returns>CtTCN xB</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="name"/> 󕶎łB
        /// </exception>
        public virtual int GetLifeCycleLevel(string name)
        {
            if (name == null)
            {
                ArgumentNullException exception = new ArgumentNullException("name");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                }
                throw exception;
            }
            if (name.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "name");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            IDictionary<string, int> keyMaster = KeyMaster;
            int level = -1;
            if (keyMaster.ContainsKey(name))
            {
                level = keyMaster[name];
            }

            return level;
        }

        /// <summary>
        /// VڂZbVɒǉACtTCNǗ܂B
        /// </summary>
        /// <param name="name">ZbVɒǉ鍀ڂ̖OB</param>
        /// <param name="value">ZbVɒǉ鍀ڂ̒lB</param>
        /// <param name="lifeCycleLevel">ZbVɒǉ鍀ڂ̃CtTCN xB</param>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// CtTCNǗÕZbVŁAłɓL[ōڂo^Ă܂B
        /// </item>
        /// <item>
        /// <paramref name="name"/>  <paramref name="lifeCycleLevel"/> ƈقȂ
        /// CtTCN xŁAłɊǗĂ܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual void RegisterItem(string name, object value, int lifeCycleLevel)
        {
            IDictionary<int, IList<string>> levelMaster = LevelMaster;
            IDictionary<string, int> keyMaster = KeyMaster;

            // ZbVɍڂǉł邩mF
            MasterCheck(name, lifeCycleLevel);

            // CtTCNxo^
            IList<string> keyList = null;
            if (levelMaster.ContainsKey(lifeCycleLevel))
            {
                keyList = (IList<string>)levelMaster[lifeCycleLevel];
            }
            else
            {
                keyList = new List<string>();
            }

            if (!keyList.Contains(name))
            {
                keyList.Add(name);
                levelMaster[lifeCycleLevel] = keyList;
                keyMaster[name] = lifeCycleLevel;
            }

            Session[name] = value;
        }

        /// <summary>
        /// w肵CtTCN x[CtTCN x̍ڂZbV폜A
        /// CtTCNǗO܂B
        /// </summary>
        /// <param name="shallowLevel">ZbV폜鍀ڂ̃CtTCN xB</param>
        /// <remarks>
        /// <paramref name="shallowLevel"/>  1 w肵ꍇACtTCN x 1,2,3, ̍ڂA
        /// ZbV폜ACtTCNǗO܂B
        /// </remarks>
        protected virtual void RemoveLevels(int shallowLevel)
        {
            IDictionary<int, IList<string>> levelMaster = LevelMaster;
            IDictionary<string, int> keyMaster = KeyMaster;

            // łKw̐[CtTCNx擾
            int[] levels = new int[levelMaster.Count];
            levelMaster.Keys.CopyTo(levels, 0);
            Array.Sort(levels);
            int deepLevel = -1;
            if (levels.Length != 0)
            {
                deepLevel = levels[levels.Length - 1];
            }

            // shallowLeveldeepLevel܂ł̍ڂ폜
            for (int level = shallowLevel; level <= deepLevel; level++)
            {
                if (levelMaster.ContainsKey(level))
                {
                    IList<string> keyList = levelMaster[level];
                    foreach (string key in keyList)
                    {
                        keyMaster.Remove(key);
                        Session.Remove(key);
                    }
                    levelMaster.Remove(level);
                }
            }
        }

        /// <summary>
        /// ZbV獀ڂ폜ACtTCNǗO܂B 
        /// </summary>
        /// <param name="name">ZbV폜ACtTCNǗOڂ̖OB </param>
        protected virtual void RemoveItem(string name)
        {
            IDictionary<int, IList<string>> levelMaster = LevelMaster;
            IDictionary<string, int> keyMaster = KeyMaster;

            // CtTCNǗĂ鍀ڂ폜
            if (keyMaster.ContainsKey(name))
            {
                int level = keyMaster[name];
                IList<string> keyList = levelMaster[level];
                keyList.Remove(name);
                if (keyList.Count != 0)
                {
                    levelMaster[level] = keyList;
                }
                else
                {
                    levelMaster.Remove(level);
                }

                Session.Remove(name);
                keyMaster.Remove(name);
            }
        }

        /// <summary>
        /// <see cref="SessionManager"/> ŃZbVǗł邩ǂ𔻒f܂B
        /// </summary>
        /// <param name="name">ZbVɒǉ鍀ڂ̖OB</param>
        /// <param name="lifeCycleLevel">ZbVɒǉ鍀ڂ̃CtTCN xB</param>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// CtTCNǗÕZbVŁAł <paramref name="name"/> ƓL[ōڂo^Ă܂B
        /// </item>
        /// <item>
        /// <paramref name="name"/>  <paramref name="lifeCycleLevel"/> ƈقȂ郉CtTCN xŁA
        /// łɊǗĂ܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual void MasterCheck(string name, int lifeCycleLevel)
        {
            IDictionary<string, int> keyMaster = KeyMaster;
            bool isLifeCycleManaged = keyMaster.ContainsKey(name);

            if (isLifeCycleManaged)
            {
                // CtTCN xǗĂ邪AlifeCycleLevelƈقȂ郌xŊǗĂꍇ
                int managedLevel = keyMaster[name];
                if (managedLevel != lifeCycleLevel)
                {
                    TerasolunaException exception = new TerasolunaException(string.Format(Properties.Resources.E_MANAGED_LIFE_CYCLE_LEVEL, name, lifeCycleLevel));
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
            }
            else
            {
                // CtTCN xǗÕZbVŁAłɓL[ŃZbVɓo^Ăꍇ
                bool isRegisteredSession = Session[name] != null;
                if (isRegisteredSession)
                {
                    TerasolunaException exception = new TerasolunaException(string.Format(Properties.Resources.E_REGISTERED_SESSION, name));
                    if(_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
            }
        }
    }
}
