// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.RequestController
{
    /// <summary>
    /// Controller vf̃RNVi[\vf\܂B
    /// </summary>
    public class RequestControllerCollection : ConfigurationElementCollection
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(RequestControllerCollection));

        /// <summary>
        /// <see cref="RequestControllerCollection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public RequestControllerCollection()
        {
        }

        /// <summary>
        /// <see cref="RequestControllerCollection"/> ̌^擾܂B 
        /// </summary>
        /// <remarks>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/>  <seealso cref="ConfigurationElementCollectionType.BasicMap"/> łB
        /// </remarks>
        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.BasicMap;
            }
        }

        /// <summary>
        /// V controller vf쐬܂B
        /// </summary>
        /// <returns>V controller vfB</returns>
        /// <remarks>
        /// V <see cref="RequestControllerElement"/> IuWFNg쐬܂B
        /// </remarks>
        protected override ConfigurationElement CreateNewElement()
        {
            return new RequestControllerElement();
        }

        /// <summary>
        /// w肵CfbNXʒuɂ controller vf擾܂B
        /// </summary>
        /// <param name="index">擾 <see cref="RequestControllerElement"/> ̃CfbNXʒuB</param>
        /// <returns>w肵CfbNXʒuɂ <see cref="RequestControllerElement"/> B</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(int)"/> \bhgpāA<see cref="RequestControllerCollection"/>  <see cref="RequestControllerElement"/> IuWFNg擾܂B
        /// </remarks>
        public RequestControllerElement this[int index]
        {
            get
            {
                return (RequestControllerElement)BaseGet(index);
            }
        }

        /// <summary>
        /// w肵L[ controller vf擾܂B
        /// </summary>
        /// <param name="name">擾 controller vf̃L[BONX\B</param>
        /// <returns>w肵L[ <see cref="RequestControllerElement"/> BȊȌꍇ null QƁB</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(object)"/> \bhgpāA<see cref="RequestControllerCollection"/>  <see cref="RequestControllerElement"/> IuWFNg擾܂B
        /// w肵L[ <see cref="RequestControllerElement"/> IuWFNgRNVɑ݂ȂꍇA null QƂԂ܂B
        /// </remarks>
        public virtual new RequestControllerElement this[string name]
        {
            get
            {
                return (RequestControllerElement)BaseGet(name);
            }
        }

        /// <summary>
        /// <see cref="RequestControllerCollection"/> ̗vf擾܂B
        /// </summary>
        /// <value>
        /// <see cref="RequestControllerCollection"/> ̗vfB
        /// </value>
        public virtual new int Count
        {
            get
            {
                return base.Count;
            }
        }

        /// <summary>
        /// vf̃RNVʂ邽߂Ɏgp閼O擾܂B
        /// </summary>
        /// <remarks>
        /// vf "controller" łB
        /// </remarks>
        protected override string ElementName
        {
            get
            {
                return "controller";
            }
        }
        /// <summary>
        /// exceptionTransition vf̗vfL[擾܂B
        /// </summary>
        /// <param name="element">L[Ԃ <see cref="RequestControllerElement"/> B</param>
        /// <returns>w肵 <see cref="RequestControllerElement"/> ̃L[Ƃċ@\ <see cref="Object"/> B</returns>
        /// <remarks>ɂȂB</remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="element"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="element"/>  <see cref="RequestControllerElement"/> ł͂܂B
        /// </exception>
        protected override Object GetElementKey(ConfigurationElement element)
        {
            if (element == null)
            {
                ArgumentNullException exception = new ArgumentNullException("element");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Web.Properties.Resources.E_NULL_ARGUMENT, "element"), exception);
                }
                throw exception;
            }
            RequestControllerElement controllerElement = element as RequestControllerElement;
            if (controllerElement == null)
            {
                string message = string.Format(Web.Properties.Resources.E_INVALID_TYPE, "element");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return controllerElement.Name;
        }

        /// <summary>
        /// <see cref="RequestControllerCollection"/>  controller vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="RequestControllerElement"/> B</param>
        /// <remarks>
        /// <seealso cref="BaseAdd(ConfigurationElement)"/> \bhgpāARNVɐV <see cref="RequestControllerElement"/> ǉ܂B
        /// </remarks>
        public virtual void Add(RequestControllerElement element)
        {
            BaseAdd(element);
        }

        /// <summary>
        /// <see cref="RequestControllerCollection"/>  controller vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="RequestControllerCollection"/> B</param>
        /// <remarks>
        /// w肵 <paramref name="element"/>  controller vfRNVɊɑ݂ꍇAO͔܂B
        /// </remarks>
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        /// <summary>
        /// <see cref="RequestControllerCollection"/> IuWFNgǂݎpǂl擾܂B 
        /// </summary>
        /// <returns>
        /// <see cref="RequestControllerCollection"/> IuWFNgǂݎp̏ꍇ true BȊȌꍇ false B
        /// </returns>
        /// <remarks>
        /// <see cref="RequestControllerCollection"/> IuWFNg͓ǂݎpł͂܂B
        /// </remarks>
        public override bool IsReadOnly()
        {
            return false;
        }

    }
}
